/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.ucl.test;

import java.io.Serializable;
import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.test.aop.classpool.ucl.test.UclClassPoolTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UclDelegatingClassPoolTestCase
extends UclClassPoolTest {
    public UclDelegatingClassPoolTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(UclDelegatingClassPoolTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGlobalScope() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        try {
            try {
                globalA = this.createGlobalClassPool(JAR_A_1);
                globalB = this.createGlobalClassPool(JAR_B_1);
                this.accessGlobalScope(globalA, globalB);
                this.accessGlobalScope(globalA, globalB);
            }
            finally {
                this.removeClassPool(globalA);
            }
            this.assertCannotLoadCtClass(globalB, "org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalB);
            throw throwable;
        }
        this.removeClassPool(globalB);
    }

    private void accessGlobalScope(ClassPool globalA, ClassPool globalB) throws Exception {
        CtClass aFromA = globalA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromA);
        UclDelegatingClassPoolTestCase.assertEquals((String)"org.jboss.test.aop.classpool.ucl.support.excluded.a.A", (String)aFromA.getName());
        CtClass bFromA = globalA.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)bFromA);
        UclDelegatingClassPoolTestCase.assertEquals((String)"org.jboss.test.aop.classpool.ucl.support.excluded.b.B", (String)bFromA.getName());
        CtClass aFromB = globalB.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromB);
        UclDelegatingClassPoolTestCase.assertSame((Object)aFromA, (Object)aFromB);
        CtClass bFromB = globalB.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)bFromB);
        UclDelegatingClassPoolTestCase.assertSame((Object)bFromA, (Object)bFromB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildDomain() throws Exception {
        ClassPool poolA = null;
        ClassPool poolB = null;
        ClassPool poolC = null;
        try {
            poolA = this.createGlobalClassPool(JAR_A_1);
            poolB = this.createGlobalClassPool(JAR_B_1);
            poolC = this.createChildClassPool(JAR_C_1, false);
            this.accessChildDomain(poolA, poolB, poolC);
            this.accessChildDomain(poolA, poolB, poolC);
        }
        catch (Throwable throwable) {
            this.removeClassPool(poolA);
            this.removeClassPool(poolB);
            this.removeClassPool(poolC);
            throw throwable;
        }
        this.removeClassPool(poolA);
        this.removeClassPool(poolB);
        this.removeClassPool(poolC);
    }

    private void accessChildDomain(ClassPool poolA, ClassPool poolB, ClassPool poolC) throws Exception {
        CtClass aFromA = poolA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromA);
        CtClass bFromB = poolB.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)bFromB);
        CtClass cFromC = poolC.get("org.jboss.test.aop.classpool.ucl.support.excluded.c.C");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)cFromC);
        CtClass aFromC = poolC.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromC);
        CtClass bFromC = poolC.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        UclDelegatingClassPoolTestCase.assertNotNull((Object)bFromC);
        UclDelegatingClassPoolTestCase.assertSame((Object)aFromA, (Object)aFromC);
        UclDelegatingClassPoolTestCase.assertSame((Object)bFromB, (Object)bFromC);
        UclDelegatingClassPoolTestCase.assertSame((Object)poolA, (Object)aFromA.getClassPool());
        UclDelegatingClassPoolTestCase.assertSame((Object)poolB, (Object)bFromB.getClassPool());
        UclDelegatingClassPoolTestCase.assertSame((Object)poolC, (Object)cFromC.getClassPool());
        this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.ucl.support.excluded.c.C");
        this.assertCannotLoadCtClass(poolB, "org.jboss.test.aop.classpool.ucl.support.excluded.c.C");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSiblingDomains() throws Exception {
        ClassPool poolA = this.createChildClassPool(JAR_A_1, true);
        ClassPool poolB = this.createChildClassPool(JAR_B_1, false);
        try {
            this.accessSiblingDomains(poolA, poolB);
        }
        finally {
            this.removeClassPool(poolA);
            this.removeClassPool(poolB);
        }
    }

    private void accessSiblingDomains(ClassPool poolA, ClassPool poolB) throws Exception {
        CtClass clazzA = poolA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        UclDelegatingClassPoolTestCase.assertSame((Object)poolA, (Object)clazzA.getClassPool());
        CtClass clazzB = poolB.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        UclDelegatingClassPoolTestCase.assertSame((Object)poolB, (Object)clazzB.getClassPool());
        this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        this.assertCannotLoadCtClass(poolB, "org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildWithNewClassesInParent() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            scopedPool = this.createChildClassPool(JAR_B_1, true);
            this.assertCannotLoadCtClass(scopedPool, "org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            globalPool = this.createGlobalClassPool(JAR_A_1);
            CtClass aFromChild = scopedPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromChild);
            CtClass aFromParent = globalPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromParent);
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromChild, (Object)aFromParent);
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPool, (Object)aFromParent.getClassPool());
            CtClass aFromChild2 = scopedPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromChild, (Object)aFromChild2);
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalPool);
            this.removeClassPool(scopedPool);
            throw throwable;
        }
        this.removeClassPool(globalPool);
        this.removeClassPool(scopedPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            globalPool = this.createGlobalClassPool(JAR_A_1);
            scopedPool = this.createChildClassPool(JAR_A_2, true);
            CtClass aFromParent = globalPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromParent);
            CtClass aFromChild = scopedPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromChild);
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromParent, (Object)aFromChild);
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPool, (Object)aFromParent.getClassPool());
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalPool);
            this.removeClassPool(scopedPool);
            throw throwable;
        }
        this.removeClassPool(globalPool);
        this.removeClassPool(scopedPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithNoParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            globalPool = this.createGlobalClassPool(JAR_A_1);
            scopedPool = this.createChildClassPool(JAR_A_2, false);
            CtClass aFromParent = globalPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromParent);
            CtClass aFromChild = scopedPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertNotNull((Object)aFromChild);
            UclDelegatingClassPoolTestCase.assertNotSame((Object)aFromParent, (Object)aFromChild);
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPool, (Object)aFromParent.getClassPool());
            UclDelegatingClassPoolTestCase.assertSame((Object)scopedPool, (Object)aFromChild.getClassPool());
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalPool);
            this.removeClassPool(scopedPool);
            throw throwable;
        }
        this.removeClassPool(globalPool);
        this.removeClassPool(scopedPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURLChildOfGlobalUclParentFirst() throws Exception {
        ClassPool globalPool = null;
        ClassPool childA = null;
        ClassPool childB = null;
        try {
            globalPool = this.createGlobalClassPool(JAR_A_1);
            childA = this.createChildURLClassPool(globalPool, JAR_B_1);
            CtClass aFromA = childA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPool, (Object)aFromA.getClassPool());
            CtClass aFromGlobal = globalPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromA, (Object)aFromGlobal);
            CtClass bFromA = childA.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)childA, (Object)bFromA.getClassPool());
            childB = this.createChildURLClassPool(globalPool, JAR_A_2);
            CtClass aFromB = childB.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPool, (Object)aFromB.getClassPool());
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalPool);
            this.removeClassPool(childA);
            this.removeClassPool(childB);
            throw throwable;
        }
        this.removeClassPool(globalPool);
        this.removeClassPool(childA);
        this.removeClassPool(childB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURLChildOfGlobalUcParentLast() throws Exception {
        ClassPool globalPool = null;
        ClassPool childA = null;
        ClassPool childB = null;
        try {
            globalPool = this.createGlobalClassPool(JAR_A_1);
            childA = this.createChildURLClassPoolParentLast(globalPool, JAR_B_1);
            CtClass aFromA = childA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPool, (Object)aFromA.getClassPool());
            CtClass aFromGlobal = globalPool.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromA, (Object)aFromGlobal);
            CtClass bFromA = childA.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)childA, (Object)bFromA.getClassPool());
            childB = this.createChildURLClassPoolParentLast(globalPool, JAR_A_2);
            CtClass aFromB = childB.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)childB, (Object)aFromB.getClassPool());
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalPool);
            this.removeClassPool(childA);
            this.removeClassPool(childB);
            throw throwable;
        }
        this.removeClassPool(globalPool);
        this.removeClassPool(childA);
        this.removeClassPool(childB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURLChildOfGlobalUclParentFirstWithClassInGlobalSibling() throws Exception {
        ClassPool globalPoolA = null;
        ClassPool globalPoolB = null;
        ClassPool childC = null;
        ClassPool childB = null;
        try {
            globalPoolA = this.createGlobalClassPool(JAR_A_1);
            globalPoolB = this.createGlobalClassPool(JAR_B_1);
            childC = this.createChildURLClassPool(globalPoolA, JAR_C_1);
            CtClass bFromC = childC.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPoolB, (Object)bFromC.getClassPool());
            CtClass bFromGlobalA = globalPoolA.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)bFromC, (Object)bFromGlobalA);
            CtClass cFromC = childC.get("org.jboss.test.aop.classpool.ucl.support.excluded.c.C");
            UclDelegatingClassPoolTestCase.assertSame((Object)childC, (Object)cFromC.getClassPool());
            childB = this.createChildURLClassPool(globalPoolA, JAR_B_2);
            CtClass bFromB = childB.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)globalPoolB, (Object)bFromB.getClassPool());
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalPoolA);
            this.removeClassPool(globalPoolB);
            this.removeClassPool(childC);
            this.removeClassPool(childB);
            throw throwable;
        }
        this.removeClassPool(globalPoolA);
        this.removeClassPool(globalPoolB);
        this.removeClassPool(childC);
        this.removeClassPool(childB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUndeploySibling() throws Exception {
        ClassPool poolA = null;
        ClassPool poolB = null;
        try {
            try {
                poolA = this.createGlobalClassPool(JAR_A_1);
                this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
                poolB = this.createGlobalClassPool(JAR_B_1);
                CtClass bFromA = poolA.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
                UclDelegatingClassPoolTestCase.assertSame((Object)poolB, (Object)bFromA.getClassPool());
            }
            catch (Throwable throwable) {
                this.removeClassPool(poolB);
                throw throwable;
            }
            this.removeClassPool(poolB);
            this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.removeClassPool(poolA);
            this.removeClassPool(poolB);
            throw throwable;
        }
        this.removeClassPool(poolA);
        this.removeClassPool(poolB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclWithParentClassLoader() throws Exception {
        ClassPool parent = null;
        ClassPool global = null;
        try {
            parent = this.createChildURLClassPool(null, JAR_B_1);
            global = this.createGlobalClassPoolWithParent(JAR_A_1, parent);
            CtClass aFromGlobal = global.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)global, (Object)aFromGlobal.getClassPool());
            CtClass aFromGlobal2 = global.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromGlobal, (Object)aFromGlobal2);
            CtClass bFromGlobal = global.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)parent, (Object)bFromGlobal.getClassPool());
            CtClass bFromGlobal2 = global.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)bFromGlobal, (Object)bFromGlobal2);
            CtClass bFromParent = parent.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)parent, (Object)bFromParent.getClassPool());
            UclDelegatingClassPoolTestCase.assertSame((Object)bFromGlobal, (Object)bFromParent);
            CtClass bFromParent2 = parent.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)bFromParent, (Object)bFromParent2);
        }
        catch (Throwable throwable) {
            this.removeClassPool(global);
            this.removeClassPool(parent);
            throw throwable;
        }
        this.removeClassPool(global);
        this.removeClassPool(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclWithParentClassLoaderAndSameClassInDomain() throws Exception {
        ClassPool parent = null;
        ClassPool globalA = null;
        ClassPool globalB = null;
        try {
            parent = this.createChildURLClassPool(null, JAR_B_1);
            globalA = this.createGlobalClassPoolWithParent(JAR_A_1, parent);
            CtClass aFromGlobal = globalA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)globalA, (Object)aFromGlobal.getClassPool());
            CtClass aFromGlobal2 = globalA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromGlobal, (Object)aFromGlobal2);
            globalB = this.createGlobalClassPool(JAR_B_2);
            CtClass bFromGlobalA = globalA.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)globalB, (Object)bFromGlobalA.getClassPool());
            CtClass bFromGlobalA2 = globalA.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)bFromGlobalA, (Object)bFromGlobalA2);
            CtClass bFromParent = parent.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)parent, (Object)bFromParent.getClassPool());
            UclDelegatingClassPoolTestCase.assertNotSame((Object)bFromGlobalA, (Object)bFromParent);
            CtClass bFromParent2 = parent.get("org.jboss.test.aop.classpool.ucl.support.excluded.b.B");
            UclDelegatingClassPoolTestCase.assertSame((Object)bFromParent, (Object)bFromParent2);
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalA);
            this.removeClassPool(globalB);
            this.removeClassPool(parent);
            throw throwable;
        }
        this.removeClassPool(globalA);
        this.removeClassPool(globalB);
        this.removeClassPool(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGeneratingClassInNonDelegatingPool() throws Exception {
        ClassPool parent = null;
        ClassPool global = null;
        ClassPool child = null;
        try {
            String PARENT = "parent.Parent";
            String CHILD = "child.Child";
            parent = this.createChildURLClassPool(null, JAR_B_1);
            global = this.createGlobalClassPoolWithParent(JAR_A_1, parent);
            child = this.createChildURLClassPool(global, JAR_C_1);
            this.assertCannotLoadCtClass(parent, "parent.Parent");
            this.assertCannotLoadCtClass(global, "parent.Parent");
            this.assertCannotLoadCtClass(child, "parent.Parent");
            this.assertCannotLoadCtClass(child, "child.Child");
            CtClass parentClass = parent.makeClass("parent.Parent");
            CtClass childClass = child.makeClass("child.Child");
            childClass.setSuperclass(parentClass);
            CtClass parentFromParent = parent.get("parent.Parent");
            UclDelegatingClassPoolTestCase.assertSame((Object)parent, (Object)parentFromParent.getClassPool());
            UclDelegatingClassPoolTestCase.assertSame((Object)parentClass, (Object)parentFromParent);
            CtClass childFromChild = child.get("child.Child");
            UclDelegatingClassPoolTestCase.assertSame((Object)child, (Object)childFromChild.getClassPool());
            UclDelegatingClassPoolTestCase.assertSame((Object)childClass, (Object)childFromChild);
            this.assertCannotLoadCtClass(global, "child.Child");
            CtClass parentFromChildA = childClass.getSuperclass();
            UclDelegatingClassPoolTestCase.assertSame((Object)parentClass, (Object)parentFromChildA);
            CtClass parentFromChildB = child.get("parent.Parent");
            UclDelegatingClassPoolTestCase.assertSame((Object)parentClass, (Object)parentFromChildB);
            Class parentClazz = parentClass.toClass();
            UclDelegatingClassPoolTestCase.assertSame((Object)parent.getClassLoader(), (Object)parentClazz.getClassLoader());
            Class childClazz = childClass.toClass();
            UclDelegatingClassPoolTestCase.assertSame((Object)child.getClassLoader(), (Object)childClazz.getClassLoader());
            Class<?> parentClazzFromParent = parent.getClassLoader().loadClass("parent.Parent");
            UclDelegatingClassPoolTestCase.assertSame((Object)parentClazz, parentClazzFromParent);
            Class<?> parentClazzFromChild = parent.getClassLoader().loadClass("parent.Parent");
            UclDelegatingClassPoolTestCase.assertSame((Object)parentClazz, parentClazzFromChild);
            Class<?> childClazzFromChild = child.getClassLoader().loadClass("child.Child");
            UclDelegatingClassPoolTestCase.assertSame((Object)childClazz, childClazzFromChild);
            child.getClassLoader().loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
        }
        catch (Throwable throwable) {
            this.removeClassPool(parent);
            this.removeClassPool(global);
            this.removeClassPool(child);
            throw throwable;
        }
        this.removeClassPool(parent);
        this.removeClassPool(global);
        this.removeClassPool(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGeneratingClassInDelegatingPool() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        ClassPool child = null;
        try {
            globalA = this.createGlobalClassPool(JAR_A_1);
            globalB = this.createGlobalClassPool(JAR_B_1);
            child = this.createChildURLClassPool(globalA, JAR_C_1);
            String A_CLASS = "a.Clazz";
            String B_CLASS = "b.Clazz";
            this.assertCannotLoadCtClass(globalA, "a.Clazz");
            this.assertCannotLoadCtClass(globalB, "a.Clazz");
            this.assertCannotLoadCtClass(child, "a.Clazz");
            this.assertCannotLoadCtClass(globalA, "b.Clazz");
            this.assertCannotLoadCtClass(globalB, "b.Clazz");
            this.assertCannotLoadCtClass(child, "b.Clazz");
            CtClass a = globalA.makeClass("a.Clazz");
            CtClass b = globalB.makeClass("b.Clazz");
            CtClass aFromA = globalA.get("a.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)a, (Object)aFromA);
            UclDelegatingClassPoolTestCase.assertSame((Object)globalA, (Object)aFromA.getClassPool());
            CtClass aFromB = globalB.get("a.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)a, (Object)aFromB);
            CtClass bFromA = globalA.get("b.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)b, (Object)bFromA);
            UclDelegatingClassPoolTestCase.assertSame((Object)globalB, (Object)bFromA.getClassPool());
            CtClass bFromB = globalB.get("b.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)b, (Object)bFromB);
            CtClass aFromChild = child.get("a.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)a, (Object)aFromChild);
            CtClass bFromChild = child.get("b.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)b, (Object)bFromChild);
            Class clazzA = a.toClass();
            UclDelegatingClassPoolTestCase.assertSame((Object)globalA.getClassLoader(), (Object)clazzA.getClassLoader());
            Class clazzB = b.toClass();
            UclDelegatingClassPoolTestCase.assertSame((Object)globalB.getClassLoader(), (Object)clazzB.getClassLoader());
            Class<?> clazzAFromA = globalA.getClassLoader().loadClass("a.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)clazzA, clazzAFromA);
            Class<?> clazzAFromB = globalB.getClassLoader().loadClass("a.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)clazzA, clazzAFromB);
            Class<?> clazzAFromChild = child.getClassLoader().loadClass("a.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)clazzA, clazzAFromChild);
            Class<?> clazzBFromA = globalA.getClassLoader().loadClass("b.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)clazzB, clazzBFromA);
            Class<?> clazzBFromB = globalB.getClassLoader().loadClass("b.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)clazzB, clazzBFromB);
            Class<?> clazzBFromChild = child.getClassLoader().loadClass("b.Clazz");
            UclDelegatingClassPoolTestCase.assertSame((Object)clazzB, clazzBFromChild);
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalA);
            this.removeClassPool(globalB);
            this.removeClassPool(child);
            throw throwable;
        }
        this.removeClassPool(globalA);
        this.removeClassPool(globalB);
        this.removeClassPool(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclLoaderOrdering() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        ClassPool globalC = null;
        try {
            globalA = this.createGlobalClassPool(JAR_A_1);
            globalB = this.createGlobalClassPool(JAR_A_1);
            globalC = this.createGlobalClassPool(JAR_A_1);
            CtClass aFromA = globalA.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            CtClass aFromB = globalB.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            CtClass aFromC = globalC.get("org.jboss.test.aop.classpool.ucl.support.excluded.a.A");
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromA, (Object)aFromB);
            UclDelegatingClassPoolTestCase.assertSame((Object)aFromA, (Object)aFromC);
            UclDelegatingClassPoolTestCase.assertSame((Object)globalA, (Object)aFromA.getClassPool());
        }
        catch (Throwable throwable) {
            this.removeClassPool(globalA);
            this.removeClassPool(globalB);
            this.removeClassPool(globalC);
            throw throwable;
        }
        this.removeClassPool(globalA);
        this.removeClassPool(globalB);
        this.removeClassPool(globalC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMakeContainerProxyInSamePackage() throws Exception {
        ClassPool globalPoolA = null;
        ClassPool globalPoolB = null;
        try {
            globalPoolA = this.createGlobalClassPool(JAR_A_1);
            globalPoolB = this.createGlobalClassPool(JAR_B_1);
            ClassLoader loaderA = globalPoolA.getClassLoader();
            ClassLoader loaderB = globalPoolB.getClassLoader();
            Object proxyA = this.assertMakeContainerProxy(loaderA.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.a.A"), loaderA);
            Object proxyB = this.assertMakeContainerProxy(loaderB.loadClass("org.jboss.test.aop.classpool.ucl.support.excluded.b.B"), loaderB);
            Class<?> clazzA = proxyA.getClass();
            Class<?> clazzB = proxyB.getClass();
            UclDelegatingClassPoolTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzA));
            UclDelegatingClassPoolTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzB));
            UclDelegatingClassPoolTestCase.assertTrue((boolean)clazzA.getName().startsWith("org.jboss.test.aop.classpool.ucl.support.excluded.a."));
            UclDelegatingClassPoolTestCase.assertTrue((boolean)clazzB.getName().startsWith("org.jboss.test.aop.classpool.ucl.support.excluded.b."));
            UclDelegatingClassPoolTestCase.assertSame(clazzA, loaderA.loadClass(clazzA.getName()));
            UclDelegatingClassPoolTestCase.assertSame(clazzB, loaderA.loadClass(clazzB.getName()));
            UclDelegatingClassPoolTestCase.assertSame(clazzA, loaderB.loadClass(clazzA.getName()));
            UclDelegatingClassPoolTestCase.assertSame(clazzB, loaderB.loadClass(clazzB.getName()));
        }
        finally {
            this.removeClassPool(globalPoolA);
            this.removeClassPool(globalPoolB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMakeContainerProxyForSystemClass() throws Exception {
        ClassPool globalPoolA = null;
        ClassPool globalPoolB = null;
        try {
            globalPoolA = this.createGlobalClassPool(JAR_A_1);
            globalPoolB = this.createGlobalClassPool(JAR_B_1);
            ClassLoader loaderA = globalPoolA.getClassLoader();
            ClassLoader loaderB = globalPoolB.getClassLoader();
            Object proxyA = this.assertMakeContainerProxy(ArrayList.class, loaderA);
            Object proxyB = this.assertMakeContainerProxy(ArrayList.class, loaderB);
            Class<?> clazzA = proxyA.getClass();
            Class<?> clazzB = proxyB.getClass();
            UclDelegatingClassPoolTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzA));
            UclDelegatingClassPoolTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzB));
            UclDelegatingClassPoolTestCase.assertTrue((boolean)clazzA.getName().startsWith("org.jboss.aop.generatedproxies"));
            UclDelegatingClassPoolTestCase.assertTrue((boolean)clazzB.getName().startsWith("org.jboss.aop.generatedproxies"));
            UclDelegatingClassPoolTestCase.assertSame(clazzA, loaderA.loadClass(clazzA.getName()));
            UclDelegatingClassPoolTestCase.assertSame(clazzB, loaderA.loadClass(clazzB.getName()));
            UclDelegatingClassPoolTestCase.assertSame(clazzA, loaderB.loadClass(clazzA.getName()));
            UclDelegatingClassPoolTestCase.assertSame(clazzB, loaderB.loadClass(clazzB.getName()));
        }
        finally {
            this.removeClassPool(globalPoolA);
            this.removeClassPool(globalPoolB);
        }
    }

    private Object assertMakeContainerProxy(Class<?> parent, ClassLoader loader) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(parent);
        params.setTarget(parent.newInstance());
        params.setClassLoader(loader);
        params.setInterfaces(new Class[]{Serializable.class});
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        Object proxy = factory.createAdvisedProxy(params);
        UclDelegatingClassPoolTestCase.assertFalse((parent.getName() == proxy.getClass().getName() ? 1 : 0) != 0);
        UclDelegatingClassPoolTestCase.assertSame((Object)loader, (Object)proxy.getClass().getClassLoader());
        return proxy;
    }
}

