/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool.jbosscl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.jboss5.DomainRegistry;
import org.jboss.aop.asintegration.jboss5.RegisterModuleCallback;
import org.jboss.aop.classpool.AbstractJBossDelegatingClassPoolFactory;
import org.jboss.aop.classpool.ClassPoolDomain;
import org.jboss.aop.classpool.ClassPoolDomainRegistry;
import org.jboss.aop.classpool.ClassPoolToClassPoolDomainAdapter;
import org.jboss.aop.classpool.NonDelegatingClassPool;
import org.jboss.aop.classpool.jbosscl.JBossClClassPoolDomain;
import org.jboss.aop.classpool.jbosscl.JBossClDelegatingClassPool;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;

public class JBossClDelegatingClassPoolFactory
extends AbstractJBossDelegatingClassPoolFactory
implements ScopedClassPoolFactory {
    private final DomainRegistry registry;
    private final RegisterModuleCallback registerModuleCallback;

    public JBossClDelegatingClassPoolFactory(DomainRegistry registry, RegisterModuleCallback registerModuleCallback) {
        this.registry = registry;
        this.registerModuleCallback = registerModuleCallback;
    }

    public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        ClassPool parent = this.getCreateParentClassPools(cl, src, repository);
        if (cl instanceof RealClassLoader) {
            Module module = this.registry.getModule(cl);
            if (module == null) {
                module = this.getModuleForClassLoader(cl);
            }
            this.registerModuleCallback.registerModule(module);
            this.registerBootstrapLoaders();
            ClassPoolDomain domain = this.getDomain(module, cl);
            return new JBossClDelegatingClassPool(domain, cl, parent, repository, module);
        }
        return new NonDelegatingClassPool(cl, parent, repository, true);
    }

    private ClassPoolDomain getDomain(Module module, ClassLoader cl) {
        Object poolDomain;
        ClassLoaderDomain domain = null;
        ClassLoaderSystem sys = this.registry.getSystem();
        if (module != null && module.getDeterminedParentDomainName() != null) {
            domain = sys.getDomain(module.getDeterminedDomainName());
        }
        if (domain == null) {
            domain = this.registry.getDefaultDomain();
        }
        if ((poolDomain = ClassPoolDomainRegistry.getInstance().getDomain(domain)) == null) {
            ClassLoader parentUnitLoader;
            String parentDomainName = domain.getParentDomainName();
            ClassPoolDomain parentPoolDomain = null;
            if (parentDomainName != null) {
                ClassLoaderDomain parentDomain = sys.getDomain(parentDomainName);
                if (parentDomain == null) {
                    throw new RuntimeException("No domain found called: " + parentDomainName);
                }
                parentPoolDomain = ClassPoolDomainRegistry.getInstance().getDomain((Object)parentDomain);
            }
            if (parentDomainName == null && (parentUnitLoader = this.registry.getParentUnitLoader(cl)) != null) {
                ClassPool parentUnitPool = AspectManager.getTopLevelAspectManager().registerClassLoader(parentUnitLoader);
                parentPoolDomain = new ClassPoolToClassPoolDomainAdapter(parentUnitPool);
            }
            poolDomain = new JBossClClassPoolDomain(domain.getName(), parentPoolDomain, domain.getParentPolicy(), this.registry);
            ClassPoolDomainRegistry.getInstance().addClassPoolDomain((Object)domain, poolDomain);
        }
        return poolDomain;
    }

    protected ClassPool getCreateParentClassPools(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        ClassPool parent = super.getCreateParentClassPools(cl, src, repository);
        if (parent == ClassPool.getDefault()) {
            return null;
        }
        return parent;
    }

    private void registerBootstrapLoaders() {
        Set<Module> unregistered = this.registerModuleCallback.getUnregisteredModules();
        if (unregistered.size() > 0) {
            for (Module module : unregistered) {
                ClassLoader loader = this.getClassLoaderForModule(module);
                this.log.debug((Object)("Registering loader for module " + module + ": " + loader));
                AspectManager.instance().registerClassLoader(loader);
            }
        }
    }

    private ClassLoader getClassLoaderForModule(final Module module) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoading.getClassLoaderForModule((Module)module);
            }
        });
    }

    private Module getModuleForClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Module>(){

            @Override
            public Module run() {
                return ClassLoading.getModuleForClassLoader((ClassLoader)classLoader);
            }
        });
    }
}

