/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import java.net.URL;
import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.jboss5.DomainRegistry;
import org.jboss.aop.asintegration.jboss5.JBoss5ClassPool;
import org.jboss.aop.asintegration.jboss5.ScopedJBoss5ClassPool;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.AbstractJBossClassPoolFactory;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.classloading.spi.dependency.Module;

public class JBoss5ClassPoolFactory
extends AbstractJBossClassPoolFactory
implements ScopedClassPoolFactory {
    private DomainRegistry registry;

    public JBoss5ClassPoolFactory(DomainRegistry registry) {
        this.registry = registry;
    }

    public ScopedClassPool create(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        ClassPool parent = this.getCreateParentClassPools(cl, src, repository);
        AOPClassPool pool = null;
        if (cl instanceof RealClassLoader) {
            Module module = this.registry.getModule(cl);
            if (module != null && module.getDeterminedParentDomainName() != null) {
                ClassLoaderSystem sys = this.registry.getSystem();
                ClassLoaderDomain domain = sys.getDomain(module.getDeterminedDomainName());
                boolean parentFirst = module.isJ2seClassLoadingCompliance();
                ClassPool parentDomainPool = this.getParentUnitClassPool(cl);
                pool = new ScopedJBoss5ClassPool(cl, parent, parentDomainPool, repository, this.getTempURL(module), parentFirst, domain);
            } else {
                pool = new JBoss5ClassPool(cl, parent, repository, this.getTempURL(module));
            }
        }
        if (pool == null) {
            pool = new AOPClassPool(cl, parent, repository);
        }
        this.log.debug((Object)("Created pool " + pool + " for loader " + cl));
        return pool;
    }

    private ClassPool getParentUnitClassPool(ClassLoader cl) {
        ClassLoader parent = this.registry.getParentUnitLoader(cl);
        return AspectManager.instance().registerClassLoader(parent);
    }

    private URL getTempURL(Module module) {
        if (module == null) {
            return null;
        }
        return module.getDynamicClassRoot();
    }
}

