/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import javassist.ClassPool;
import junit.framework.Test;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.support.Result;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassPoolWithHierarchicalDomainTestCase
extends JBossClClassPoolTest {
    public ClassPoolWithHierarchicalDomainTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassPoolWithHierarchicalDomainTestCase.suite(ClassPoolWithHierarchicalDomainTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentFirst() throws Exception {
        ClassPool poolParentA = null;
        Result resultParentA = new Result();
        try {
            poolParentA = this.createClassPool(resultParentA, "aParent", true, JAR_A_1);
            this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolParentA);
            this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolParentA);
            ClassPool poolChildA = null;
            Result resultChildA = new Result();
            String childDomainName = "ChildDomain";
            try {
                poolChildA = this.createChildDomainParentFirstClassPool(resultChildA, "aChild", "ChildDomain", true, JAR_A_2);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolChildA, poolParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolChildA);
                ClassPool poolB = null;
                Result resultB = new Result();
                try {
                    BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                    poolB = this.createChildDomainParentFirstClassPool(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                    this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolParentA);
                    this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
                    this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, poolParentA);
                }
                catch (Throwable throwable) {
                    this.unregisterClassPool(poolB);
                    throw throwable;
                }
                this.unregisterClassPool(poolB);
                this.assertNoClassPool(resultB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(poolChildA);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassPool(poolChildA);
            this.unregisterDomain("ChildDomain");
            this.assertNoClassPool(resultChildA);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolParentA);
            throw throwable;
        }
        this.unregisterClassPool(poolParentA);
        this.assertNoClassPool(resultParentA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLast() throws Exception {
        ClassPool clParentA = null;
        Result resultParentA = new Result();
        try {
            clParentA = this.createClassPool(resultParentA, "aParent", true, JAR_A_1);
            this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
            this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
            ClassPool poolChildA = null;
            Result resultChildA = new Result();
            String childDomainName = "ChildDomain";
            try {
                poolChildA = this.createChildDomainParentLastClassPool(resultChildA, "aChild", "ChildDomain", true, JAR_A_2);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolChildA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolChildA);
                ClassPool poolB = null;
                Result resultB = new Result();
                try {
                    BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                    poolB = this.createChildDomainParentLastClassPool(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                    this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolChildA);
                    this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
                    this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, poolChildA);
                }
                catch (Throwable throwable) {
                    this.unregisterClassPool(poolB);
                    throw throwable;
                }
                this.unregisterClassPool(poolB);
                this.assertNoClassPool(resultB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(poolChildA);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassPool(poolChildA);
            this.unregisterDomain("ChildDomain");
            this.assertNoClassPool(resultChildA);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clParentA);
            throw throwable;
        }
        this.unregisterClassPool(clParentA);
        this.assertNoClassPool(resultParentA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLastNotInChild() throws Exception {
        ClassPool clParentA = null;
        Result resultParentA = new Result();
        try {
            clParentA = this.createClassPool(resultParentA, "aParent", true, JAR_A_1);
            this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
            this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
            ClassPool poolB = null;
            Result resultB = new Result();
            String childDomainName = "ChildDomain";
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                poolB = this.createChildDomainParentLastClassPool(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(poolB);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassPool(poolB);
            this.unregisterDomain("ChildDomain");
            this.assertNoClassPool(resultB);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clParentA);
            throw throwable;
        }
        this.unregisterClassPool(clParentA);
        this.assertNoClassPool(resultParentA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentFirstWrongWayAround() throws Exception {
        ClassPool poolB = null;
        Result resultB = new Result();
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                poolB = this.createChildDomainParentFirstClassPool(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                ClassPoolWithHierarchicalDomainTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassPool(resultB);
            ClassPool clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createClassPool(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                poolB = this.assertClassPool(resultB.getFactory());
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clParentA);
                throw throwable;
            }
            this.unregisterClassPool(clParentA);
            this.assertNoClassPool(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassPool(poolB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassPool(resultB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLastWrongWayAround() throws Exception {
        ClassPool poolB = null;
        Result resultB = new Result();
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                poolB = this.createChildDomainParentLastClassPool(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                ClassPoolWithHierarchicalDomainTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassPool(resultB);
            ClassPool clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createClassPool(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                poolB = this.assertClassPool(resultB.getFactory());
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clParentA);
                throw throwable;
            }
            this.unregisterClassPool(clParentA);
            this.assertNoClassPool(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassPool(poolB);
        this.unregisterDomain("ChildDomain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentRedeploy() throws Exception {
        ClassPool poolB = null;
        Result resultB = new Result();
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                poolB = this.createChildDomainParentFirstClassPool(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                ClassPoolWithHierarchicalDomainTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassPool(resultB);
            ClassPool clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createClassPool(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                poolB = this.assertClassPool(resultB.getFactory());
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clParentA);
                throw throwable;
            }
            this.unregisterClassPool(clParentA);
            this.assertNoClassPool(resultParentA);
            this.assertNoClassPool(resultB);
            try {
                clParentA = this.createClassPool(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                poolB = this.assertClassPool(resultB.getFactory());
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
            }
            finally {
                this.unregisterClassPool(clParentA);
            }
            this.assertNoClassPool(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassPool(poolB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassPool(resultB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentOtherDomain() throws Exception {
        ClassPool clParentA = null;
        Result resultParentA = new Result();
        String parentDomainName = "ParentDomain";
        try {
            clParentA = this.createChildDomainParentFirstClassPool(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
            this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
            this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
            ClassPool poolB = null;
            Result resultB = new Result();
            String childDomainName = "ChildDomain";
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                poolB = this.createChildDomainParentFirstClassPool(resultB, "b", "ChildDomain", "ParentDomain", builderB, JAR_B_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", poolB);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(poolB);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassPool(poolB);
            this.unregisterDomain("ChildDomain");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clParentA);
            this.unregisterDomain("ParentDomain");
            throw throwable;
        }
        this.unregisterClassPool(clParentA);
        this.unregisterDomain("ParentDomain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentOtherDomainLazy() throws Exception {
        ClassPool poolB = null;
        Result resultB = new Result();
        String parentDomainName = "ParentDomain";
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                poolB = this.createChildDomainParentFirstClassPool(resultB, "b", "ChildDomain", "ParentDomain", builderB, JAR_B_1);
                ClassPoolWithHierarchicalDomainTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassPool(resultB);
            ClassPool clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createChildDomainParentFirstClassPool(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                poolB = this.assertClassPool(resultB.getFactory());
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clParentA);
                this.unregisterDomain("ParentDomain");
                throw throwable;
            }
            this.unregisterClassPool(clParentA);
            this.unregisterDomain("ParentDomain");
            this.assertNoClassPool(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassPool(poolB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassPool(resultB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentRedeployOtherDomain() throws Exception {
        ClassPool poolB = null;
        Result resultB = new Result();
        String parentDomainName = "ParentDomain";
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                poolB = this.createChildDomainParentFirstClassPool(resultB, "b", "ChildDomain", "ParentDomain", builderB, JAR_B_1);
                ClassPoolWithHierarchicalDomainTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassPool(resultB);
            ClassPool clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createChildDomainParentFirstClassPool(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                poolB = this.assertClassPool(resultB.getFactory());
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clParentA);
                this.unregisterDomain("ParentDomain");
                throw throwable;
            }
            this.unregisterClassPool(clParentA);
            this.unregisterDomain("ParentDomain");
            this.assertNoClassPool(resultParentA);
            this.assertNoClassPool(resultB);
            try {
                clParentA = this.createChildDomainParentFirstClassPool(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                poolB = this.assertClassPool(resultB.getFactory());
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", poolB, clParentA);
            }
            finally {
                this.unregisterClassPool(clParentA);
                this.unregisterDomain("ParentDomain");
            }
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassPool(poolB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassPool(resultB);
    }
}

