/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import java.net.URL;
import junit.framework.Test;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.test.aop.classpool.jbosscl.support.NoMatchClassFilter;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassLoaderWithHierarchicalParentLoaderSanityTestCase
extends JBossClClassPoolTest {
    public ClassLoaderWithHierarchicalParentLoaderSanityTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassLoaderWithHierarchicalParentLoaderSanityTestCase.suite(ClassLoaderWithHierarchicalParentLoaderSanityTestCase.class);
    }

    public void testHierarchyBefore() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.BEFORE, true);
    }

    public void testHierarchyBeforeNotFound() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.BEFORE, false, false);
    }

    public void testHierarchyAfterNotReached() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.AFTER_BUT_JAVA_BEFORE, false);
    }

    public void testHierarchyAfterReached() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.AFTER_BUT_JAVA_BEFORE, null, true);
    }

    public void testHierarchyFiltered() throws Exception {
        NoMatchClassFilter filter = new NoMatchClassFilter("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, new ParentPolicy((ClassFilter)filter, ClassFilter.NOTHING), false);
        ClassLoaderWithHierarchicalParentLoaderSanityTestCase.assertTrue((String)"Should have been filtered", (boolean)filter.filtered);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, true, JAR_A_2, expectedParent);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean createParent, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, createParent, JAR_A_2, expectedParent);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, URL url, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, true, null, expectedParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean createParent, URL childURL, boolean expectedParent) throws Exception {
        String parentName = "parent";
        String childName = "child";
        ClassLoaderDomain parent = ClassLoaderWithHierarchicalParentLoaderSanityTestCase.getSystem().createAndRegisterDomain("parent", parentParentPolicy);
        ClassLoaderDomain child = ClassLoaderWithHierarchicalParentLoaderSanityTestCase.getSystem().createAndRegisterDomain("child", childParentPolicy, (Loader)parent);
        ClassLoader parentLoader = null;
        ClassLoader childLoader = null;
        try {
            if (createParent) {
                parentLoader = this.createChildDomainParentLastClassLoader("ParentLoader", "parent", true, JAR_A_1);
            }
            childLoader = this.createChildDomainParentLastClassLoader("ChildLoader", "child", "parent", true, childURL);
            this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", childLoader, expectedParent ? parentLoader : childLoader);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(parentLoader);
            this.unregisterClassLoader(childLoader);
            this.unregisterDomain(child);
            this.unregisterDomain(parent);
            throw throwable;
        }
        this.unregisterClassLoader(parentLoader);
        this.unregisterClassLoader(childLoader);
        this.unregisterDomain(child);
        this.unregisterDomain(parent);
    }
}

