/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import javassist.ClassPool;
import javassist.CtClass;
import junit.framework.Test;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.support.Result;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassPoolWithModuleDependencyTestCase
extends JBossClClassPoolTest {
    static final String STRING = String.class.getName();

    public ClassPoolWithModuleDependencyTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassPoolWithModuleDependencyTestCase.suite(ClassPoolWithModuleDependencyTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportNoVersionCheck() throws Exception {
        ClassPool clA = null;
        Result resultA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassPool(resultA, "A", builderA, JAR_A_1);
            CtClass aFromA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPool clB = null;
            Result resultB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createModule("ModuleB").createRequireModule("ModuleA");
                clB = this.createClassPool(resultB, "B", builderB, JAR_B_1);
                CtClass aFromA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA, clA);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)aFromA, (Object)aFromA1);
                this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB, clB);
                CtClass aFromB = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)aFromA, (Object)aFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clB);
                throw throwable;
            }
            this.unregisterClassPool(clB);
            CtClass aFromA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)aFromA, (Object)aFromA1);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertNoClassLoader(resultB);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clA);
            throw throwable;
        }
        this.unregisterClassPool(clA);
        this.assertNoClassLoader(resultA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheck() throws Exception {
        ClassPool clA = null;
        Result resultA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA", "1.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassPool(resultA, "A", builderA, JAR_A_1);
            CtClass classA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPool clB = null;
            Result resultB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA", new VersionRange((Object)"1.0.0", (Object)"2.0.0")).createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                clB = this.createClassPool(resultB, "B", builderB, JAR_B_1);
                CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classA, (Object)classA1);
                this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classA, (Object)classA1);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clB);
                throw throwable;
            }
            this.unregisterClassPool(clB);
            this.assertNoClassLoader(resultB);
            CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classA, (Object)classA1);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clA);
            throw throwable;
        }
        this.unregisterClassPool(clA);
        this.assertNoClassLoader(resultA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheckFailed() throws Exception {
        ClassPool clA = null;
        Result resultA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA", "3.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassPool(resultA, "A", builderA, JAR_A_1);
            CtClass classA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Result resultB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA", new VersionRange((Object)"1.0.0", (Object)"2.0.0")).createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                try {
                    this.createClassPool(resultB, "B", builderB, JAR_B_1);
                    ClassPoolWithModuleDependencyTestCase.fail((String)"Should not have been able to create loader");
                }
                catch (JBossClClassPoolTest.NoSuchClassLoaderException expected) {
                    // empty catch block
                }
                CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classA, (Object)classA1);
                this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertNoClassLoader(resultB);
            }
            finally {
                this.unregisterClassLoader("B");
            }
            this.assertNoClassLoader(resultB);
            CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classA, (Object)classA1);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clA);
            throw throwable;
        }
        this.unregisterClassPool(clA);
        this.assertNoClassLoader(resultA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralModulesWithSamePackages() throws Exception {
        ClassPool clAModuleX = null;
        ClassPool clAModuleA = null;
        ClassPool clAModuleY = null;
        Result rAX = new Result();
        Result rAA = new Result();
        Result rAY = new Result();
        try {
            BundleInfoBuilder builderAX = BundleInfoBuilder.getBuilder().createModule("ModuleX").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleX = this.createClassPool(rAX, "X", builderAX, JAR_A_1);
            BundleInfoBuilder builderAA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA = this.createClassPool(rAA, "A", builderAA, JAR_A_1);
            BundleInfoBuilder builderAY = BundleInfoBuilder.getBuilder().createModule("ModuleY").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleY = this.createClassPool(rAY, "Y", builderAY, JAR_A_1);
            CtClass classAX = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleX);
            CtClass classAA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA);
            CtClass classAY = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleY);
            this.assertCannotLoadCtClass(clAModuleX, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleY, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPool clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                clB = this.createClassPool(rB, "B", builderB, JAR_B_1);
                CtClass classAX1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleX);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAX, (Object)classAX1);
                CtClass classAA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAA, (Object)classAA1);
                CtClass classAY1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleY);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAY, (Object)classAY1);
                this.assertCannotLoadCtClass(clAModuleX, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadCtClass(clAModuleA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadCtClass(clAModuleY, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB, clB);
                CtClass aFromB = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clAModuleA);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)aFromB, (Object)classAA);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clB);
                throw throwable;
            }
            this.unregisterClassPool(clB);
            this.assertNoClassLoader(rB);
            CtClass classAX1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleX);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAX, (Object)classAX1);
            CtClass classAA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAA, (Object)classAA1);
            CtClass classAY1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleY);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAY, (Object)classAY1);
            this.assertCannotLoadCtClass(clAModuleX, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleY, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clAModuleY);
            this.unregisterClassPool(clAModuleA);
            this.unregisterClassPool(clAModuleX);
            throw throwable;
        }
        this.unregisterClassPool(clAModuleY);
        this.unregisterClassPool(clAModuleA);
        this.unregisterClassPool(clAModuleX);
        this.assertNoClassLoader(rAY);
        this.assertNoClassLoader(rAA);
        this.assertNoClassLoader(rAX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralModulesWithSameNamesDifferentVersions() throws Exception {
        ClassPool clAModuleA1 = null;
        ClassPool clAModuleA2 = null;
        ClassPool clAModuleA3 = null;
        Result rA1 = new Result();
        Result rA2 = new Result();
        Result rA3 = new Result();
        try {
            BundleInfoBuilder builderA1 = BundleInfoBuilder.getBuilder().createModule("ModuleA", "1.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA1 = this.createClassPool(rA1, "X", builderA1, JAR_A_1);
            BundleInfoBuilder builderA2 = BundleInfoBuilder.getBuilder().createModule("ModuleA", "2.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA2 = this.createClassPool(rA2, "A", builderA2, JAR_A_1);
            BundleInfoBuilder builderA3 = BundleInfoBuilder.getBuilder().createModule("ModuleA", "3.0.0").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clAModuleA3 = this.createClassPool(rA3, "Y", builderA3, JAR_A_1);
            CtClass classAX = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA1);
            CtClass classAA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA2);
            CtClass classAY = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA3);
            this.assertCannotLoadCtClass(clAModuleA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPool clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequireModule("ModuleA", new VersionRange((Object)"2.0.0", true, (Object)"3.0.0", false)).createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b");
                clB = this.createClassPool(rB, "B", builderB, JAR_B_1);
                CtClass classAX1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA1);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAX, (Object)classAX1);
                CtClass classAA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA2);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAA, (Object)classAA1);
                CtClass classAY1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA3);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAY, (Object)classAY1);
                this.assertCannotLoadCtClass(clAModuleA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadCtClass(clAModuleA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadCtClass(clAModuleA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB, clB);
                CtClass aFromB = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clAModuleA2);
                ClassPoolWithModuleDependencyTestCase.assertSame((Object)aFromB, (Object)classAA);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clB);
                throw throwable;
            }
            this.unregisterClassPool(clB);
            this.assertNoClassLoader(rB);
            CtClass classAX1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA1);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAX, (Object)classAX1);
            CtClass classAA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA2);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAA, (Object)classAA1);
            CtClass classAY1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clAModuleA3);
            ClassPoolWithModuleDependencyTestCase.assertSame((Object)classAY, (Object)classAY1);
            this.assertCannotLoadCtClass(clAModuleA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clAModuleA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clAModuleA3);
            this.unregisterClassPool(clAModuleA2);
            this.unregisterClassPool(clAModuleA1);
            throw throwable;
        }
        this.unregisterClassPool(clAModuleA3);
        this.unregisterClassPool(clAModuleA2);
        this.unregisterClassPool(clAModuleA1);
        this.assertNoClassLoader(rA1);
        this.assertNoClassLoader(rA2);
        this.assertNoClassLoader(rA3);
    }
}

