/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import java.io.Serializable;
import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import junit.framework.Test;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.aop.proxy.container.ProxyTemplate;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolWithRepositoryTestCase
extends JBossClClassPoolTest {
    static final String STRING = String.class.getName();

    public ClassPoolWithRepositoryTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassPoolWithRepositoryTestCase.suite(ClassPoolWithRepositoryTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGlobalScope() throws Exception {
        ClassPool poolA = null;
        ClassPool poolB = null;
        try {
            CtClass aFromA;
            poolA = this.createClassPool("A", true, JAR_A_1);
            poolB = this.createClassPool("B", true, JAR_B_1);
            try {
                aFromA = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
                ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromA);
                CtClass bFromA = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassPoolWithRepositoryTestCase.assertNotNull((Object)bFromA);
                CtClass aFromB = poolB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
                CtClass bFromB = poolB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassPoolWithRepositoryTestCase.assertSame((Object)aFromA, (Object)aFromB);
                ClassPoolWithRepositoryTestCase.assertSame((Object)poolA, (Object)aFromA.getClassPool());
                ClassPoolWithRepositoryTestCase.assertSame((Object)poolB, (Object)bFromB.getClassPool());
                this.checkCanLoadString(poolA, poolB);
            }
            finally {
                this.unregisterClassPool(poolB);
            }
            aFromA = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromA);
            this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolA);
            throw throwable;
        }
        this.unregisterClassPool(poolA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildDomain() throws Exception {
        ClassPool poolA = null;
        ClassPool poolB = null;
        ClassLoaderDomain childDomain = null;
        ClassPool poolC = null;
        try {
            poolA = this.createClassPool("A", true, JAR_A_1);
            poolB = this.createClassPool("B", true, JAR_B_1);
            poolC = this.createChildDomainParentFirstClassPool("C", "CHILD", true, JAR_C_1);
            childDomain = this.getChildDomainForPool(poolC);
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)childDomain);
            ClassPoolWithRepositoryTestCase.assertSame((Object)ClassPoolWithRepositoryTestCase.getSystem().getDefaultDomain(), (Object)childDomain.getParent());
            CtClass aFromA = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromA);
            CtClass bFromB = poolB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)bFromB);
            CtClass cFromC = poolC.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)cFromC);
            CtClass aFromC = poolC.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromC);
            CtClass bFromC = poolC.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)bFromC);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromA, (Object)aFromC);
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFromB, (Object)bFromC);
            ClassPoolWithRepositoryTestCase.assertSame((Object)poolA, (Object)aFromA.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)poolB, (Object)bFromB.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)poolC, (Object)cFromC.getClassPool());
            this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            this.assertCannotLoadCtClass(poolB, "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            this.checkCanLoadString(poolA, poolB);
            this.checkCanLoadString(poolB, poolC);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolA);
            this.unregisterClassPool(poolB);
            this.unregisterClassPool(poolC);
            this.unregisterDomain(childDomain.getName());
            throw throwable;
        }
        this.unregisterClassPool(poolA);
        this.unregisterClassPool(poolB);
        this.unregisterClassPool(poolC);
        this.unregisterDomain(childDomain.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSiblingDomains() throws Exception {
        ClassPool poolA = null;
        ClassPool poolB = null;
        ClassLoaderDomain domainA = null;
        ClassLoaderDomain domainB = null;
        try {
            poolA = this.createChildDomainParentFirstClassPool("A", "ChildA", true, JAR_A_1);
            poolB = this.createChildDomainParentLastClassPool("B", "ChildB", true, JAR_B_1);
            domainA = this.getChildDomainForPool(poolA);
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)domainA);
            ClassPoolWithRepositoryTestCase.assertSame((Object)ClassPoolWithRepositoryTestCase.getSystem().getDefaultDomain(), (Object)domainA.getParent());
            domainB = this.getChildDomainForPool(poolB);
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)domainB);
            ClassPoolWithRepositoryTestCase.assertSame((Object)ClassPoolWithRepositoryTestCase.getSystem().getDefaultDomain(), (Object)domainB.getParent());
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)domainA, (Object)domainB);
            CtClass clazzA = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)poolA, (Object)clazzA.getClassPool());
            CtClass clazzB = poolB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertSame((Object)poolB, (Object)clazzB.getClassPool());
            this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(poolB, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            this.checkCanLoadString(poolA, poolB);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolA);
            this.unregisterClassPool(poolB);
            this.unregisterDomain(poolA);
            this.unregisterDomain(poolB);
            throw throwable;
        }
        this.unregisterClassPool(poolA);
        this.unregisterClassPool(poolB);
        this.unregisterDomain(poolA);
        this.unregisterDomain(poolB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildWithNewClassesInParent() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            scopedPool = this.createChildDomainParentFirstClassPool("SCOPED", "SCOPED", true, JAR_B_1);
            this.assertCannotLoadCtClass(scopedPool, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            globalPool = this.createClassPool("GLOBAL", true, JAR_A_1);
            CtClass aFromChild = scopedPool.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromChild);
            CtClass aFromParent = globalPool.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromParent);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromChild, (Object)aFromParent);
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalPool, (Object)aFromParent.getClassPool());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPool);
            this.unregisterClassPool(scopedPool);
            this.unregisterDomain(scopedPool);
            throw throwable;
        }
        this.unregisterClassPool(globalPool);
        this.unregisterClassPool(scopedPool);
        this.unregisterDomain(scopedPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            globalPool = this.createClassPool("GLOBAL", true, JAR_A_1);
            scopedPool = this.createChildDomainParentFirstClassPool("SCOPED", "SCOPED", true, JAR_B_1);
            CtClass aFromParent = globalPool.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromParent);
            CtClass aFromChild = scopedPool.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromChild);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFromChild);
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalPool, (Object)aFromParent.getClassPool());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPool);
            this.unregisterClassPool(scopedPool);
            this.unregisterDomain(scopedPool);
            throw throwable;
        }
        this.unregisterClassPool(globalPool);
        this.unregisterClassPool(scopedPool);
        this.unregisterDomain(scopedPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURLChildOfGlobalUcl() throws Exception {
        ClassPool global = null;
        ClassPool childA = null;
        ClassPool childB = null;
        try {
            global = this.createClassPool("GLOBAL", true, JAR_A_1);
            childA = this.createChildURLClassPool(global, JAR_B_1);
            CtClass aFromA = childA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)global, (Object)aFromA.getClassPool());
            CtClass bFromA = childA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertSame((Object)childA, (Object)bFromA.getClassPool());
            childB = this.createChildURLClassPool(global, JAR_A_2);
            CtClass aFromB = childB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)global, (Object)aFromB.getClassPool());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(global);
            this.unregisterClassPool(childA);
            this.unregisterClassPool(childB);
            throw throwable;
        }
        this.unregisterClassPool(global);
        this.unregisterClassPool(childA);
        this.unregisterClassPool(childB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildOverrideWithNoParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            globalPool = this.createClassPool("GLOBAL", true, JAR_A_1);
            scopedPool = this.createChildDomainParentLastClassPool("CHILD", "CHILD", true, JAR_A_1);
            CtClass aFromParent = globalPool.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromParent);
            CtClass aFromChild = scopedPool.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotNull((Object)aFromChild);
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)aFromParent, (Object)aFromChild);
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalPool, (Object)aFromParent.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)scopedPool, (Object)aFromChild.getClassPool());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPool);
            this.unregisterClassPool(scopedPool);
            this.unregisterDomain(scopedPool);
            throw throwable;
        }
        this.unregisterClassPool(globalPool);
        this.unregisterClassPool(scopedPool);
        this.unregisterDomain(scopedPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUndeploySibling() throws Exception {
        ClassPool poolA = null;
        ClassPool poolB = null;
        try {
            try {
                poolA = this.createClassPool("A", true, JAR_A_1);
                this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                poolB = this.createClassPool("B", true, JAR_B_1);
                CtClass bFromA = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassPoolWithRepositoryTestCase.assertSame((Object)poolB, (Object)bFromA.getClassPool());
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(poolB);
                throw throwable;
            }
            this.unregisterClassPool(poolB);
            this.assertCannotLoadCtClass(poolA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolA);
            throw throwable;
        }
        this.unregisterClassPool(poolA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUndeployParentDomainClassLoader() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        ClassPool child = null;
        try {
            try {
                globalA = this.createClassPool("A", true, JAR_A_1);
                this.assertCannotLoadCtClass(globalA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                child = this.createChildDomainParentLastClassPool("C", "C", true, JAR_C_1);
                this.assertCannotLoadCtClass(child, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                globalB = this.createClassPool("B", true, JAR_B_1);
                CtClass bFromChild = child.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                CtClass bFromA = globalA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                ClassPoolWithRepositoryTestCase.assertSame((Object)globalB, (Object)bFromA.getClassPool());
                ClassPoolWithRepositoryTestCase.assertSame((Object)bFromA, (Object)bFromChild);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(globalB);
                throw throwable;
            }
            this.unregisterClassPool(globalB);
            this.assertCannotLoadCtClass(child, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalA);
            this.unregisterClassPool(child);
            this.unregisterDomain(child);
            throw throwable;
        }
        this.unregisterClassPool(globalA);
        this.unregisterClassPool(child);
        this.unregisterDomain(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralLevelsOfDomain() throws Exception {
        ClassPool parent = null;
        ClassPool cl1B = null;
        ClassPool cl1C = null;
        ClassPool cl2B = null;
        ClassPool cl2C = null;
        ClassPool cl11A = null;
        ClassPool cl11B = null;
        ClassPool cl11C = null;
        ClassPool cl12A = null;
        ClassPool cl12B = null;
        ClassPool cl12C = null;
        try {
            parent = this.createClassPool("A", true, JAR_A_1);
            CtClass aFromParent = parent.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)parent, (Object)aFromParent.getClassPool());
            String domain1 = "1";
            cl1B = this.createChildDomainParentFirstClassPool("1B", "1", true, JAR_B_1);
            cl1C = this.createChildDomainParentFirstClassPool("1C", "1", true, JAR_C_1);
            CtClass aFrom1B = cl1B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass bFrom1B = cl1B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass cFrom1B = cl1B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            CtClass aFrom1C = cl1C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass bFrom1C = cl1C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass cFrom1C = cl1C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFrom1B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFrom1C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFrom1B, (Object)bFrom1C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cFrom1B, (Object)cFrom1C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl1B, (Object)bFrom1B.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl1C, (Object)cFrom1B.getClassPool());
            String domain2 = "2";
            cl2B = this.createChildDomainParentFirstClassPool("2B", "2", true, JAR_B_1);
            cl2C = this.createChildDomainParentFirstClassPool("2C", "2", true, JAR_C_1);
            CtClass aFrom2B = cl2B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass bFrom2B = cl2B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass cFrom2B = cl2B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            CtClass aFrom2C = cl2C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass bFrom2C = cl2C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass cFrom2C = cl2C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFrom2B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFrom2C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFrom2B, (Object)bFrom2C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cFrom2B, (Object)cFrom2C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl2B, (Object)bFrom2B.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl2C, (Object)cFrom2B.getClassPool());
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)bFrom1B, (Object)bFrom2B);
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)bFrom2C, (Object)bFrom1C);
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)cFrom2C, (Object)cFrom1C);
            String domain11 = "11";
            cl11A = this.createChildDomainParentFirstClassPool("11A", "11", "1", true, JAR_A_2);
            cl11B = this.createChildDomainParentFirstClassPool("11B", "11", "1", true, JAR_B_2);
            cl11C = this.createChildDomainParentFirstClassPool("11C", "11", "1", true, JAR_C_2);
            String domain12 = "12";
            cl12A = this.createChildDomainParentLastClassPool("12A", "12", "1", true, JAR_A_2);
            cl12B = this.createChildDomainParentLastClassPool("12B", "12", "1", true, JAR_B_2);
            cl12C = this.createChildDomainParentLastClassPool("12C", "12", "1", true, JAR_C_2);
            CtClass aFrom11A = cl11A.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass aFrom11B = cl11B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass aFrom11C = cl11C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFrom11A);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFrom11B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromParent, (Object)aFrom11C);
            CtClass aFrom12A = cl12A.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass aFrom12B = cl12B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass aFrom12C = cl12C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)aFromParent, (Object)aFrom12A);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFrom12A, (Object)aFrom12B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFrom12A, (Object)aFrom12C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl12A, (Object)aFrom12A.getClassPool());
            CtClass bFrom11A = cl11A.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass bFrom11B = cl11B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass bFrom11C = cl11C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass cFrom11A = cl11A.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            CtClass cFrom11B = cl11B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            CtClass cFrom11C = cl11C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFrom11A, (Object)bFrom11B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFrom11A, (Object)bFrom11C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl1B, (Object)bFrom11B.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)cFrom11A, (Object)cFrom11B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cFrom11A, (Object)cFrom11C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl1C, (Object)cFrom11C.getClassPool());
            CtClass bFrom12A = cl12A.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass bFrom12B = cl12B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass bFrom12C = cl12C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            CtClass cFrom12A = cl12A.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            CtClass cFrom12B = cl12B.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            CtClass cFrom12C = cl12C.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C");
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFrom12A, (Object)bFrom12B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFrom12A, (Object)bFrom12C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl12B, (Object)bFrom12B.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)cFrom12A, (Object)cFrom12B);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cFrom12A, (Object)cFrom12C);
            ClassPoolWithRepositoryTestCase.assertSame((Object)cl12C, (Object)cFrom12C.getClassPool());
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)bFrom11B, (Object)bFrom12B);
            ClassPoolWithRepositoryTestCase.assertNotSame((Object)cFrom11C, (Object)cFrom12C);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(parent);
            this.unregisterClassPool(cl1B);
            this.unregisterClassPool(cl1C);
            this.unregisterClassPool(cl2B);
            this.unregisterClassPool(cl2C);
            this.unregisterClassPool(cl11A);
            this.unregisterClassPool(cl11B);
            this.unregisterClassPool(cl11C);
            this.unregisterClassPool(cl12A);
            this.unregisterClassPool(cl12B);
            this.unregisterClassPool(cl12C);
            this.unregisterDomain(cl12A);
            this.unregisterDomain(cl11A);
            this.unregisterDomain(cl2B);
            this.unregisterDomain(cl1B);
            throw throwable;
        }
        this.unregisterClassPool(parent);
        this.unregisterClassPool(cl1B);
        this.unregisterClassPool(cl1C);
        this.unregisterClassPool(cl2B);
        this.unregisterClassPool(cl2C);
        this.unregisterClassPool(cl11A);
        this.unregisterClassPool(cl11B);
        this.unregisterClassPool(cl11C);
        this.unregisterClassPool(cl12A);
        this.unregisterClassPool(cl12B);
        this.unregisterClassPool(cl12C);
        this.unregisterDomain(cl12A);
        this.unregisterDomain(cl11A);
        this.unregisterDomain(cl2B);
        this.unregisterDomain(cl1B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUclLoaderOrdering() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        ClassPool globalC = null;
        try {
            globalA = this.createClassPool("A", true, JAR_A_1);
            globalB = this.createClassPool("B", true, JAR_A_1);
            globalC = this.createClassPool("C", true, JAR_A_1);
            CtClass aFromA = globalA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass aFromB = globalB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            CtClass aFromC = globalC.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromA, (Object)aFromB);
            ClassPoolWithRepositoryTestCase.assertSame((Object)aFromA, (Object)aFromC);
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalA, (Object)aFromA.getClassPool());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalA);
            this.unregisterClassPool(globalB);
            this.unregisterClassPool(globalC);
            throw throwable;
        }
        this.unregisterClassPool(globalA);
        this.unregisterClassPool(globalB);
        this.unregisterClassPool(globalC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleGeneratingClass() throws Exception {
        ClassPool global = null;
        try {
            String classname = "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.AXYZ";
            global = this.createClassPool("A", true, JAR_A_1);
            CtClass newCtClass = global.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.AXYZ");
            Class newClass = newCtClass.toClass();
            Class<?> foundClass = global.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.AXYZ");
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClass, foundClass);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(global);
            throw throwable;
        }
        this.unregisterClassPool(global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGeneratingClassAndFindInSameDomain() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        try {
            String classnameA = "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA";
            String classnameB = "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB";
            globalA = this.createClassPool("A", true, JAR_A_1);
            globalB = this.createClassPool("B", true, JAR_B_1);
            CtClass newCtClassA = globalA.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA");
            Class newClassA = newCtClassA.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalA.getClassLoader(), (Object)newClassA.getClassLoader());
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassA, globalA.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA"));
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassA, globalB.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA"));
            CtClass newCtClassB = globalB.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB");
            Class newClassB = newCtClassB.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalB.getClassLoader(), (Object)newClassB.getClassLoader());
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassB, globalA.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB"));
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassB, globalB.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB"));
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalA);
            this.unregisterClassPool(globalB);
            throw throwable;
        }
        this.unregisterClassPool(globalA);
        this.unregisterClassPool(globalB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGeneratingClassAndFindPreviouslyBlacklistedInSameDomain() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        try {
            String classnameA = "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA";
            String classnameB = "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB";
            globalA = this.createClassPool("A", true, JAR_A_1);
            globalB = this.createClassPool("B", true, JAR_B_1);
            this.assertCannotLoadClass(globalA.getClassLoader(), "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA");
            this.assertCannotLoadClass(globalA.getClassLoader(), "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB");
            this.assertCannotLoadClass(globalB.getClassLoader(), "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA");
            this.assertCannotLoadClass(globalB.getClassLoader(), "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB");
            CtClass newCtClassA = globalA.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA");
            Class newClassA = newCtClassA.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalA.getClassLoader(), (Object)newClassA.getClassLoader());
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassA, globalA.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA"));
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassA, globalB.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.NewClassA"));
            CtClass newCtClassB = globalB.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB");
            Class newClassB = newCtClassB.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalB.getClassLoader(), (Object)newClassB.getClassLoader());
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassB, globalA.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB"));
            ClassPoolWithRepositoryTestCase.assertSame((Object)newClassB, globalB.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.NewClassB"));
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalA);
            this.unregisterClassPool(globalB);
            throw throwable;
        }
        this.unregisterClassPool(globalA);
        this.unregisterClassPool(globalB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGeneratingCrossDomainClassHierarchy() throws Exception {
        ClassPool global = null;
        ClassPool child1 = null;
        ClassPool child2 = null;
        try {
            String parentName = "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent";
            String childName = "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.Child";
            global = this.createClassPool("A", true, JAR_A_1);
            child1 = this.createChildDomainParentLastClassPool("C1", "C1", true, JAR_B_1);
            child2 = this.createChildDomainParentLastClassPool("C2", "C2", "C1", true, JAR_C_1);
            this.assertCannotLoadCtClass(global, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            this.assertCannotLoadCtClass(child1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            this.assertCannotLoadCtClass(child2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            this.assertCannotLoadCtClass(child2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.Child");
            CtClass parentClass = global.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            CtClass childClass = child2.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.Child");
            childClass.setSuperclass(parentClass);
            CtClass parentFromGlobal = global.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)global, (Object)parentFromGlobal.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)parentClass, (Object)parentFromGlobal);
            CtClass childFromChild2 = child2.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.Child");
            ClassPoolWithRepositoryTestCase.assertSame((Object)child2, (Object)childFromChild2.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)childClass, (Object)childFromChild2);
            this.assertCannotLoadCtClass(global, "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.Child");
            this.assertCannotLoadCtClass(child1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.Child");
            CtClass parentFromChildA = childClass.getSuperclass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)parentClass, (Object)parentFromChildA);
            CtClass parentFromChildB = child2.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)parentClass, (Object)parentFromChildB);
            Class parentClazz = parentClass.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)global.getClassLoader(), (Object)parentClazz.getClassLoader());
            Class childClazz = childClass.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)child2.getClassLoader(), (Object)childClazz.getClassLoader());
            Class<?> parentClazzFromParent = global.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)parentClazz, parentClazzFromParent);
            Class<?> parentClazzFromChild = child2.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)parentClazz, parentClazzFromChild);
            Class<?> childClazzFromChild = child2.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.c.Child");
            ClassPoolWithRepositoryTestCase.assertSame((Object)childClazz, childClazzFromChild);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(global);
            this.unregisterClassPool(child1);
            this.unregisterClassPool(child2);
            this.unregisterDomain(child1);
            this.unregisterDomain(child2);
            throw throwable;
        }
        this.unregisterClassPool(global);
        this.unregisterClassPool(child1);
        this.unregisterClassPool(child2);
        this.unregisterDomain(child1);
        this.unregisterDomain(child2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGeneratingClassInMyPackagesInDelegatingPool() throws Exception {
        ClassPool globalA = null;
        ClassPool globalB = null;
        ClassPool child = null;
        try {
            String aClassName = "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent";
            String bClassName = "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz";
            globalA = this.createClassPool("A", true, JAR_A_1);
            globalB = this.createClassPool("B", true, JAR_B_1);
            child = this.createChildURLClassPool(globalA, JAR_C_1);
            this.assertCannotLoadCtClass(globalA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            this.assertCannotLoadCtClass(globalB, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            this.assertCannotLoadCtClass(child, "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            this.assertCannotLoadCtClass(globalA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            this.assertCannotLoadCtClass(globalB, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            this.assertCannotLoadCtClass(child, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            CtClass a = globalA.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            CtClass b = globalB.makeClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            CtClass aFromA = globalA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)a, (Object)aFromA);
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalA, (Object)aFromA.getClassPool());
            CtClass aFromB = globalB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)a, (Object)aFromB);
            CtClass bFromA = globalA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            ClassPoolWithRepositoryTestCase.assertSame((Object)b, (Object)bFromA);
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalB, (Object)bFromA.getClassPool());
            CtClass bFromB = globalB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            ClassPoolWithRepositoryTestCase.assertSame((Object)b, (Object)bFromB);
            CtClass aFromChild = child.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)a, (Object)aFromChild);
            CtClass bFromChild = child.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            ClassPoolWithRepositoryTestCase.assertSame((Object)b, (Object)bFromChild);
            Class clazzA = a.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalA.getClassLoader(), (Object)clazzA.getClassLoader());
            Class clazzB = b.toClass();
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalB.getClassLoader(), (Object)clazzB.getClassLoader());
            Class<?> clazzAFromA = globalA.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)clazzA, clazzAFromA);
            Class<?> clazzAFromB = globalB.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)clazzA, clazzAFromB);
            Class<?> clazzAFromChild = child.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.Parent");
            ClassPoolWithRepositoryTestCase.assertSame((Object)clazzA, clazzAFromChild);
            Class<?> clazzBFromA = globalA.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            ClassPoolWithRepositoryTestCase.assertSame((Object)clazzB, clazzBFromA);
            Class<?> clazzBFromB = globalB.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            ClassPoolWithRepositoryTestCase.assertSame((Object)clazzB, clazzBFromB);
            Class<?> clazzBFromChild = child.getClassLoader().loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.BClazz");
            ClassPoolWithRepositoryTestCase.assertSame((Object)clazzB, clazzBFromChild);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalA);
            this.unregisterClassPool(globalB);
            this.unregisterClassPool(child);
            throw throwable;
        }
        this.unregisterClassPool(globalA);
        this.unregisterClassPool(globalB);
        this.unregisterClassPool(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanLoadArrrayCtClass() throws Exception {
        ClassPool poolA = null;
        ClassPool poolB = null;
        try {
            poolA = this.createClassPool("A", true, JAR_A_1);
            poolB = this.createClassPool("B", true, JAR_B_1);
            this.accessCanLoadCtArray(poolA, poolB);
            this.accessCanLoadCtArray(poolA, poolB);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(poolA);
            this.unregisterClassPool(poolB);
            throw throwable;
        }
        this.unregisterClassPool(poolA);
        this.unregisterClassPool(poolB);
    }

    private void accessCanLoadCtArray(ClassPool poolA, ClassPool poolB) throws Exception {
        poolA.get(String.class.getName() + "[][]");
        CtClass a = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
        CtClass aArray = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A[]");
        CtClass bArray = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B[][]");
        CtClass b = poolA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        CtClass byteClassA = poolA.get("byte");
        CtClass byteClassB = poolB.get("byte");
        ClassPoolWithRepositoryTestCase.assertSame((Object)byteClassA, (Object)byteClassB);
        ClassPoolWithRepositoryTestCase.assertNotSame((Object)poolA, (Object)byteClassA.getClassPool());
        ClassPoolWithRepositoryTestCase.assertNotSame((Object)poolB, (Object)byteClassA.getClassPool());
        CtClass intArrayClass = poolA.get("int[]");
        CtClass intClass = poolB.get("int");
        ClassPoolWithRepositoryTestCase.assertSame((Object)intClass, (Object)intArrayClass.getComponentType());
        ClassPoolWithRepositoryTestCase.assertSame((Object)byteClassA.getClassPool(), (Object)intClass.getClassPool());
        ClassPoolWithRepositoryTestCase.assertTrue((boolean)aArray.isArray());
        ClassPoolWithRepositoryTestCase.assertSame((Object)a, (Object)aArray.getComponentType());
        ClassPoolWithRepositoryTestCase.assertTrue((boolean)bArray.isArray());
        ClassPoolWithRepositoryTestCase.assertTrue((boolean)bArray.getComponentType().isArray());
        ClassPoolWithRepositoryTestCase.assertSame((Object)b, (Object)bArray.getComponentType().getComponentType());
        ClassPoolWithRepositoryTestCase.assertNotSame((Object)aArray.getClassPool(), (Object)bArray.getClassPool());
        ClassPoolWithRepositoryTestCase.assertSame((Object)poolA, (Object)aArray.getClassPool());
        ClassPoolWithRepositoryTestCase.assertSame((Object)poolB, (Object)bArray.getClassPool());
        ClassPoolWithRepositoryTestCase.assertSame((Object)a.getClassPool(), (Object)aArray.getClassPool());
        ClassPoolWithRepositoryTestCase.assertSame((Object)b.getClassPool(), (Object)bArray.getClassPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassLoaderWithParentClassLoader() throws Exception {
        ClassPool parent = this.createChildURLClassPool(null, JAR_B_1);
        ClassPool global = null;
        try {
            global = this.createChildDomainParentFirstClassPool("A", "A", true, parent, JAR_A_1);
            CtClass aFromGlobal = global.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)global, (Object)aFromGlobal.getClassPool());
            CtClass bFromGlobal = global.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertSame((Object)parent, (Object)bFromGlobal.getClassPool());
            CtClass bFromParent = parent.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFromGlobal, (Object)bFromParent);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(global);
            this.unregisterClassPool(parent);
            this.unregisterDomain(global);
            throw throwable;
        }
        this.unregisterClassPool(global);
        this.unregisterClassPool(parent);
        this.unregisterDomain(global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassLoaderWithParentClassLoaderAndSameClassInDomain() throws Exception {
        ClassPool parent = this.createChildURLClassPool(null, JAR_B_1);
        ClassPool globalA = null;
        ClassPool globalB = null;
        ClassPool globalC = null;
        try {
            String domain = "CHILD";
            globalA = this.createChildDomainParentFirstClassPool("A", "CHILD", true, parent, JAR_A_1);
            CtClass aFromGlobal = globalA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
            ClassPoolWithRepositoryTestCase.assertSame((Object)globalA, (Object)aFromGlobal.getClassPool());
            CtClass bFromGlobalA = globalA.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertSame((Object)parent, (Object)bFromGlobalA.getClassPool());
            globalB = this.createChildDomainParentFirstClassPool("B", "CHILD", true, parent, JAR_B_2);
            CtClass bFromParent = parent.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertSame((Object)parent, (Object)bFromParent.getClassPool());
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFromGlobalA, (Object)bFromParent);
            CtClass bFromGlobalB = globalB.get("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPoolWithRepositoryTestCase.assertSame((Object)bFromGlobalB, (Object)bFromParent);
            globalC = this.createChildDomainParentLastClassPool("C", "CHILD2", true, parent, JAR_B_2);
            this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", globalC);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalA);
            this.unregisterClassPool(globalB);
            this.unregisterClassPool(globalC);
            this.unregisterClassPool(parent);
            this.unregisterDomain(globalA);
            this.unregisterDomain(globalC);
            throw throwable;
        }
        this.unregisterClassPool(globalA);
        this.unregisterClassPool(globalB);
        this.unregisterClassPool(globalC);
        this.unregisterClassPool(parent);
        this.unregisterDomain(globalA);
        this.unregisterDomain(globalC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMakeContainerProxyInSamePackage() throws Exception {
        ClassPool globalPoolA = null;
        ClassPool globalPoolB = null;
        try {
            globalPoolA = this.createClassPool("A", true, JAR_A_1);
            globalPoolB = this.createClassPool("B", true, JAR_B_1);
            ClassLoader loaderA = globalPoolA.getClassLoader();
            ClassLoader loaderB = globalPoolB.getClassLoader();
            loaderA.loadClass(ProxyTemplate.class.getName());
            Object proxyA = this.assertMakeContainerProxy(loaderA.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A"), loaderA);
            Object proxyB = this.assertMakeContainerProxy(loaderB.loadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B"), loaderB);
            Class<?> clazzA = proxyA.getClass();
            Class<?> clazzB = proxyB.getClass();
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzA));
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzB));
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)clazzA.getName().startsWith("org.jboss.test.aop.classpool.jbosscl.support.excluded.a"));
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)clazzB.getName().startsWith("org.jboss.test.aop.classpool.jbosscl.support.excluded.b"));
            ClassPoolWithRepositoryTestCase.assertSame(clazzA, loaderA.loadClass(clazzA.getName()));
            ClassPoolWithRepositoryTestCase.assertSame(clazzB, loaderA.loadClass(clazzB.getName()));
            ClassPoolWithRepositoryTestCase.assertSame(clazzA, loaderB.loadClass(clazzA.getName()));
            ClassPoolWithRepositoryTestCase.assertSame(clazzB, loaderB.loadClass(clazzB.getName()));
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPoolA);
            this.unregisterClassPool(globalPoolB);
            throw throwable;
        }
        this.unregisterClassPool(globalPoolA);
        this.unregisterClassPool(globalPoolB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMakeContainerProxyForSystemClass() throws Exception {
        ClassPool globalPoolA = null;
        ClassPool globalPoolB = null;
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a").createPackage("org.jboss.aop.generatedproxies");
            globalPoolA = this.createClassPool("A", true, builderA, JAR_A_1);
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createModule("ModuleB").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createPackage("org.jboss.aop.generatedproxies");
            globalPoolB = this.createClassPool("B", true, builderB, JAR_B_1);
            ClassLoader loaderA = globalPoolA.getClassLoader();
            ClassLoader loaderB = globalPoolB.getClassLoader();
            loaderA.loadClass(ProxyTemplate.class.getName());
            Object proxyA = this.assertMakeContainerProxy(ArrayList.class, loaderA);
            Object proxyB = this.assertMakeContainerProxy(ArrayList.class, loaderB);
            Class<?> clazzA = proxyA.getClass();
            Class<?> clazzB = proxyB.getClass();
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzA));
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)AspectManaged.class.isAssignableFrom(clazzB));
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)clazzA.getName().startsWith("org.jboss.aop.generatedproxies"));
            ClassPoolWithRepositoryTestCase.assertTrue((boolean)clazzB.getName().startsWith("org.jboss.aop.generatedproxies"));
            ClassPoolWithRepositoryTestCase.assertSame(clazzA, loaderA.loadClass(clazzA.getName()));
            ClassPoolWithRepositoryTestCase.assertSame(clazzB, loaderA.loadClass(clazzB.getName()));
            ClassPoolWithRepositoryTestCase.assertSame(clazzA, loaderB.loadClass(clazzA.getName()));
            ClassPoolWithRepositoryTestCase.assertSame(clazzB, loaderB.loadClass(clazzB.getName()));
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPoolA);
            this.unregisterClassPool(globalPoolB);
            throw throwable;
        }
        this.unregisterClassPool(globalPoolA);
        this.unregisterClassPool(globalPoolB);
    }

    private Object assertMakeContainerProxy(Class<?> parent, ClassLoader loader) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(parent);
        params.setTarget(parent.newInstance());
        params.setClassLoader(loader);
        params.setInterfaces(new Class[]{Serializable.class});
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        Object proxy = factory.createAdvisedProxy(params);
        ClassPoolWithRepositoryTestCase.assertFalse((parent.getName() == proxy.getClass().getName() ? 1 : 0) != 0);
        ClassPoolWithRepositoryTestCase.assertSame((Object)loader, (Object)proxy.getClass().getClassLoader());
        return proxy;
    }

    private void checkCanLoadString(ClassPool poolA, ClassPool poolB) throws NotFoundException {
        CtClass strA = poolA.getCtClass(STRING);
        CtClass strB = poolB.getCtClass(STRING);
        ClassPoolWithRepositoryTestCase.assertSame((Object)strA, (Object)strB);
        ClassPoolWithRepositoryTestCase.assertSame((Object)strB.getClassPool(), (Object)strA.getClassPool());
        ClassPoolWithRepositoryTestCase.assertNotSame((Object)poolA, (Object)strA.getClassPool());
        ClassPoolWithRepositoryTestCase.assertNotSame((Object)poolB, (Object)strB.getClassPool());
    }
}

