/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import javassist.ClassPool;
import javassist.CtClass;
import junit.framework.Test;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.support.Result;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassPoolWithPackageDependencyTestCase
extends JBossClClassPoolTest {
    public ClassPoolWithPackageDependencyTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassPoolWithPackageDependencyTestCase.suite(ClassPoolWithPackageDependencyTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportNoVersionCheck() throws Exception {
        ClassPool clA = null;
        Result rA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            clA = this.createClassPool(rA, "A", builderA, JAR_A_1);
            CtClass classA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPool clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                clB = this.createClassPool(rB, "B", builderB, JAR_B_1);
                CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA, (Object)classA1);
                this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                CtClass aFromB = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA, (Object)aFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clB);
                throw throwable;
            }
            this.unregisterClassPool(clB);
            this.assertNoClassLoader(rB);
            CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA, (Object)classA1);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clA);
            throw throwable;
        }
        this.unregisterClassPool(clA);
        this.assertNoClassLoader(rA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheck() throws Exception {
        ClassPool clA = null;
        Result rA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "1.0.0");
            clA = this.createClassPool(rA, "A", builderA, JAR_A_1);
            CtClass classA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPool clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", new VersionRange((Object)"1.0.0", (Object)"2.0.0"));
                clB = this.createClassPool(rB, "B", builderB, JAR_B_1);
                CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA, (Object)classA1);
                this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                CtClass aFromB = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA, (Object)aFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clB);
                throw throwable;
            }
            this.unregisterClassPool(clB);
            this.assertNoClassLoader(rB);
            this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clA);
            throw throwable;
        }
        this.unregisterClassPool(clA);
        this.assertNoClassLoader(rA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImportVersionCheckFailed() throws Exception {
        ClassPool clA = null;
        Result rA = new Result();
        try {
            BundleInfoBuilder builderA = BundleInfoBuilder.getBuilder().createModule("ModuleA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "3.0.0");
            clA = this.createClassPool(rA, "A", builderA, JAR_A_1);
            CtClass classA = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", new VersionRange((Object)"1.0.0", (Object)"2.0.0"));
                try {
                    this.createClassPool(rB, "B", builderB, JAR_B_1);
                    ClassPoolWithPackageDependencyTestCase.fail((String)"Should not have been able to create loader");
                }
                catch (JBossClClassPoolTest.NoSuchClassLoaderException expected) {
                    // empty catch block
                }
                CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA, (Object)classA1);
                this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            }
            finally {
                this.unregisterClassLoader("B");
            }
            CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA);
            ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA, (Object)classA1);
            this.assertCannotLoadCtClass(clA, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clA);
            throw throwable;
        }
        this.unregisterClassPool(clA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralModulesWithSamePackagesDifferentVersions() throws Exception {
        ClassPool clA1 = null;
        ClassPool clA2 = null;
        ClassPool clA3 = null;
        Result rA1 = new Result();
        Result rA2 = new Result();
        Result rA3 = new Result();
        try {
            BundleInfoBuilder builderA1 = BundleInfoBuilder.getBuilder().createModule("PackageA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "1.0.0");
            clA1 = this.createClassPool(rA1, "A1", builderA1, JAR_A_1);
            BundleInfoBuilder builderA2 = BundleInfoBuilder.getBuilder().createModule("PackageA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "2.0.0");
            clA2 = this.createClassPool(rA2, "A2", builderA2, JAR_A_1);
            BundleInfoBuilder builderA3 = BundleInfoBuilder.getBuilder().createModule("PackageA").createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", "3.0.0");
            clA3 = this.createClassPool(rA3, "A3", builderA3, JAR_A_1);
            CtClass classA1 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA1);
            CtClass classA2 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA2);
            CtClass classA3 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA3);
            this.assertCannotLoadCtClass(clA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            ClassPool clB = null;
            Result rB = new Result();
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createPackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.b").createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a", new VersionRange((Object)"1.0.0", false, (Object)"2.0.0", true));
                clB = this.createClassPool(rB, "B", builderB, JAR_B_1);
                CtClass classA11 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA1);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA1, (Object)classA11);
                CtClass classA21 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA2);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA2, (Object)classA21);
                CtClass classA31 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA3);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA3, (Object)classA31);
                this.assertCannotLoadCtClass(clA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadCtClass(clA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertCannotLoadCtClass(clA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
                this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                CtClass classAFromB = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clA2);
                ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA2, (Object)classAFromB);
            }
            catch (Throwable throwable) {
                this.unregisterClassPool(clB);
                throw throwable;
            }
            this.unregisterClassPool(clB);
            this.assertNoClassLoader(rB);
            CtClass classA11 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA1);
            ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA1, (Object)classA11);
            CtClass classA21 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA2);
            ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA2, (Object)classA21);
            CtClass classA31 = this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clA3);
            ClassPoolWithPackageDependencyTestCase.assertSame((Object)classA3, (Object)classA31);
            this.assertCannotLoadCtClass(clA1, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clA2, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
            this.assertCannotLoadCtClass(clA3, "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B");
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(clA3);
            this.unregisterClassPool(clA2);
            this.unregisterClassPool(clA1);
            throw throwable;
        }
        this.unregisterClassPool(clA3);
        this.unregisterClassPool(clA2);
        this.unregisterClassPool(clA1);
        this.assertNoClassLoader(rA1);
        this.assertNoClassLoader(rA2);
        this.assertNoClassLoader(rA3);
    }
}

