/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.support;

import java.util.Arrays;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.vfs.dependency.VFSClassLoaderPolicyModule;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.test.aop.classpool.jbosscl.support.TestVFSClassLoaderPolicyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestVFSClassLoaderFactory
extends VFSClassLoaderFactory {
    private static final long serialVersionUID = 1L;
    private ClassLoader parent;

    protected Class<? extends VFSClassLoaderPolicyModule> getModuleClass() {
        return TestVFSClassLoaderPolicyModule.class;
    }

    public void setParent(ClassLoader parent) {
        this.parent = parent;
    }

    public List<BeanMetaData> getBeans() {
        List<BeanMetaData> result = super.getBeans();
        if (this.parent != null) {
            if (result.size() != 2) {
                throw new IllegalStateException("Expected size=2, was " + result.size());
            }
            BeanMetaData classLoader = null;
            BeanMetaData module = null;
            for (BeanMetaData bean : result) {
                if (bean.getBean().equals(ClassLoader.class.getName())) {
                    classLoader = bean;
                    continue;
                }
                module = bean;
            }
            if (module == null) {
                throw new IllegalStateException("Could not find module");
            }
            if (classLoader == null) {
                throw new IllegalStateException("Could not find module");
            }
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)classLoader.getName(), (String)ClassLoader.class.getName());
            builder.setNoClassLoader();
            builder.setFactory(module.getName());
            builder.setFactoryMethod("registerClassLoaderPolicy");
            builder.addConstructorParameter(ClassLoaderSystem.class.getName(), builder.createInject((Object)this.getClassLoaderSystemName()));
            builder.addConstructorParameter(ClassLoader.class.getName(), (Object)this.parent);
            classLoader = builder.getBeanMetaData();
            result = Arrays.asList(classLoader, module);
        }
        return result;
    }
}

