/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.integration.junit;

import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPIntegrationTestDelegate
extends AbstractTestDelegate {
    private static final CopyOnWriteArrayList<ManagerURL> urls = new CopyOnWriteArrayList();
    private ClassLoaderSystem system;
    boolean weaveClasses;

    public AOPIntegrationTestDelegate(Class<?> clazz, boolean weaveClasses, ClassLoaderSystem system) {
        super(clazz);
        this.system = system;
        this.weaveClasses = weaveClasses;
    }

    public void setUp() throws Exception {
        super.setUp();
        AspectManager manager = AspectManager.instance();
        if (this.weaveClasses) {
            this.system.setTranslator((Translator)manager);
        }
        try {
            this.deploy(this.clazz.getClassLoader());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.undeploy();
        this.system.shutdown();
        this.system.setTranslator(null);
    }

    protected void deploy(ClassLoader classLoader) throws Exception {
        String testName = this.clazz.getName();
        int index = testName.indexOf("UnitTestCase");
        if (index != -1) {
            testName = testName.substring(0, index);
        }
        testName = testName.replace('.', '/') + "-aop.xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            this.deploy(url, classLoader);
        } else {
            this.log.debug((Object)("No test specific deployment " + testName));
        }
    }

    protected URL deploy(String suffix, ClassLoader classLoader) throws Exception {
        return this.deploy(suffix, classLoader, null);
    }

    protected URL deploy(String suffix, ClassLoader classLoader, AspectManager manager) throws Exception {
        String testName = this.clazz.getName();
        int index = testName.indexOf("UnitTestCase");
        if (index != -1) {
            testName = testName.substring(0, index);
        }
        testName = testName.replace('.', '/') + "-" + suffix + "-aop.xml";
        URL url = this.clazz.getClassLoader().getResource(testName);
        if (url != null) {
            if (manager == null) {
                this.deploy(url, classLoader);
            } else {
                this.deploy(url, classLoader, manager);
            }
        } else {
            throw new RuntimeException(testName + " not found");
        }
        return url;
    }

    protected void undeploy() {
        for (ManagerURL url : urls) {
            this.undeploy(url.getUrl(), url.getManager());
        }
    }

    protected void deploy(URL url, ClassLoader classLoader) throws Exception {
        this.deploy(url, classLoader, AspectManager.instance());
    }

    protected void deploy(URL url, ClassLoader classLoader, AspectManager manager) throws Exception {
        this.log.debug((Object)("Deploying " + url));
        urls.add(new ManagerURL(url, manager));
        AspectXmlLoader.deployXML((URL)url, (ClassLoader)classLoader, (AspectManager)manager);
    }

    protected void undeploy(URL url) {
        this.undeploy(url, AspectManager.instance());
    }

    protected void undeploy(URL url, AspectManager manager) {
        try {
            this.log.debug((Object)("Undeploying " + url));
            urls.remove(new ManagerURL(url, manager));
            AspectXmlLoader.undeployXML((URL)url, (AspectManager)manager);
        }
        catch (Exception e) {
            this.log.warn((Object)("Ignored error undeploying " + url), (Throwable)e);
        }
    }

    class ManagerURL {
        URL url;
        AspectManager manager;

        public ManagerURL(URL url, AspectManager manager) {
            this.url = url;
            this.manager = manager;
        }

        public AspectManager getManager() {
            return this.manager;
        }

        public URL getUrl() {
            return this.url;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.manager == null ? 0 : this.manager.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ManagerURL other = (ManagerURL)obj;
            if (this.manager == null ? other.manager != null : !this.manager.equals(other.manager)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }
}

