/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import junit.framework.Test;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.support.Result;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassLoaderWithHierarchicalDomainSanityTestCase
extends JBossClClassPoolTest {
    public ClassLoaderWithHierarchicalDomainSanityTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassLoaderWithHierarchicalDomainSanityTestCase.suite(ClassLoaderWithHierarchicalDomainSanityTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentFirst() throws Exception {
        ClassLoader clParentA = null;
        Result resultParentA = new Result();
        try {
            clParentA = this.createClassLoader(resultParentA, "aParent", true, JAR_A_1);
            this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
            this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
            ClassLoader clChildA = null;
            Result resultChildA = new Result();
            String childDomainName = "ChildDomain";
            try {
                clChildA = this.createChildDomainParentFirstClassLoader(resultChildA, "aChild", "ChildDomain", true, JAR_A_2);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clChildA, clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clChildA);
                ClassLoader clB = null;
                Result resultB = new Result();
                try {
                    BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                    clB = this.createChildDomainParentFirstClassLoader(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                    this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                    this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                    this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
                }
                catch (Throwable throwable) {
                    this.unregisterClassLoader(clB);
                    throw throwable;
                }
                this.unregisterClassLoader(clB);
                this.assertNoClassLoader(resultB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clChildA);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassLoader(clChildA);
            this.unregisterDomain("ChildDomain");
            this.assertNoClassLoader(resultChildA);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clParentA);
            throw throwable;
        }
        this.unregisterClassLoader(clParentA);
        this.assertNoClassLoader(resultParentA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLast() throws Exception {
        ClassLoader clParentA = null;
        Result resultParentA = new Result();
        try {
            clParentA = this.createClassLoader(resultParentA, "aParent", true, JAR_A_1);
            this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
            this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
            ClassLoader clChildA = null;
            Result resultChildA = new Result();
            String childDomainName = "ChildDomain";
            try {
                clChildA = this.createChildDomainParentLastClassLoader(resultChildA, "aChild", "ChildDomain", true, JAR_A_2);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clChildA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clChildA);
                ClassLoader clB = null;
                Result resultB = new Result();
                try {
                    BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                    clB = this.createChildDomainParentLastClassLoader(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                    this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clChildA);
                    this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                    this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clChildA);
                }
                catch (Throwable throwable) {
                    this.unregisterClassLoader(clB);
                    throw throwable;
                }
                this.unregisterClassLoader(clB);
                this.assertNoClassLoader(resultB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clChildA);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassLoader(clChildA);
            this.unregisterDomain("ChildDomain");
            this.assertNoClassLoader(resultChildA);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clParentA);
            throw throwable;
        }
        this.unregisterClassLoader(clParentA);
        this.assertNoClassLoader(resultParentA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLastNotInChild() throws Exception {
        ClassLoader clParentA = null;
        Result resultParentA = new Result();
        try {
            clParentA = this.createClassLoader(resultParentA, "aParent", true, JAR_A_1);
            this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
            this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
            ClassLoader clB = null;
            Result resultB = new Result();
            String childDomainName = "ChildDomain";
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                clB = this.createChildDomainParentLastClassLoader(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.unregisterDomain("ChildDomain");
            this.assertNoClassLoader(resultB);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clParentA);
            throw throwable;
        }
        this.unregisterClassLoader(clParentA);
        this.assertNoClassLoader(resultParentA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentFirstWrongWayAround() throws Exception {
        ClassLoader clB = null;
        Result resultB = new Result();
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                clB = this.createChildDomainParentFirstClassLoader(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                ClassLoaderWithHierarchicalDomainSanityTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassLoader(resultB);
            ClassLoader clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createClassLoader(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                clB = this.assertClassLoader(resultB.getFactory());
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clParentA);
                throw throwable;
            }
            this.unregisterClassLoader(clParentA);
            this.assertNoClassLoader(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassLoader(clB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassLoader(resultB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLastWrongWayAround() throws Exception {
        ClassLoader clB = null;
        Result resultB = new Result();
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                clB = this.createChildDomainParentLastClassLoader(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                ClassLoaderWithHierarchicalDomainSanityTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassLoader(resultB);
            ClassLoader clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createClassLoader(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                clB = this.assertClassLoader(resultB.getFactory());
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clParentA);
                throw throwable;
            }
            this.unregisterClassLoader(clParentA);
            this.assertNoClassLoader(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassLoader(clB);
        this.unregisterDomain("ChildDomain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentRedeploy() throws Exception {
        ClassLoader clB = null;
        Result resultB = new Result();
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                clB = this.createChildDomainParentFirstClassLoader(resultB, "b", "ChildDomain", builderB, JAR_B_1);
                ClassLoaderWithHierarchicalDomainSanityTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassLoader(resultB);
            ClassLoader clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createClassLoader(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                clB = this.assertClassLoader(resultB.getFactory());
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clParentA);
                throw throwable;
            }
            this.unregisterClassLoader(clParentA);
            this.assertNoClassLoader(resultParentA);
            this.assertNoClassLoader(resultB);
            try {
                clParentA = this.createClassLoader(resultParentA, "aParent", true, JAR_A_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                clB = this.assertClassLoader(resultB.getFactory());
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
            }
            finally {
                this.unregisterClassLoader(clParentA);
            }
            this.assertNoClassLoader(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassLoader(clB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassLoader(resultB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentOtherDomain() throws Exception {
        ClassLoader clParentA = null;
        Result resultParentA = new Result();
        String parentDomainName = "ParentDomain";
        try {
            clParentA = this.createChildDomainParentFirstClassLoader(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
            this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
            this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
            ClassLoader clB = null;
            Result resultB = new Result();
            String childDomainName = "ChildDomain";
            try {
                BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
                clB = this.createChildDomainParentFirstClassLoader(resultB, "b", "ChildDomain", "ParentDomain", builderB, JAR_B_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clB);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clB);
                this.unregisterDomain("ChildDomain");
                throw throwable;
            }
            this.unregisterClassLoader(clB);
            this.unregisterDomain("ChildDomain");
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clParentA);
            this.unregisterDomain("ParentDomain");
            throw throwable;
        }
        this.unregisterClassLoader(clParentA);
        this.unregisterDomain("ParentDomain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentOtherDomainLazy() throws Exception {
        ClassLoader clB = null;
        Result resultB = new Result();
        String parentDomainName = "ParentDomain";
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                clB = this.createChildDomainParentFirstClassLoader(resultB, "b", "ChildDomain", "ParentDomain", builderB, JAR_B_1);
                ClassLoaderWithHierarchicalDomainSanityTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassLoader(resultB);
            ClassLoader clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createChildDomainParentFirstClassLoader(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                clB = this.assertClassLoader(resultB.getFactory());
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clParentA);
                this.unregisterDomain("ParentDomain");
                throw throwable;
            }
            this.unregisterClassLoader(clParentA);
            this.unregisterDomain("ParentDomain");
            this.assertNoClassLoader(resultParentA);
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassLoader(clB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassLoader(resultB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentRedeployOtherDomain() throws Exception {
        ClassLoader clB = null;
        Result resultB = new Result();
        String parentDomainName = "ParentDomain";
        String childDomainName = "ChildDomain";
        try {
            BundleInfoBuilder builderB = BundleInfoBuilder.getBuilder().createRequirePackage("org.jboss.test.aop.classpool.jbosscl.support.excluded.a");
            try {
                clB = this.createChildDomainParentFirstClassLoader(resultB, "b", "ChildDomain", "ParentDomain", builderB, JAR_B_1);
                ClassLoaderWithHierarchicalDomainSanityTestCase.fail((String)"Should be no loader");
            }
            catch (JBossClClassPoolTest.NoSuchClassLoaderException e) {
                // empty catch block
            }
            this.assertNoClassLoader(resultB);
            ClassLoader clParentA = null;
            Result resultParentA = new Result();
            try {
                clParentA = this.createChildDomainParentFirstClassLoader(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                clB = this.assertClassLoader(resultB.getFactory());
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
            }
            catch (Throwable throwable) {
                this.unregisterClassLoader(clParentA);
                this.unregisterDomain("ParentDomain");
                throw throwable;
            }
            this.unregisterClassLoader(clParentA);
            this.unregisterDomain("ParentDomain");
            this.assertNoClassLoader(resultParentA);
            this.assertNoClassLoader(resultB);
            try {
                clParentA = this.createChildDomainParentFirstClassLoader(resultParentA, "aParent", "ParentDomain", true, JAR_A_1);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                clB = this.assertClassLoader(resultB.getFactory());
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clParentA);
                this.assertCannotLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B", clParentA);
                this.assertLoadClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", clB, clParentA);
            }
            finally {
                this.unregisterClassLoader(clParentA);
                this.unregisterDomain("ParentDomain");
            }
        }
        catch (Throwable throwable) {
            this.unregisterClassLoader(clB);
            this.unregisterDomain("ChildDomain");
            throw throwable;
        }
        this.unregisterClassLoader(clB);
        this.unregisterDomain("ChildDomain");
        this.assertNoClassLoader(resultB);
    }
}

