/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import java.net.URL;
import javassist.ClassPool;
import junit.framework.Test;
import org.jboss.classloader.plugins.filter.NothingClassFilter;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.test.aop.classpool.jbosscl.support.NoMatchClassFilter;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;

public class ClassPoolWithHierarchicalParentLoaderTestCase
extends JBossClClassPoolTest {
    public ClassPoolWithHierarchicalParentLoaderTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassPoolWithHierarchicalParentLoaderTestCase.suite(ClassPoolWithHierarchicalParentLoaderTestCase.class);
    }

    public void testHierarchyBefore() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.BEFORE, true);
    }

    public void testHierarchyBeforeNotFound() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.BEFORE, false, false);
    }

    public void testHierarchyAfterNotReached() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.AFTER_BUT_JAVA_BEFORE, false);
    }

    public void testHierarchyAfterReached() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.AFTER_BUT_JAVA_BEFORE, null, true);
    }

    public void testHierarchyFiltered() throws Exception {
        NoMatchClassFilter filter = new NoMatchClassFilter("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A");
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, new ParentPolicy((ClassFilter)filter, (ClassFilter)NothingClassFilter.INSTANCE), false);
        ClassPoolWithHierarchicalParentLoaderTestCase.assertTrue((String)"Should have been filtered", (boolean)filter.filtered);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, true, JAR_A_2, expectedParent);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean createParent, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, createParent, JAR_A_2, expectedParent);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, URL url, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, true, null, expectedParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean createParent, URL childURL, boolean expectedParent) throws Exception {
        String parentName = "parent";
        String childName = "child";
        ClassLoaderDomain parent = ClassPoolWithHierarchicalParentLoaderTestCase.getSystem().createAndRegisterDomain("parent", parentParentPolicy);
        ClassLoaderDomain child = ClassPoolWithHierarchicalParentLoaderTestCase.getSystem().createAndRegisterDomain("child", childParentPolicy, (Loader)parent);
        ClassPool parentPool = null;
        ClassPool childPool = null;
        try {
            if (createParent) {
                parentPool = this.createChildDomainParentLastClassPool("ParentLoader", "parent", true, JAR_A_1);
            }
            childPool = this.createChildDomainParentLastClassPool("ChildLoader", "child", "parent", true, childURL);
            this.assertLoadCtClass("org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A", childPool, expectedParent ? parentPool : childPool);
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(parentPool);
            this.unregisterClassPool(childPool);
            this.unregisterDomain(child);
            this.unregisterDomain(parent);
            throw throwable;
        }
        this.unregisterClassPool(parentPool);
        this.unregisterClassPool(childPool);
        this.unregisterDomain(child);
        this.unregisterDomain(parent);
    }
}

