/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.scopedpool.ScopedClassPoolRepository;
import junit.framework.Test;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.aop.classpool.jbosscl.test.AlwaysWritablePermissionCollectionTestPolicyPluginTestDelegate;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPoolWithReplaceReferencesTestCase
extends JBossClClassPoolTest {
    static final String STRING = String.class.getName();
    public static final URL JAR_PARENT = ClassPoolWithReplaceReferencesTestCase.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-replacereferences-parent.jar");
    public static final URL JAR_CHILD = ClassPoolWithReplaceReferencesTestCase.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-replacereferences-child.jar");
    public static final String PACKAGE_REPLACEMENT = "org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences";
    public static final String PACKAGE_REPLACEMENT_CHILD = "org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.child";
    public static final String PACKAGE_REPLACEMENT_PARENT = "org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.parent";
    public static final String CLASS_INVOKED = "org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.Invoked";
    public static final String CLASS_PARENT_CALLER = "org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.parent.ParentCaller";
    public static final String CLASS_CHILD_CALLER = "org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.child.ChildCaller";
    public final String x = "org.jboss.test.aop.classpool.jbosscl.support.excluded";
    private static final Translator TRANSLATOR = new MyTranslator();

    public ClassPoolWithReplaceReferencesTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ClassPoolWithReplaceReferencesTestCase.suite(ClassPoolWithReplaceReferencesTestCase.class);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new AlwaysWritablePermissionCollectionTestPolicyPluginTestDelegate(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLoadedParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(TRANSLATOR);
            globalPool = this.createClassPool("GLOBAL", true, JAR_PARENT);
            scopedPool = this.createChildDomainParentFirstClassPool("SCOPED", "SCOPED", true, JAR_CHILD);
            this.loadClassAndRunTest(CLASS_PARENT_CALLER, globalPool.getClassLoader());
            this.loadClassAndRunTest(CLASS_CHILD_CALLER, scopedPool.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPool);
            this.unregisterClassPool(scopedPool);
            this.unregisterDomain(scopedPool);
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
            throw throwable;
        }
        this.unregisterClassPool(globalPool);
        this.unregisterClassPool(scopedPool);
        this.unregisterDomain(scopedPool);
        ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentLoadedNoParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(TRANSLATOR);
            globalPool = this.createClassPool("GLOBAL", true, JAR_PARENT);
            scopedPool = this.createChildDomainParentLastClassPool("SCOPED", "SCOPED", true, JAR_CHILD);
            this.loadClassAndRunTest(CLASS_PARENT_CALLER, globalPool.getClassLoader());
            this.loadClassAndRunTest(CLASS_CHILD_CALLER, scopedPool.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPool);
            this.unregisterClassPool(scopedPool);
            this.unregisterDomain(scopedPool);
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
            throw throwable;
        }
        this.unregisterClassPool(globalPool);
        this.unregisterClassPool(scopedPool);
        this.unregisterDomain(scopedPool);
        ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentNotLoadedParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(TRANSLATOR);
            globalPool = this.createClassPool("GLOBAL", true, JAR_PARENT);
            scopedPool = this.createChildDomainParentFirstClassPool("SCOPED", "SCOPED", true, JAR_CHILD);
            this.loadClassAndRunTest(CLASS_CHILD_CALLER, scopedPool.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPool);
            this.unregisterClassPool(scopedPool);
            this.unregisterDomain(scopedPool);
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
            throw throwable;
        }
        this.unregisterClassPool(globalPool);
        this.unregisterClassPool(scopedPool);
        this.unregisterDomain(scopedPool);
        ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentNotLoadedNoParentDelegation() throws Exception {
        ClassPool globalPool = null;
        ClassPool scopedPool = null;
        try {
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(TRANSLATOR);
            globalPool = this.createClassPool("GLOBAL", true, JAR_PARENT);
            scopedPool = this.createChildDomainParentLastClassPool("SCOPED", "SCOPED", true, JAR_CHILD);
            this.loadClassAndRunTest(CLASS_CHILD_CALLER, scopedPool.getClassLoader());
        }
        catch (Throwable throwable) {
            this.unregisterClassPool(globalPool);
            this.unregisterClassPool(scopedPool);
            this.unregisterDomain(scopedPool);
            ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
            throw throwable;
        }
        this.unregisterClassPool(globalPool);
        this.unregisterClassPool(scopedPool);
        this.unregisterDomain(scopedPool);
        ClassPoolWithReplaceReferencesTestCase.getSystem().setTranslator(null);
    }

    private void loadClassAndRunTest(String classname, ClassLoader loader) throws Exception {
        Class<?> caller = loader.loadClass(classname);
        Method m = caller.getMethod("test", new Class[0]);
        m.invoke(null, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MyTranslator
    implements Translator {
        MyTranslator() {
        }

        public void unregisterClassLoader(DomainClassLoader loader) {
        }

        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws Exception {
            if (!className.startsWith(ClassPoolWithReplaceReferencesTestCase.PACKAGE_REPLACEMENT)) {
                return null;
            }
            if (className.endsWith("Invoked")) {
                return null;
            }
            ClassPool pool = AspectManager.instance().registerClassLoader(loader);
            CtClass clazz = pool.get(className);
            if (className.endsWith("Caller")) {
                this.instrumentReplaceReferences(clazz);
            } else {
                this.instrumentCreateWrappers(clazz);
            }
            if (clazz.isModified()) {
                return clazz.toBytecode();
            }
            return null;
        }

        private CtClass instrumentCreateWrappers(CtClass clazz) {
            try {
                if (!clazz.getName().startsWith(ClassPoolWithReplaceReferencesTestCase.PACKAGE_REPLACEMENT)) {
                    return clazz;
                }
                this.addWrappersToClass(clazz);
            }
            catch (Exception e) {
                System.err.println("Exception creating wrappers for " + clazz);
                e.printStackTrace();
            }
            return clazz;
        }

        private CtClass instrumentReplaceReferences(CtClass clazz) throws Exception {
            if (!clazz.getName().startsWith(ClassPoolWithReplaceReferencesTestCase.PACKAGE_REPLACEMENT)) {
                return clazz;
            }
            this.replaceReferences(clazz);
            return clazz;
        }

        public void unregisterClassLoader(ClassLoader loader) {
        }

        private void addWrappersToClass(CtClass clazz) throws Exception {
            this.addFieldWrappers(clazz);
            this.addConstructorWrappers(clazz);
        }

        private void addFieldWrappers(CtClass clazz) throws Exception {
            CtClass objectCt = clazz.getClassPool().getCtClass(Object.class.getName());
            for (CtField field : clazz.getFields()) {
                if (field.getDeclaringClass() == objectCt) continue;
                CtMethod rmethod = CtNewMethod.make((int)9, (CtClass)CtClass.intType, (String)this.getFieldReadWrapperName(field.getName()), (CtClass[])new CtClass[]{objectCt}, null, (String)("{org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.Invoked.invoked = true; return ((" + clazz.getName() + ")$1)." + field.getName() + ";}"), (CtClass)clazz);
                clazz.addMethod(rmethod);
                CtMethod wmethod = CtNewMethod.make((int)9, (CtClass)CtClass.voidType, (String)this.getFieldWriteWrapperName(field.getName()), (CtClass[])new CtClass[]{objectCt, field.getType()}, null, (String)("{org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.Invoked.invoked = true; ((" + clazz.getName() + ")$1)." + field.getName() + "=(int)$2;}"), (CtClass)clazz);
                clazz.addMethod(wmethod);
            }
        }

        private void addConstructorWrappers(CtClass clazz) throws Exception {
            for (CtConstructor ctor : clazz.getConstructors()) {
                CtMethod wrapper = CtNewMethod.make((CtClass)clazz, (String)this.getConstructorName(clazz), (CtClass[])ctor.getParameterTypes(), null, (String)("{org.jboss.test.aop.classpool.jbosscl.support.excluded.replacereferences.Invoked.invoked = true; return new " + clazz.getName() + "($$);}"), (CtClass)clazz);
                wrapper.setModifiers(9);
                clazz.addMethod(wrapper);
            }
        }

        private void replaceReferences(final CtClass clazz) throws Exception {
            CodeConverter conv = new CodeConverter();
            AOPClassPool pool = AOPClassPool.createAOPClassPool((ClassPool)clazz.getClassPool(), (ScopedClassPoolRepository)AOPClassPoolRepository.getInstance());
            Collection<String> refs = AccessController.doPrivileged(new PrivilegedAction<Collection<String>>(){

                @Override
                public Collection<String> run() {
                    return clazz.getRefClasses();
                }
            });
            for (String ref : refs) {
                CtField[] fields;
                if (!ref.startsWith(ClassPoolWithReplaceReferencesTestCase.PACKAGE_REPLACEMENT_CHILD) && !ref.startsWith(ClassPoolWithReplaceReferencesTestCase.PACKAGE_REPLACEMENT_PARENT) || ref.endsWith("Caller")) continue;
                CtClass ctRef = pool.get(ref);
                for (CtField fld : fields = ctRef.getDeclaredFields()) {
                    conv.replaceFieldRead(fld, ctRef, this.getFieldReadWrapperName(fld.getName()));
                    conv.replaceFieldWrite(fld, ctRef, this.getFieldWriteWrapperName(fld.getName()));
                }
                conv.replaceNew(ctRef, ctRef, this.getConstructorName(ctRef));
            }
            clazz.instrument(conv);
        }

        private String getFieldReadWrapperName(String fieldName) {
            return fieldName + "_read";
        }

        private String getFieldWriteWrapperName(String fieldName) {
            return fieldName + "_write";
        }

        private String getConstructorName(CtClass clazz) {
            return clazz.getSimpleName() + "_new";
        }
    }
}

