/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.classpool.jbosscl.test;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.scopedpool.ScopedClassPoolFactory;
import junit.framework.Test;
import org.jboss.aop.AspectManager;
import org.jboss.aop.asintegration.jboss5.DomainRegistry;
import org.jboss.aop.asintegration.jboss5.RegisterModuleCallback;
import org.jboss.aop.asintegration.jboss5.VFSClassLoaderDomainRegistry;
import org.jboss.aop.classpool.jbosscl.JBossClDelegatingClassPoolFactory;
import org.jboss.classloader.plugins.filter.CombiningClassFilter;
import org.jboss.classloader.plugins.filter.NothingClassFilter;
import org.jboss.classloader.plugins.filter.PatternClassFilter;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.test.support.IsolatedClassLoaderTestHelper;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.aop.classpool.jbosscl.support.BundleInfoBuilder;
import org.jboss.test.aop.classpool.jbosscl.support.Result;
import org.jboss.test.aop.classpool.jbosscl.support.TestVFSClassLoaderFactory;
import org.jboss.test.aop.classpool.jbosscl.support.TestVFSClassLoaderFactoryFactory;
import org.jboss.test.aop.classpool.jbosscl.test.JBossClClassPoolTestDelegate;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossClClassPoolTest
extends MicrocontainerTest {
    public static final URL JAR_A_1 = JBossClClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-a1.jar");
    public static final URL JAR_A_2 = JBossClClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-a2.jar");
    public static final URL JAR_B_1 = JBossClClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-b1.jar");
    public static final URL JAR_B_2 = JBossClClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-b2.jar");
    public static final URL JAR_C_1 = JBossClClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-c1.jar");
    public static final URL JAR_C_2 = JBossClClassPoolTest.getURLRelativeToProjectRoot("target/jboss-aop-asintegration-mc-test-classpool-c2.jar");
    public static final String PACKAGE_ROOT = "org.jboss.test.aop.classpool.jbosscl.support.excluded";
    public static final String PACKAGE_A = "org.jboss.test.aop.classpool.jbosscl.support.excluded.a";
    public static final String PACKAGE_B = "org.jboss.test.aop.classpool.jbosscl.support.excluded.b";
    public static final String PACKAGE_C = "org.jboss.test.aop.classpool.jbosscl.support.excluded.c";
    public static final String CLASS_A = "org.jboss.test.aop.classpool.jbosscl.support.excluded.a.A";
    public static final String CLASS_B = "org.jboss.test.aop.classpool.jbosscl.support.excluded.b.B";
    public static final String CLASS_C = "org.jboss.test.aop.classpool.jbosscl.support.excluded.c.C";
    static final Set<URLClassLoader> registeredURLClassLoaders = new HashSet<URLClassLoader>();
    private Map<ClassLoader, ClassLoaderDomain> scopedChildDomainsByLoader = new WeakHashMap<ClassLoader, ClassLoaderDomain>();
    private LoaderNameDeploymentRegistry loaderNameDeploymentRegistry = new LoaderNameDeploymentRegistry();
    private final List<Closeable> mountHandles = new LinkedList<Closeable>();
    protected static final ClassLoaderSystem system = ClassLoaderSystem.getInstance();
    private static boolean initialisedDefaultDomain;
    private static final ClassFilter aopFilter;
    protected static VFSClassLoaderDomainRegistry domainRegistry;
    ClassLoading classLoading = new ClassLoading();

    public static ClassLoaderSystem getSystem() {
        if (!initialisedDefaultDomain) {
            ClassLoaderDomain defaultDomain = system.getDefaultDomain();
            Set parentPackages = IsolatedClassLoaderTestHelper.getParentPackages();
            String[] parentPkgs = parentPackages.toArray(new String[parentPackages.size()]);
            PackageClassFilter filter = new PackageClassFilter(parentPkgs);
            filter.setIncludeJava(true);
            CombiningClassFilter beforeFilter = CombiningClassFilter.create((ClassFilter[])new ClassFilter[]{filter, aopFilter});
            ParentPolicy parentPolicy = new ParentPolicy((ClassFilter)beforeFilter, (ClassFilter)NothingClassFilter.INSTANCE);
            defaultDomain.setParentPolicy(parentPolicy);
        }
        return system;
    }

    public static Test suite(Class<?> clazz) {
        return AbstractTestCaseWithSetup.suite(clazz);
    }

    public JBossClClassPoolTest(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new JBossClClassPoolTestDelegate(clazz);
    }

    protected static URL getURLRelativeToProjectRoot(String relativePath) {
        try {
            URL url = JBossClClassPoolTest.class.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            int index = location.lastIndexOf("/asintegration-mc/") + "/asintegration-mc/".length();
            location = location.substring(0, index);
            location = location + relativePath;
            return new URL(location);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected ClassLoaderDomain getDefaultDomain() {
        return JBossClClassPoolTest.getSystem().getDefaultDomain();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.deploy("/org/jboss/test/aop/classpool/jbosscl/Common.xml");
        this.mountJars(JAR_A_1, JAR_A_2, JAR_B_1, JAR_B_2, JAR_C_1, JAR_C_2);
    }

    protected void mountJars(URL ... jarUrls) throws IOException, URISyntaxException {
        TempFileProvider tempFileProvider = TempFileProvider.create((String)"test", (ScheduledExecutorService)Executors.newScheduledThreadPool(2));
        for (URL jarUrl : jarUrls) {
            VirtualFile jarFile = VFS.getChild((URL)jarUrl);
            this.mountHandles.add(VFS.mountZip((VirtualFile)jarFile, (VirtualFile)jarFile, (TempFileProvider)tempFileProvider));
        }
    }

    protected void tearDown() throws Exception {
        VFSUtils.safeClose(this.mountHandles);
        this.undeploy("/org/jboss/test/aop/classpool/jbosscl/Common.xml");
        super.tearDown();
    }

    protected String array(String name) {
        return name + "[]";
    }

    protected ClassLoader createClassLoader(String name, boolean importAll, URL ... urls) throws Exception {
        return this.createClassLoader(null, name, importAll, urls);
    }

    protected ClassLoader createClassLoader(Result result, String name, boolean importAll, URL ... urls) throws Exception {
        TestVFSClassLoaderFactory factory = TestVFSClassLoaderFactoryFactory.createClassLoaderFactory(name, importAll, urls);
        return this.createClassLoader(result, factory);
    }

    protected ClassLoader createClassLoader(String name, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createClassLoader(null, name, builder, urls);
    }

    protected ClassLoader createClassLoader(Result result, String name, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createClassLoader(result, name, false, builder, urls);
    }

    protected ClassLoader createClassLoader(String name, boolean importAll, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createClassLoader(null, name, importAll, builder, urls);
    }

    protected ClassLoader createClassLoader(Result result, String name, boolean importAll, BundleInfoBuilder builder, URL ... urls) throws Exception {
        TestVFSClassLoaderFactory factory = TestVFSClassLoaderFactoryFactory.createClassLoaderFactory(name, importAll, builder, urls);
        return this.createClassLoader(result, factory);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassLoader((Result)null, name, domainName, importAll, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(Result result, String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassLoader(result, name, domainName, importAll, (ClassLoader)null, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(String name, String domainName, boolean importAll, ClassLoader parent, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassLoader(null, name, domainName, importAll, parent, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(Result result, String name, String domainName, boolean importAll, ClassLoader parent, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(result, name, domainName, null, true, importAll, parent, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassLoader(null, name, domainName, parentDomainName, importAll, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(Result result, String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(result, name, domainName, parentDomainName, true, importAll, null, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassLoader((Result)null, name, domainName, importAll, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(Result result, String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassLoader(result, name, domainName, importAll, (ClassLoader)null, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(String name, String domainName, boolean importAll, ClassLoader parent, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassLoader(null, name, domainName, importAll, parent, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(Result result, String name, String domainName, boolean importAll, ClassLoader parent, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(result, name, domainName, null, false, importAll, parent, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassLoader(null, name, domainName, parentDomainName, importAll, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(Result result, String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(result, name, domainName, parentDomainName, false, importAll, null, urls);
    }

    protected ClassLoader createChildDomainClassLoader(String name, String domainName, String parentDomainName, boolean parentFirst, boolean importAll, ClassLoader parent, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(null, name, domainName, parentDomainName, parentFirst, importAll, parent, urls);
    }

    protected ClassLoader createChildDomainClassLoader(Result result, String name, String domainName, String parentDomainName, boolean parentFirst, boolean importAll, ClassLoader parent, URL ... urls) throws Exception {
        TestVFSClassLoaderFactory factory = TestVFSClassLoaderFactoryFactory.createClassLoaderFactory(name, importAll, domainName, parentDomainName, parentFirst, urls);
        ClassLoader classLoader = this.createClassLoader(result, factory, parent);
        this.registerDomainAndLoader(classLoader, domainName);
        return classLoader;
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassLoader((Result)null, name, domainName, builder, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(Result result, String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassLoader(result, name, domainName, null, builder, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(String name, String domainName, String parentDomainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassLoader(null, name, domainName, parentDomainName, builder, urls);
    }

    protected ClassLoader createChildDomainParentFirstClassLoader(Result result, String name, String domainName, String parentDomainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(result, name, domainName, parentDomainName, builder, true, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassLoader((Result)null, name, domainName, builder, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(Result result, String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassLoader(result, name, domainName, null, builder, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(String name, String domainName, String parentDomainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassLoader(null, name, domainName, parentDomainName, builder, urls);
    }

    protected ClassLoader createChildDomainParentLastClassLoader(Result result, String name, String domainName, String parentDomainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(result, name, domainName, parentDomainName, builder, false, urls);
    }

    protected ClassLoader createChildDomainClassLoader(String name, String domainName, String parentDomainName, BundleInfoBuilder builder, boolean parentFirst, URL ... urls) throws Exception {
        return this.createChildDomainClassLoader(null, name, domainName, parentDomainName, builder, parentFirst, urls);
    }

    protected ClassLoader createChildDomainClassLoader(Result result, String name, String domainName, String parentDomainName, BundleInfoBuilder builder, boolean parentFirst, URL ... urls) throws Exception {
        TestVFSClassLoaderFactory factory = TestVFSClassLoaderFactoryFactory.createClassLoaderFactory(name, domainName, parentDomainName, builder, parentFirst, urls);
        ClassLoader classLoader = this.createClassLoader(result, factory);
        this.registerDomainAndLoader(classLoader, domainName);
        return classLoader;
    }

    private void registerDomainAndLoader(ClassLoader classLoader, String domainName) {
        ClassLoaderDomain domain = JBossClClassPoolTest.getSystem().getDomain(domainName);
        this.scopedChildDomainsByLoader.put(classLoader, domain);
    }

    protected ClassLoader createChildURLClassLoader(ClassLoader parent, URL url) {
        URLClassLoader cl = new URLClassLoader(new URL[]{url}, parent);
        registeredURLClassLoaders.add(cl);
        return cl;
    }

    private ClassLoader createClassLoader(Result result, TestVFSClassLoaderFactory factory) throws Exception {
        return this.createClassLoader(result, factory, null);
    }

    private ClassLoader createClassLoader(Result result, TestVFSClassLoaderFactory factory, ClassLoader parent) throws Exception {
        if (parent != null) {
            factory.setParent(parent);
        }
        KernelDeployment deployment = this.install(factory);
        this.loaderNameDeploymentRegistry.registerDeployment(factory.getName(), deployment);
        if (result != null) {
            result.setFactory(factory);
        }
        ClassLoader loader = this.assertClassLoader(factory, parent);
        return loader;
    }

    protected ClassLoaderDomain getChildDomainForLoader(ClassLoader loader) {
        return this.scopedChildDomainsByLoader.get(loader);
    }

    protected ClassLoaderDomain getChildDomainForPool(ClassPool pool) {
        return this.getChildDomainForLoader(pool.getClassLoader());
    }

    protected void unregisterDomain(ClassLoaderDomain domain) {
        if (domain != null) {
            ClassLoaderDomain registeredDomain = JBossClClassPoolTest.getSystem().getDomain(domain.getName());
            if (registeredDomain == null) {
                throw new IllegalStateException("Domain is not registered: " + domain.getName());
            }
            if (registeredDomain != domain) {
                throw new IllegalStateException(domain + " is not the same as " + registeredDomain);
            }
            JBossClClassPoolTest.getSystem().unregisterDomain(domain);
        }
    }

    protected void unregisterDomain(ClassLoader loader) {
        if (loader != null) {
            ClassLoaderDomain domain = this.getChildDomainForLoader(loader);
            this.unregisterDomain(domain);
        }
    }

    protected void unregisterDomain(ClassPool pool) {
        if (pool != null) {
            ClassLoaderDomain domain = this.getChildDomainForPool(pool);
            this.unregisterDomain(domain);
        }
    }

    protected void assertCannotLoadClass(ClassLoader cl, String className) {
        try {
            cl.loadClass(className);
            JBossClClassPoolTest.fail((String)("Should not have been able to load " + className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void assertCannotLoadClass(String className, ClassLoader cl) {
        this.assertCannotLoadClass(cl, className);
    }

    protected void assertCannotLoadCtClass(ClassPool pool, String className) {
        try {
            pool.get(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void assertCannotLoadCtClass(String className, ClassPool pool) {
        this.assertCannotLoadCtClass(pool, className);
    }

    protected void assertCannotLoadClass(ClassLoaderDomain domain, String className) {
        try {
            Class clazz = domain.loadClass(className);
            if (clazz == null) {
                return;
            }
            JBossClClassPoolTest.fail((String)("Should not have been able to load " + className));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ClassPool createClassPool(String name, boolean importAll, URL ... urls) throws Exception {
        return this.createClassPool(null, name, importAll, urls);
    }

    protected ClassPool createClassPool(Result result, String name, boolean importAll, URL ... urls) throws Exception {
        ClassLoader loader = this.createClassLoader(result, name, importAll, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createClassPool(String name, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createClassPool(null, name, builder, urls);
    }

    protected ClassPool createClassPool(Result result, String name, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createClassPool(result, name, false, builder, urls);
    }

    protected ClassPool createClassPool(String name, boolean importAll, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createClassPool(null, name, importAll, builder, urls);
    }

    protected ClassPool createClassPool(Result result, String name, boolean importAll, BundleInfoBuilder builder, URL ... urls) throws Exception {
        TestVFSClassLoaderFactory factory = TestVFSClassLoaderFactoryFactory.createClassLoaderFactory(name, importAll, builder, urls);
        ClassLoader loader = this.createClassLoader(result, factory);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentFirstClassPool(String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassPool((Result)null, name, domainName, importAll, urls);
    }

    protected ClassPool createChildDomainParentFirstClassPool(Result result, String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentFirstClassLoader(result, name, domainName, importAll, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentFirstClassPool(String name, String domainName, boolean importAll, ClassPool parent, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassPool(null, name, domainName, importAll, parent, urls);
    }

    protected ClassPool createChildDomainParentFirstClassPool(Result result, String name, String domainName, boolean importAll, ClassPool parent, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentFirstClassLoader(result, name, domainName, importAll, parent.getClassLoader(), urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentFirstClassPool(String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassPool(null, name, domainName, parentDomainName, importAll, urls);
    }

    protected ClassPool createChildDomainParentFirstClassPool(Result result, String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentFirstClassLoader(result, name, domainName, parentDomainName, importAll, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentLastClassPool(String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassPool((Result)null, name, domainName, importAll, urls);
    }

    protected ClassPool createChildDomainParentLastClassPool(Result result, String name, String domainName, boolean importAll, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentLastClassLoader(result, name, domainName, importAll, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentLastClassPool(String name, String domainName, boolean importAll, ClassPool parent, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassPool(null, name, domainName, importAll, parent, urls);
    }

    protected ClassPool createChildDomainParentLastClassPool(Result result, String name, String domainName, boolean importAll, ClassPool parent, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentLastClassLoader(result, name, domainName, importAll, parent.getClassLoader(), urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentLastClassPool(String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassPool(null, name, domainName, parentDomainName, importAll, urls);
    }

    protected ClassPool createChildDomainParentLastClassPool(Result result, String name, String domainName, String parentDomainName, boolean importAll, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentLastClassLoader(result, name, domainName, parentDomainName, importAll, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentFirstClassPool(String name, String domainName, String parentDomainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassPool(null, name, domainName, parentDomainName, builder, urls);
    }

    protected ClassPool createChildDomainParentFirstClassPool(Result result, String name, String domainName, String parentDomainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentFirstClassLoader(result, name, domainName, parentDomainName, builder, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentFirstClassPool(String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentFirstClassPool((Result)null, name, domainName, builder, urls);
    }

    protected ClassPool createChildDomainParentFirstClassPool(Result result, String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentFirstClassLoader(result, name, domainName, builder, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildDomainParentLastClassPool(String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        return this.createChildDomainParentLastClassPool(null, name, domainName, builder, urls);
    }

    protected ClassPool createChildDomainParentLastClassPool(Result result, String name, String domainName, BundleInfoBuilder builder, URL ... urls) throws Exception {
        ClassLoader loader = this.createChildDomainParentLastClassLoader(result, name, domainName, builder, urls);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected ClassPool createChildURLClassPool(ClassPool parent, URL url) {
        ClassLoader parentLoader = null;
        if (parent != null) {
            parentLoader = parent.getClassLoader();
        }
        ClassLoader loader = this.createChildURLClassLoader(parentLoader, url);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected void registerModule(ClassLoader loader, Module module) {
        this.registerModule(loader, module, null);
    }

    protected void registerModule(ClassLoader loader, Module module, ClassLoader parent) {
        if (JBossClClassPoolTest.getSystem() != domainRegistry.getSystem()) {
            domainRegistry.setSystem(JBossClClassPoolTest.getSystem());
        }
        domainRegistry.initMapsForLoader(loader, module, null, parent);
    }

    protected void unregisterModule(ClassLoader loader) {
        domainRegistry.cleanupLoader(loader);
    }

    protected void assertModule(ClassLoader loader) {
        ClassLoaderDomain domainForLoader = this.scopedChildDomainsByLoader.get(loader);
        if (domainForLoader == null) {
            domainForLoader = JBossClClassPoolTest.getSystem().getDefaultDomain();
        }
        JBossClClassPoolTest.assertNotNull((Object)domainForLoader);
        ClassLoaderDomain domainForModule = domainRegistry.getClassLoaderDomainForLoader(loader);
        JBossClClassPoolTest.assertNotNull((Object)domainForModule);
        JBossClClassPoolTest.assertSame((Object)domainForLoader, (Object)domainForModule);
        Module module = domainRegistry.getModule(loader);
        JBossClClassPoolTest.assertNotNull((Object)module);
        JBossClClassPoolTest.assertEquals((String)domainForModule.getName(), (String)module.getDomainName());
        JBossClClassPoolTest.assertEquals((String)domainForModule.getParentDomainName(), (String)module.getParentDomainName());
    }

    protected void assertNoClassLoader(Result result) throws Exception {
        if (result == null) {
            throw new IllegalStateException("Null result");
        }
        this.assertNoClassLoader(this.getContextName(result.getFactory()));
    }

    protected void assertNoClassPool(Result result) throws Exception {
        if (result == null) {
            throw new IllegalStateException("Null result");
        }
        this.assertNoClassLoader(this.getContextName(result.getFactory()));
    }

    protected void assertNoClassLoader(String name) throws Exception {
        try {
            Object bean = this.getBean(name, null);
            if (bean != null) {
                JBossClClassPoolTest.fail((String)("Should not be here: " + bean));
            }
        }
        catch (Throwable t) {
            this.checkThrowable(IllegalStateException.class, t);
        }
    }

    protected void unregisterClassPool(ClassPool pool) throws Exception {
        if (pool != null) {
            ClassLoader loader = pool.getClassLoader();
            AspectManager.instance().unregisterClassLoader(loader);
            if (loader != null) {
                this.unregisterClassLoader(loader);
            }
        }
    }

    protected void unregisterClassLoader(ClassLoader classLoader) throws Exception {
        if (classLoader != null && !registeredURLClassLoaders.remove(classLoader)) {
            domainRegistry.cleanupLoader(classLoader);
            KernelDeployment deployment = this.loaderNameDeploymentRegistry.unregisterDeployment(classLoader);
            this.unregisterDeployment(deployment);
        }
    }

    protected void unregisterClassLoader(String name) throws Exception {
        KernelDeployment deployment = this.loaderNameDeploymentRegistry.unregisterDeployment(name);
        this.unregisterDeployment(deployment);
    }

    private void unregisterDeployment(KernelDeployment deployment) {
        if (deployment != null) {
            this.undeploy(deployment);
        }
    }

    protected void unregisterDomain(String name) {
        if (name != null) {
            ClassLoaderDomain registeredDomain = JBossClClassPoolTest.getSystem().getDomain(name);
            this.unregisterDomain(registeredDomain);
        }
    }

    protected KernelDeployment install(TestVFSClassLoaderFactory metaData) throws Exception {
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setName(metaData.getName() + ":" + metaData.getVersion());
        deployment.setBeanFactories(Collections.singletonList(metaData));
        this.deploy((KernelDeployment)deployment);
        return deployment;
    }

    protected String getContextName(TestVFSClassLoaderFactory factory) {
        String contextName = factory.getContextName();
        if (contextName == null) {
            contextName = factory.getName() + ":" + factory.getVersion();
        }
        return contextName;
    }

    protected ClassLoader assertClassLoader(TestVFSClassLoaderFactory factory) throws Exception {
        return this.assertClassLoader(factory, null);
    }

    protected ClassLoader assertClassLoader(TestVFSClassLoaderFactory factory, ClassLoader parent) throws Exception {
        try {
            Object obj = this.getBean(this.getContextName(factory));
            ClassLoader loader = (ClassLoader)this.assertInstanceOf(obj, ClassLoader.class);
            Module module = this.assertModule(this.getContextName(factory));
            this.registerModule(loader, module, parent);
            this.loaderNameDeploymentRegistry.registerLoaderName(factory.getName(), loader);
            return loader;
        }
        catch (IllegalStateException e) {
            throw new NoSuchClassLoaderException(e);
        }
    }

    protected ClassPool assertClassPool(TestVFSClassLoaderFactory factory) throws Exception {
        ClassLoader loader = this.assertClassLoader(factory);
        return AspectManager.instance().registerClassLoader(loader);
    }

    protected Class<?> assertLoadClass(String name, ClassLoader initiating) throws Exception {
        return this.assertLoadClass(name, initiating, initiating);
    }

    protected Class<?> assertLoadClass(String name, ClassLoader initiating, ClassLoader expected) throws Exception {
        Class<?> clazz = initiating.loadClass(name);
        if (expected != null) {
            JBossClClassPoolTest.assertSame((Object)expected, (Object)clazz.getClassLoader());
        }
        return clazz;
    }

    protected CtClass assertLoadCtClass(String name, ClassPool initiating) throws Exception {
        return this.assertLoadCtClass(name, initiating, initiating);
    }

    protected CtClass assertLoadCtClass(String name, ClassPool initiating, ClassPool expected) throws Exception {
        CtClass clazz = initiating.get(name);
        if (expected != null) {
            JBossClClassPoolTest.assertSame((Object)expected, (Object)clazz.getClassPool());
        }
        clazz = initiating.get(name);
        if (expected != null) {
            JBossClClassPoolTest.assertSame((Object)expected, (Object)clazz.getClassPool());
        }
        this.assertLoadCtClassArray(name, clazz, initiating, expected);
        return clazz;
    }

    private void assertLoadCtClassArray(String name, CtClass clazz, ClassPool initiating, ClassPool expected) throws Exception {
        this.assertLoadCtClassArray(name, clazz, 1, initiating, expected);
        this.assertLoadCtClassArray(name, clazz, 2, initiating, expected);
    }

    private void assertLoadCtClassArray(String name, CtClass clazz, int dimensions, ClassPool initiating, ClassPool expected) throws Exception {
        String arrayName = name;
        for (int i = 0; i < dimensions; ++i) {
            arrayName = this.array(arrayName);
        }
        CtClass array = initiating.get(arrayName);
        if (expected != null) {
            JBossClClassPoolTest.assertSame((Object)expected, (Object)array.getClassPool());
        }
        JBossClClassPoolTest.assertSame((Object)clazz.getClassPool(), (Object)array.getClassPool());
        CtClass type = array;
        for (int i = 0; i < dimensions; ++i) {
            type = type.getComponentType();
        }
        JBossClClassPoolTest.assertSame((Object)type, (Object)clazz);
    }

    protected Module assertModule(String contextName) {
        return (Module)this.assertBean(contextName + "$MODULE", Module.class);
    }

    public void testClassesNotOnClasspath() {
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), CLASS_A);
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), CLASS_B);
        this.assertCannotLoadClass(((Object)((Object)this)).getClass().getClassLoader(), CLASS_C);
    }

    static {
        String[] classPatterns = new String[]{"org\\.jboss\\.aop\\..+", "org\\.jboss\\.classloading\\..+", "org\\.jboss\\.classloader\\..+", "org\\.jboss\\.virtual\\..+", "org\\.jboss\\.test\\.aop\\.classpool\\.jbosscl\\..+\\..+", "org\\.jboss\\.metadata\\..+"};
        String[] resourcePatterns = new String[]{"org/jboss/aop/.+", "org/jboss/classloading/.+", "org/jboss/classloader/.+", "org/jboss/virtual/.+", "org/jboss/test/aop/classpool/jbosscl/.+\\..+", "org/jboss/metadata/.+"};
        aopFilter = new PatternClassFilter(classPatterns, resourcePatterns, null);
        domainRegistry = new VFSClassLoaderDomainRegistry();
        AspectManager.setClassPoolFactory((ScopedClassPoolFactory)new JBossClDelegatingClassPoolFactory((DomainRegistry)domainRegistry, new RegisterModuleCallback()));
    }

    private static class LoaderNameDeploymentRegistry {
        private Map<String, KernelDeployment> deploymentsByName = new HashMap<String, KernelDeployment>();
        private Map<ClassLoader, String> namesByLoader = new HashMap<ClassLoader, String>();

        private LoaderNameDeploymentRegistry() {
        }

        private void registerDeployment(String name, KernelDeployment deployment) {
            if (!this.deploymentsByName.containsKey(name)) {
                this.deploymentsByName.put(name, deployment);
            }
        }

        private void registerLoaderName(String name, ClassLoader loader) {
            if (loader != null) {
                this.namesByLoader.put(loader, name);
            }
        }

        private KernelDeployment unregisterDeployment(String name) {
            return this.deploymentsByName.remove(name);
        }

        private KernelDeployment unregisterDeployment(ClassLoader loader) {
            String name = this.namesByLoader.remove(loader);
            return this.unregisterDeployment(name);
        }
    }

    static class NoSuchClassLoaderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoSuchClassLoaderException(Exception e) {
            super(e);
        }
    }
}

