/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.integration.metadatadomain.test;

import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.stack.MetaDataStack;

public class Helper {
    static Domain createScopedDomain(String name) {
        AspectManager manager = AspectManager.getTopLevelAspectManager();
        Domain scopedDomain = new Domain(manager, name, false);
        return scopedDomain;
    }

    static void createAndPushMetaData(Domain scopedDomain) {
        ScopeKey scopeKey = Helper.createScope("Test", scopedDomain.getDomainName());
        BasicMetaDataRepository repository = new BasicMetaDataRepository();
        MemoryMetaDataLoader retrieval = new MemoryMetaDataLoader(scopeKey);
        repository.addMetaDataRetrieval((MetaDataRetrieval)retrieval);
        if (scopedDomain != null) {
            ((MutableMetaData)retrieval).addMetaData((Object)scopedDomain, Domain.class);
        }
        MetaData metadata = repository.getMetaData(scopeKey);
        MetaDataStack.push((MetaData)metadata);
    }

    static ScopeKey createScope(String app, String dep) {
        ScopeKey result = ScopeKey.DEFAULT_SCOPE.clone();
        result.addScope(CommonLevels.APPLICATION, (Object)app);
        result.addScope(CommonLevels.DEPLOYMENT, (Object)dep);
        return result;
    }
}

