/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.deployers;

import javax.management.MBeanServer;
import javax.management.ObjectName;

import org.jboss.logging.Logger;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class AspectManagerJMXRegistrar
{
   final static Logger log = Logger.getLogger(AspectManagerJMXRegistrar.class.getName());
   final static String ASPECTMANAGER_OBJECTNAME = "jboss.aop:service=AspectManager";
   
   MBeanServer server;
   AbstractAspectManager aspectManager;
   
   public void setMbeanServer(MBeanServer server)
   {
      this.server = server;
   }

   public void setAspectManager(AbstractAspectManager aspectManager)
   {
      this.aspectManager = aspectManager;
   }
   
   public void start() throws Exception
   {
      try
      {
         log.debug("Registering AspectManagerService in JMX under: " + ASPECTMANAGER_OBJECTNAME);
         server.registerMBean(aspectManager.delegate, new ObjectName(ASPECTMANAGER_OBJECTNAME));
      }
      catch (Exception e)
      {
         // AutoGenerated
         throw new RuntimeException("Error starting AspectManagerJMXWrapper", e);
      }
   }


   public void stop()
   {
      try
      {
         log.debug("Unregistering AspectManagerService in JMX under: " + ASPECTMANAGER_OBJECTNAME);
         server.unregisterMBean(new ObjectName(ASPECTMANAGER_OBJECTNAME));
      }
      catch (Exception e)
      {
         // AutoGenerated
         throw new RuntimeException("Error stopping AspectManagerJMXWrapper", e);
      }
   }
}
