/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.deployers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.annotation.PortableAnnotationElement;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.aop.deployment.AspectManagerService;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public abstract class AbstractAspectManager
{
   final static String BASE_ASPECTS_XML = "base-aspects.xml";
   AspectManagerService delegate = null;
   String bootstrapXml;
   
   public AbstractAspectManager(String bootstrapXml)
   {
      this.bootstrapXml = bootstrapXml;
   }

   public AspectManager getAspectManager()
   {
      return AspectManager.getTopLevelAspectManager();
   }
   
   /**
    * @param listener
    * @param filter
    * @param handback
    * @see org.jboss.mx.util.JBossNotificationBroadcasterSupport#addNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, java.lang.Object)
    */
   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
   {
      delegate.addNotificationListener(listener, filter, handback);
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#aspectDefinitions()
    */
   public String aspectDefinitions()
   {
      return delegate.aspectDefinitions();
   }

   /**
    * @param classname
    * @see org.jboss.aop.deployment.AspectManagerService#attachClass(java.lang.String)
    */
   public void attachClass(String classname)
   {
      delegate.attachClass(classname);
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#bindings()
    */
   public String bindings()
   {
      return delegate.bindings();
   }

   /**
    * @throws Exception
    * @see org.jboss.system.ServiceMBeanSupport#create()
    */
   public void create() throws Exception
   {
      try
      {
         if (bootstrapXml != null && bootstrapXml.trim().length() > 0)
         {
            InputStream in = new BufferedInputStream(new ByteArrayInputStream(bootstrapXml.getBytes()));
            try
            {
               Document doc = AspectXmlLoader.loadDocument(new BufferedInputStream(in));
               AspectXmlLoader loader = new AspectXmlLoader();
               loader.setManager(getAspectManager());
               loader.deployXML(doc, null);
            }
            finally
            {
               if (in != null)
               {
                  in.close();
               }
            }
         }
      }
      catch (Exception e)
      {
         // AutoGenerated
         throw new RuntimeException("Problem starting AspectManager", e);
      }
      delegate.create();
   }

   /**
    * @throws Exception
    * @see org.jboss.system.ServiceMBeanSupport#start()
    */
   public void start() throws Exception
   {
      delegate.start();
   }


   public void stop()
   {
      delegate.stop();
   }
   /**
    * 
    * @see org.jboss.system.ServiceMBeanSupport#destroy()
    */
   public void destroy()
   {
      try
      {
         if (bootstrapXml != null)
         {
            InputStream in = new BufferedInputStream(new ByteArrayInputStream(bootstrapXml.getBytes()));
            try
            {
               Document doc = AspectXmlLoader.loadDocument(new BufferedInputStream(in));
               AspectXmlLoader loader = new AspectXmlLoader();
               loader.setManager(getAspectManager());
               PortableAnnotationElement.setClosingDownManager(true);
               loader.undeployXML(doc, null);
            }
            finally
            {
               if (in != null)
               {
                  in.close();
               }
            }
         }
      }
      catch (Exception e)
      {
         throw new RuntimeException("Problem destroying AspectManager", e);
      }
      delegate.destroy();
   }

   /**
    * @param obj
    * @return
    * @see java.lang.Object#equals(java.lang.Object)
    */
   public boolean equals(Object obj)
   {
      return delegate.equals(obj);
   }

   /**
    * @return
    * @throws JMException
    * @see org.jboss.system.ServiceMBeanSupport#getDeploymentInfo()
    */
   public DeploymentInfo getDeploymentInfo() throws JMException
   {
      return delegate.getDeploymentInfo();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getEnableLoadtimeWeaving()
    */
   public boolean getEnableLoadtimeWeaving()
   {
      return delegate.getEnableLoadtimeWeaving();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getEnableTransformer()
    */
   public boolean getEnableTransformer()
   {
      return delegate.getEnableTransformer();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getExclude()
    */
   public String getExclude()
   {
      return delegate.getExclude();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getIgnore()
    */
   public String getIgnore()
   {
      return delegate.getIgnore();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getInclude()
    */
   public String getInclude()
   {
      return delegate.getInclude();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getInstrumentor()
    */
   public String getInstrumentor()
   {
      return delegate.getInstrumentor();
   }

   /**
    * @return
    * @see org.jboss.system.ServiceMBeanSupport#getLog()
    */
   public Logger getLog()
   {
      return delegate.getLog();
   }

   /**
    * @return
    * @see org.jboss.system.ServiceMBeanSupport#getName()
    */
   public String getName()
   {
      return delegate.getName();
   }

   /**
    * @return
    * @see org.jboss.mx.util.JBossNotificationBroadcasterSupport#getNotificationInfo()
    */
   public MBeanNotificationInfo[] getNotificationInfo()
   {
      return delegate.getNotificationInfo();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getOptimized()
    */
   public boolean getOptimized()
   {
      return delegate.getOptimized();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getPrune()
    */
   public boolean getPrune()
   {
      return delegate.getPrune();
   }

   /**
    * @return
    * @see org.jboss.system.ServiceMBeanSupport#getServer()
    */
   public MBeanServer getServer()
   {
      return delegate.getServer();
   }

   /**
    * @return
    * @see org.jboss.system.ServiceMBeanSupport#getServiceName()
    */
   public ObjectName getServiceName()
   {
      return delegate.getServiceName();
   }

   /**
    * @return
    * @see org.jboss.system.ServiceMBeanSupport#getState()
    */
   public int getState()
   {
      return delegate.getState();
   }

   /**
    * @return
    * @see org.jboss.system.ServiceMBeanSupport#getStateString()
    */
   public String getStateString()
   {
      return delegate.getStateString();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getSuppressReferenceErrors()
    */
   public boolean getSuppressReferenceErrors()
   {
      return delegate.getSuppressReferenceErrors();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getSuppressTransformationErrors()
    */
   public boolean getSuppressTransformationErrors()
   {
      return delegate.getSuppressTransformationErrors();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getTmpClassesDir()
    */
   public File getTmpClassesDir()
   {
      return delegate.getTmpClassesDir();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getVerbose()
    */
   public boolean getVerbose()
   {
      return delegate.getVerbose();
   }

   /**
    * @param listener
    * @param notification
    * @param handback
    * @see org.jboss.mx.util.JBossNotificationBroadcasterSupport#handleNotification(javax.management.NotificationListener, javax.management.Notification, java.lang.Object)
    */
   public void handleNotification(NotificationListener listener, Notification notification, Object handback)
   {
      delegate.handleNotification(listener, notification, handback);
   }

   /**
    * @return
    * @see java.lang.Object#hashCode()
    */
   public int hashCode()
   {
      return delegate.hashCode();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#interceptorFactories()
    */
   public String interceptorFactories()
   {
      return delegate.interceptorFactories();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#introductions()
    */
   public String introductions()
   {
      return delegate.introductions();
   }

   /**
    * @param method
    * @throws Exception
    * @see org.jboss.system.ServiceMBeanSupport#jbossInternalLifecycle(java.lang.String)
    */
   public void jbossInternalLifecycle(String method) throws Exception
   {
      delegate.jbossInternalLifecycle(method);
   }

   /**
    * @return
    * @see org.jboss.mx.util.JBossNotificationBroadcasterSupport#nextNotificationSequenceNumber()
    */
   public long nextNotificationSequenceNumber()
   {
      return delegate.nextNotificationSequenceNumber();
   }

   /**
    * 
    * @see org.jboss.system.ServiceMBeanSupport#postDeregister()
    */
   public void postDeregister()
   {
      delegate.postDeregister();
   }

   /**
    * @param registrationDone
    * @see org.jboss.system.ServiceMBeanSupport#postRegister(java.lang.Boolean)
    */
   public void postRegister(Boolean registrationDone)
   {
      delegate.postRegister(registrationDone);
   }

   /**
    * @throws Exception
    * @see org.jboss.system.ServiceMBeanSupport#preDeregister()
    */
   public void preDeregister() throws Exception
   {
      delegate.preDeregister();
   }

   /**
    * @param server
    * @param name
    * @return
    * @throws Exception
    * @see org.jboss.system.ServiceMBeanSupport#preRegister(javax.management.MBeanServer, javax.management.ObjectName)
    */
   public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception
   {
      return delegate.preRegister(server, name);
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#registeredClassLoaders()
    */
   public String registeredClassLoaders()
   {
      return delegate.registeredClassLoaders();
   }

   /**
    * @param listener
    * @param filter
    * @param handback
    * @throws ListenerNotFoundException
    * @see org.jboss.mx.util.JBossNotificationBroadcasterSupport#removeNotificationListener(javax.management.NotificationListener, javax.management.NotificationFilter, java.lang.Object)
    */
   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException
   {
      delegate.removeNotificationListener(listener, filter, handback);
   }

   /**
    * @param listener
    * @throws ListenerNotFoundException
    * @see org.jboss.mx.util.JBossNotificationBroadcasterSupport#removeNotificationListener(javax.management.NotificationListener)
    */
   public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException
   {
      delegate.removeNotificationListener(listener);
   }

   /**
    * @param notification
    * @see org.jboss.mx.util.JBossNotificationBroadcasterSupport#sendNotification(javax.management.Notification)
    */
   public void sendNotification(Notification notification)
   {
      delegate.sendNotification(notification);
   }

   /**
    * @param enableTransformer
    * @see org.jboss.aop.deployment.AspectManagerService#setEnableLoadtimeWeaving(boolean)
    */
   public void setEnableLoadtimeWeaving(boolean enableTransformer)
   {
      delegate.setEnableLoadtimeWeaving(enableTransformer);
   }

   /**
    * @param enableTransformer
    * @see org.jboss.aop.deployment.AspectManagerService#setEnableTransformer(boolean)
    */
   public void setEnableTransformer(boolean enableTransformer)
   {
      delegate.setEnableTransformer(enableTransformer);
   }

   /**
    * @param exclude
    * @see org.jboss.aop.deployment.AspectManagerService#setExclude(java.lang.String)
    */
   public void setExclude(String exclude)
   {
      delegate.setExclude(exclude);
   }

   /**
    * @param ignore
    * @see org.jboss.aop.deployment.AspectManagerService#setIgnore(java.lang.String)
    */
   public void setIgnore(String ignore)
   {
      delegate.setIgnore(ignore);
   }

   /**
    * @param include
    * @see org.jboss.aop.deployment.AspectManagerService#setInclude(java.lang.String)
    */
   public void setInclude(String include)
   {
      delegate.setInclude(include);
   }

   /**
    * @param instrumentor
    * @see org.jboss.aop.deployment.AspectManagerService#setInstrumentor(java.lang.String)
    */
   public void setInstrumentor(String instrumentor)
   {
      delegate.setInstrumentor(instrumentor);
   }

   /**
    * @param verbose
    * @see org.jboss.aop.deployment.AspectManagerService#setOptimized(boolean)
    */
   public void setOptimized(boolean verbose)
   {
      delegate.setOptimized(verbose);
   }

   /**
    * @param prune
    * @see org.jboss.aop.deployment.AspectManagerService#setPrune(boolean)
    */
   public void setPrune(boolean prune)
   {
      delegate.setPrune(prune);
   }

   /**
    * @param suppressReferenceErrors
    * @see org.jboss.aop.deployment.AspectManagerService#setSuppressReferenceErrors(boolean)
    */
   public void setSuppressReferenceErrors(boolean suppressReferenceErrors)
   {
      delegate.setSuppressReferenceErrors(suppressReferenceErrors);
   }

   /**
    * @param suppressTransformationErrors
    * @see org.jboss.aop.deployment.AspectManagerService#setSuppressTransformationErrors(boolean)
    */
   public void setSuppressTransformationErrors(boolean suppressTransformationErrors)
   {
      delegate.setSuppressTransformationErrors(suppressTransformationErrors);
   }

   /**
    * @param tmpClassesDir
    * @see org.jboss.aop.deployment.AspectManagerService#setTmpClassesDir(java.io.File)
    */
   public void setTmpClassesDir(File tmpClassesDir)
   {
      delegate.setTmpClassesDir(tmpClassesDir);
   }

   /**
    * @param verbose
    * @see org.jboss.aop.deployment.AspectManagerService#setVerbose(boolean)
    */
   public void setVerbose(boolean verbose)
   {
      delegate.setVerbose(verbose);
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#stacks()
    */
   public String stacks()
   {
      return delegate.stacks();
   }

   public void deployBaseAspects()
   {
      delegate.baseAop(BASE_ASPECTS_XML);
   }

   /**
    * @return
    * @see java.lang.Object#toString()
    */
   public String toString()
   {
      return delegate.toString();
   }

   /**
    * @return
    * @see org.jboss.aop.deployment.AspectManagerService#getJBossIntegration()
    */
   public JBossIntegration getJbossIntegration()
   {
      return delegate.getJBossIntegration();
   }

   /**
    * @param integration
    * @see org.jboss.aop.deployment.AspectManagerService#setJBossIntegration(org.jboss.asintegration.JBossIntegration)
    */
   public void setJbossIntegration(JBossIntegration integration)
   {
      delegate.setJBossIntegration(integration);
   }
}
