/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedConstructorInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.ConstructorCallByConstructor;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.util.ReflectToJavassist;

public class ConByConJoinPointGenerator
extends JoinPointGenerator {
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_CByC_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_CByC_";
    private static final Class JOINPOINT_TYPE = ConstructorCallByConstructor.class;
    private static final Class INVOCATION_TYPE = ConstructorCalledByConstructorInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;
    private WeakReference<Class<?>> returnType;

    public ConByConJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info, JoinPointGenerator.JoinPointParameters.CALLER_ARGS, ((ConByConInfo)info).getConstructor().getParameterTypes().length, false);
        this.returnType = new WeakReference(((ConByConInfo)info).getCalledClass());
    }

    protected void initialiseJoinPointNames(JoinPointInfo info) {
        ConByConInfo cinfo = (ConByConInfo)info;
        this.joinpointClassName = ConByConJoinPointGenerator.getGeneratedJoinPointClassName(this.callingIndex(cinfo), this.calledClass(cinfo), this.calledConHash(cinfo));
        this.joinpointFieldName = ConByConJoinPointGenerator.getGeneratedJoinPointFieldName(this.callingIndex(cinfo), this.calledClass(cinfo), this.calledConHash(cinfo));
    }

    private int callingIndex(ConByConInfo info) {
        return info.getCallingIndex();
    }

    private String calledClass(ConByConInfo info) {
        return info.getCalledClass().getName();
    }

    private long calledConHash(ConByConInfo info) {
        return info.getCalledConHash();
    }

    protected boolean isVoid() {
        return false;
    }

    protected Class getReturnClassType() {
        return (Class)this.returnType.get();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup) {
        ConstructorCallByConstructor call = (ConstructorCallByConstructor)joinPoint;
        Constructor<?> ctor = call.getConstructor();
        AdviceMethodProperties properties = new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, ctor.getDeclaringClass(), ctor.getGenericParameterTypes(), ctor.getParameterTypes(), ctor.getGenericExceptionTypes(), call.getCalledClass(), false, call.getCallingClass(), true);
        return properties;
    }

    protected boolean isCaller() {
        return true;
    }

    protected boolean hasCallingObject() {
        return true;
    }

    protected boolean hasTargetObject() {
        return false;
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPointInfo newInfo) throws CannotCompileException, NotFoundException {
        super.overrideDispatchMethods(superClass, clazz, (ConByConInfo)newInfo);
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, int callingIndex, CtClass callingClass, CtConstructor targetCtor, String classname, long calledHash, String ciname) throws NotFoundException, CannotCompileException {
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingIndex, classname, targetCtor, calledHash, ciname);
        return generator.generate();
    }

    protected static String getGeneratedJoinPointClassName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_CLASS_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    protected static String getGeneratedJoinPointFieldName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_FIELD_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass callingClass;
        int callingIndex;
        CtField callingField;
        String classname;
        CtClass targetClass;
        CtConstructor targetCtor;
        long calledHash;
        String ciname;
        CtClass jp;
        CtClass[] params;
        CtClass constructorInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, int callingIndex, String classname, CtConstructor targetCtor, long calledHash, String ciname) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.callingClass = callingClass;
            this.callingIndex = callingIndex;
            this.classname = classname;
            this.targetClass = instrumentor.forName(classname);
            this.targetCtor = targetCtor;
            this.calledHash = calledHash;
            this.ciname = ciname;
            this.params = targetCtor.getParameterTypes();
            this.constructorInfoClass = instrumentor.forName(CallerTransformer.CON_BY_CON_INFO_CLASS_NAME);
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
            this.addTypedCallingField();
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructors();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = ConByConJoinPointGenerator.getGeneratedJoinPointClassName(this.callingIndex, this.targetClass.getName(), this.calledHash);
            this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true, 9, INVOCATION_CT_TYPE);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addTypedCallingField() throws CannotCompileException {
            this.callingField = new CtField(this.callingClass, "typedCallingObject", this.jp);
            this.jp.addField(this.callingField);
            this.callingField.setModifiers(4);
        }

        private void addPublicConstructor() throws CannotCompileException {
            CtConstructor publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.constructorInfoClass}, (CtClass[])new CtClass[0], (String)"{super($1, null, $1.getInterceptors()); this.info = $1;}", (CtClass)this.jp);
            this.jp.addConstructor(publicConstructor);
        }

        protected void addProtectedConstructors() throws CannotCompileException {
            int offset;
            CtClass[] ctorParams1 = new CtClass[this.params.length + 2];
            CtClass[] ctorParams2 = new CtClass[2];
            ctorParams1[0] = ctorParams2[0] = this.jp;
            ctorParams1[1] = ctorParams2[1] = this.callingClass;
            System.arraycopy(this.params, 0, ctorParams1, 2, this.params.length);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            body.append("   super.").append("callingObject").append("=$2;");
            body.append("   this.").append(this.callingField.getName()).append("=$2;");
            StringBuffer setArguments = new StringBuffer();
            for (int i = offset = 2; i < ctorParams1.length; ++i) {
                setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            setArguments.append("}");
            CtConstructor protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams1, (CtClass[])new CtClass[0], (String)(body.toString() + setArguments.toString()), (CtClass)this.jp);
            protectedConstructor.setModifiers(4);
            this.jp.addConstructor(protectedConstructor);
            if (this.params.length > 0) {
                protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams2, (CtClass[])new CtClass[0], (String)(body.toString() + "}"), (CtClass)this.jp);
                protectedConstructor.setModifiers(4);
                this.jp.addConstructor(protectedConstructor);
            }
        }

        private CtClass[] getInvokeJoinPointParameters() {
            CtClass[] invokeParams = new CtClass[this.params.length + 1];
            invokeParams[0] = this.callingClass;
            System.arraycopy(this.params, 0, invokeParams, 1, this.params.length);
            return invokeParams;
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make((CtClass)this.targetClass, (String)"invokeJoinpoint", (CtClass[])this.getInvokeJoinPointParameters(), (CtClass[])JoinPointGenerator.THROWS_THROWABLE, null, (CtClass)this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.constructorInfoClass, "info", this.jp);
            infoField.setModifiers(4);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            OptimizedConstructorInvocations.addDispatch(this.jp, "dispatch", this.targetCtor);
            this.addInvokeJoinpointDispatchMethod();
            this.addInvokeTargetMethod();
        }

        private void addInvokeJoinpointDispatchMethod() throws CannotCompileException, NotFoundException {
            boolean offset = true;
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + 1 + 1));
            }
            String body = "{   " + this.targetClass.getName() + " obj = new " + this.targetClass.getName() + "(" + parameters.toString() + ");" + "   setTargetObject(obj);" + "   return obj;" + "}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)this.targetClass, (String)"dispatch", (CtClass[])this.getInvokeJoinPointParameters(), (CtClass[])this.targetCtor.getExceptionTypes(), (String)body, (CtClass)this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for dispatch method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.params), e);
            }
        }

        private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
            CtMethod template = INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
            String body = "{return dispatch();}";
            CtMethod invokeTarget = CtNewMethod.make((CtClass)template.getReturnType(), (String)template.getName(), (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (String)body, (CtClass)this.jp);
            this.jp.addMethod(invokeTarget);
        }
    }
}

