/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotatedAdviceParams;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.advice.InvalidAdviceException;
import org.jboss.aop.advice.NoMatchingAdviceException;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotatedAdviceParams.JoinPointAspect;
import org.jboss.test.aop.annotatedAdviceParams.JoinPointInvalidPOJO;
import org.jboss.test.aop.annotatedAdviceParams.JoinPointPOJO;
import org.jboss.test.aop.annotatedAdviceParams.POJOException;

public class JoinPointInvalidTestCase
extends AOPTestWithSetup {
    private JoinPointInvalidPOJO pojo;

    public static void main(String[] args) {
        TestRunner.run((Test)JoinPointInvalidTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("JoinPointTestCase");
        suite.addTestSuite(JoinPointInvalidTestCase.class);
        return suite;
    }

    public JoinPointInvalidTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        JoinPointAspect.clear();
        this.pojo = new JoinPointInvalidPOJO();
    }

    public void tearDown() throws Exception {
        JoinPointBean joinPoint = JoinPointAspect.beforeJoinPoint;
        if (joinPoint == null && (joinPoint = JoinPointAspect.afterJoinPoint) == null && (joinPoint = JoinPointAspect.throwingJoinPoint) == null) {
            joinPoint = JoinPointAspect.finallyJoinPoint;
        }
        if (joinPoint != null) {
            JoinPointInvalidTestCase.assertSame((Object)((Advised)this.pojo)._getAdvisor(), (Object)joinPoint.getAdvisor());
            JoinPointInvalidTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getClazz());
        }
        super.tearDown();
    }

    public void testFieldWrite1() {
        boolean thrown = false;
        try {
            this.pojo.numberBefore9 = 0;
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testFieldWrite2() {
        boolean thrown = false;
        try {
            this.pojo.textAfter2 = "test2";
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        thrown = false;
        try {
            this.pojo.textAfter8 = "test2";
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
    }

    public void testFieldRead() {
        boolean thrown = false;
        try {
            String text = this.pojo.textBefore5;
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testMethodExecution1() {
        boolean thrown = false;
        try {
            this.pojo.method1Finally9();
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testMethodExecutionException1() throws POJOException {
        boolean thrown = false;
        try {
            this.pojo.method3Throwing2();
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testMethodExecutionException2() throws POJOException {
        boolean thrown = false;
        try {
            this.pojo.method5Around();
        }
        catch (InvalidAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            this.pojo.method5Finally4();
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testConstructorCallByMethod() throws POJOException {
        boolean thrown = false;
        try {
            this.pojo.callConstructorThrowing9(false);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            this.pojo.callConstructorThrowing10(false);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testConstructorCallByMethodException() throws POJOException {
        boolean thrown = false;
        try {
            this.pojo.callConstructorThrowing9(true);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            this.pojo.callConstructorThrowing10(true);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testConstructorCallByStaticMethod() throws POJOException {
        boolean thrown = false;
        try {
            JoinPointInvalidPOJO.staticCallConstructorThrowing9(false);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            JoinPointInvalidPOJO.staticCallConstructorThrowing10(false);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testConstructorCallByStaticMethodException() throws POJOException {
        boolean thrown = false;
        try {
            JoinPointInvalidPOJO.staticCallConstructorThrowing9(true);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            JoinPointInvalidPOJO.staticCallConstructorThrowing10(true);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }

    public void testMethodCallByConstructor() throws Exception {
        boolean thrown = false;
        try {
            new JoinPointInvalidPOJO(false, false);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            new JoinPointInvalidPOJO(0L, false);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        JoinPointInvalidTestCase.assertTrue((boolean)thrown);
    }
}

