/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotateddeclare;

import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public class SystemOutDecorator
extends PrintStream {
    static PrintStream sysout = null;
    ArrayList warnings = new ArrayList();

    public SystemOutDecorator(OutputStream out) {
        super(out);
        sysout = System.out;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void println(String msg) {
        super.println(msg);
        if (msg.startsWith("WARNING:")) {
            System.out.println(">>>>>");
            super.println(msg);
            System.out.println("<<<<<");
            this.warnings.add(msg);
        }
    }

    public static SystemOutDecorator initialise() {
        final SystemOutDecorator sys = new SystemOutDecorator(System.out);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    System.setOut(sys);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        return sys;
    }

    public void kill() {
        System.setOut(sysout);
    }

    String getRidOfAllWhiteSpace(String msg) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (ch == '\n' || ch == '\t' || ch == ' ' || ch == '\r') continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

