/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.rebuildcallerchain;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.rebuildcallerchain.Caller1;
import org.jboss.test.aop.rebuildcallerchain.Caller2;
import org.jboss.test.aop.rebuildcallerchain.RebuildCallerChainInterceptor;

public class RebuildCallerChainTestCase
extends AOPTestWithSetup {
    public RebuildCallerChainTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("RebuildCallerChainTestCase");
        suite.addTestSuite(RebuildCallerChainTestCase.class);
        return suite;
    }

    public void testRebuildCallerChainConCalledCon() throws Exception {
        try {
            AdviceBinding bindingCall = new AdviceBinding("call(org.jboss.test.aop.rebuildcallerchain.Caller1->new(int))", null);
            bindingCall.addInterceptor(RebuildCallerChainInterceptor.class);
            AspectManager.instance().addBinding(bindingCall);
            RebuildCallerChainInterceptor.call = false;
            new Caller2(true);
            RebuildCallerChainTestCase.assertTrue((String)"caller2 was not rebuilded", (boolean)RebuildCallerChainInterceptor.call);
        }
        catch (Exception e) {
            RebuildCallerChainTestCase.assertFalse((String)"Failed to rebuild chain....", (boolean)true);
        }
    }

    public void testRebuildCallerChainMethodCalledMethod() throws Exception {
        try {
            new Caller1().execute();
            AdviceBinding bindingCall = new AdviceBinding("call(* org.jboss.test.aop.rebuildcallerchain.*->execute())", null);
            bindingCall.addInterceptor(RebuildCallerChainInterceptor.class);
            AspectManager.instance().addBinding(bindingCall);
            new Caller1().execute();
            RebuildCallerChainTestCase.assertTrue((String)"caller1 was not rebuilded", (boolean)RebuildCallerChainInterceptor.call);
            RebuildCallerChainInterceptor.call = false;
        }
        catch (Exception e) {
            RebuildCallerChainTestCase.assertFalse((String)"Failed to rebuild chain....", (boolean)true);
        }
    }
}

