/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.synthetic;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.aop.AOPTestDelegate;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.synthetic.Caller;
import org.jboss.test.aop.synthetic.Mixin;
import org.jboss.test.aop.synthetic.MixinInterface;
import org.jboss.test.aop.synthetic.POJO;
import org.jboss.test.aop.synthetic.Proxied;
import org.jboss.test.aop.synthetic.SimpleInterceptor;
import org.jboss.test.aop.synthetic.SomeInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)SyntheticTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SyntheticTestCase");
        suite.addTestSuite(SyntheticTestCase.class);
        return suite;
    }

    public SyntheticTestCase(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        AOPTestDelegate delegate = new AOPTestDelegate(clazz);
        return delegate;
    }

    public void testWovenSynthetic() {
        HashSet<String> fieldsAndMethods = new HashSet<String>();
        fieldsAndMethods.add("field");
        fieldsAndMethods.add("notAdvisedField");
        fieldsAndMethods.add("staticField");
        fieldsAndMethods.add("notAdvisedStaticField");
        fieldsAndMethods.add("someMethod");
        fieldsAndMethods.add("staticMethod");
        fieldsAndMethods.add("notAdvised");
        fieldsAndMethods.add("staticNotAdvised");
        fieldsAndMethods.add("introducedMethod");
        fieldsAndMethods.add("mixinMethod");
        SimpleInterceptor.intercepted = false;
        POJO temp = new POJO(1);
        SyntheticTestCase.assertFalse((boolean)SimpleInterceptor.intercepted);
        temp.notAdvised();
        SyntheticTestCase.assertFalse((boolean)SimpleInterceptor.intercepted);
        temp.notAdvisedField = 1;
        SyntheticTestCase.assertFalse((boolean)SimpleInterceptor.intercepted);
        SyntheticTestCase.assertEquals((int)1, (int)temp.notAdvisedField);
        SyntheticTestCase.assertFalse((boolean)SimpleInterceptor.intercepted);
        POJO.staticNotAdvised();
        SyntheticTestCase.assertFalse((boolean)SimpleInterceptor.intercepted);
        POJO.notAdvisedStaticField = 1;
        SyntheticTestCase.assertFalse((boolean)SimpleInterceptor.intercepted);
        SyntheticTestCase.assertEquals((int)1, (int)POJO.notAdvisedStaticField);
        SyntheticTestCase.assertFalse((boolean)SimpleInterceptor.intercepted);
        SimpleInterceptor.intercepted = false;
        POJO pojo = new POJO();
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        SimpleInterceptor.intercepted = false;
        pojo.someMethod();
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        SimpleInterceptor.intercepted = false;
        POJO.staticMethod();
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        SimpleInterceptor.intercepted = false;
        pojo.field = 1;
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        SimpleInterceptor.intercepted = false;
        SyntheticTestCase.assertEquals((int)1, (int)pojo.field);
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        SimpleInterceptor.intercepted = false;
        POJO.staticField = 2;
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        SimpleInterceptor.intercepted = false;
        SyntheticTestCase.assertEquals((int)2, (int)POJO.staticField);
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        MixinInterface mi = (MixinInterface)((Object)pojo);
        SomeInterface si = (SomeInterface)((Object)pojo);
        for (Constructor<?> constructor : pojo.getClass().getDeclaredConstructors()) {
            SyntheticTestCase.assertFalse((String)(constructor.toString() + " should not be synthetic"), (boolean)constructor.isSynthetic());
        }
        for (AccessibleObject accessibleObject : pojo.getClass().getDeclaredFields()) {
            if (fieldsAndMethods.contains(((Field)accessibleObject).getName())) {
                SyntheticTestCase.assertFalse((String)(((Field)accessibleObject).toString() + " should not be synthetic"), (boolean)((Field)accessibleObject).isSynthetic());
                continue;
            }
            SyntheticTestCase.assertTrue((String)(((Field)accessibleObject).toString() + " should be synthetic"), (boolean)((Field)accessibleObject).isSynthetic());
        }
        for (AccessibleObject accessibleObject : pojo.getClass().getDeclaredMethods()) {
            if (fieldsAndMethods.contains(((Method)accessibleObject).getName())) {
                SyntheticTestCase.assertFalse((String)(((Method)accessibleObject).toString() + " should not be synthetic"), (boolean)((Method)accessibleObject).isSynthetic());
                continue;
            }
            SyntheticTestCase.assertTrue((String)(((Method)accessibleObject).toString() + " should be synthetic"), (boolean)((Method)accessibleObject).isSynthetic());
        }
    }

    public void testCallerSynthetic() throws Exception {
        Caller caller = new Caller();
        caller.call();
        for (Constructor<?> constructor : caller.getClass().getDeclaredConstructors()) {
            SyntheticTestCase.assertFalse((String)(constructor.toString() + " should not be synthetic"), (boolean)constructor.isSynthetic());
        }
        for (AccessibleObject accessibleObject : caller.getClass().getDeclaredFields()) {
            SyntheticTestCase.assertTrue((String)(((Field)accessibleObject).toString() + " should be synthetic"), (boolean)((Field)accessibleObject).isSynthetic());
        }
        for (AccessibleObject accessibleObject : caller.getClass().getDeclaredMethods()) {
            if (((Method)accessibleObject).getName().equals("call")) {
                SyntheticTestCase.assertFalse((String)(((Method)accessibleObject).toString() + " should not be synthetic"), (boolean)((Method)accessibleObject).isSynthetic());
                continue;
            }
            SyntheticTestCase.assertTrue((String)(((Method)accessibleObject).toString() + " should be synthetic"), (boolean)((Method)accessibleObject).isSynthetic());
        }
    }

    public void testProxiedSynthetic() throws Exception {
        HashSet<String> fieldsAndMethods = new HashSet<String>();
        fieldsAndMethods.add("someMethod");
        fieldsAndMethods.add("introducedMethod");
        fieldsAndMethods.add("mixinMethod");
        Proxied tgt = new Proxied();
        URL url = this.getURLRelativeToProjectRoot("/src/resources/test/synthetic/manual-aop.xml");
        AspectXmlLoader.deployXML((URL)url);
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setTarget((Object)tgt);
        params.setInterfaces(new Class[]{SomeInterface.class});
        params.setMixins(new AOPProxyFactoryMixin[]{new AOPProxyFactoryMixin(Mixin.class, new Class[]{MixinInterface.class})});
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        Proxied proxied = (Proxied)factory.createAdvisedProxy(params);
        SimpleInterceptor.intercepted = false;
        proxied.someMethod();
        SyntheticTestCase.assertTrue((boolean)SimpleInterceptor.intercepted);
        MixinInterface mi = (MixinInterface)((Object)proxied);
        SomeInterface si = (SomeInterface)((Object)proxied);
        for (Field field : proxied.getClass().getDeclaredFields()) {
            SyntheticTestCase.assertTrue((String)(field.toString() + " should be synthetic"), (boolean)field.isSynthetic());
        }
        for (AccessibleObject accessibleObject : proxied.getClass().getDeclaredMethods()) {
            if (fieldsAndMethods.contains(((Method)accessibleObject).getName())) {
                SyntheticTestCase.assertFalse((String)(((Method)accessibleObject).toString() + " should not be synthetic"), (boolean)((Method)accessibleObject).isSynthetic());
                continue;
            }
            SyntheticTestCase.assertTrue((String)(((Method)accessibleObject).toString() + " should be synthetic"), (boolean)((Method)accessibleObject).isSynthetic());
        }
    }
}

