/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.beforeafterthrowingstack;

import org.jboss.aop.advice.annotation.Thrown;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.test.aop.beforeafterthrowingstack.ThrownByTestException;

public class Aspect {
    public static int aroundBefore;
    public static int aroundAfter;
    public static int aroundThrowing;
    public static int aroundFinally;
    public static int before;
    public static int after;
    public static int throwing;
    public static int finaly;
    public static Aspect aspect;

    public Object around(Invocation inv) throws Throwable {
        try {
            ++aroundBefore;
            this.setAspect(true);
            Object o = inv.invokeNext();
            ++aroundAfter;
            Object object = o;
            return object;
        }
        catch (ThrownByTestException e) {
            ++aroundThrowing;
            throw e;
        }
        finally {
            ++aroundFinally;
        }
    }

    public void before() {
        ++before;
        this.setAspect(false);
    }

    public void after() {
        this.setAspect(true);
        ++after;
    }

    public void throwing(@Thrown Throwable e) {
        this.setAspect(true);
        ++throwing;
    }

    public void finaly() {
        this.setAspect(true);
        ++finaly;
    }

    public static void reset() {
        aroundBefore = 0;
        aroundAfter = 0;
        aroundThrowing = 0;
        aroundFinally = 0;
        before = 0;
        after = 0;
        throwing = 0;
        finaly = 0;
        aspect = null;
    }

    private void setAspect(boolean shouldHaveBeenSet) {
        if (aspect == null && shouldHaveBeenSet) {
            throw new RuntimeException("Aspect should have existed");
        }
        if (aspect != null && aspect != this) {
            throw new RuntimeException("Wrong instance");
        }
        aspect = this;
    }
}

