/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.jboss.aop.AspectManager;
import org.jboss.logging.Logger;
import org.jboss.test.aop.stress.ScenarioPropertyReader;

public class FileScenarioPropertyReader
extends ScenarioPropertyReader {
    static final Logger log = Logger.getLogger(FileScenarioPropertyReader.class);
    String location;
    boolean strict;

    FileScenarioPropertyReader(String location, boolean strict) {
        this.location = location;
        this.strict = strict;
    }

    Properties loadProperties() {
        try {
            URL url = new URL(this.location);
            File file = new File(url.getFile());
            if (!file.exists()) {
                if (this.strict) {
                    throw new RuntimeException("Could not find config file " + file);
                }
                if (AspectManager.verbose) {
                    System.out.println("Could not find test/scenario config file " + file + ". Creating passthrough reader");
                }
                return null;
            }
            FileInputStream in = new FileInputStream(url.getFile());
            Properties properties = new Properties();
            properties.load(in);
            return properties;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

