/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jboss.aop.AspectAnnotationLoader;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.SecurityActions;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;

public class Deployment {
    private static final Logger logger = AOPLogger.getLogger(Deployment.class);
    public static boolean searchClasspath = true;

    public static void deploy() {
        try {
            Deployment.deployThroughClassAnnotations();
            Deployment.preconfigThroughClassPath();
            Deployment.preconfigThroughSystemProperty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void preconfigThroughClassPath() {
        String search = System.getProperty("jboss.aop.search.classpath", null);
        if (search != null) {
            searchClasspath = new Boolean(search);
        }
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("jboss.aop.search.classpath: '" + search + "' " + searchClasspath));
        }
        if (searchClasspath) {
            try {
                Enumeration<URL> en = SecurityActions.getContextClassLoader().getResources("META-INF/jboss-aop.xml");
                while (en.hasMoreElements()) {
                    URL url = en.nextElement();
                    if (AspectManager.verbose && logger.isDebugEnabled()) {
                        logger.debug((Object)("deploying  " + url));
                    }
                    AspectXmlLoader.deployXML(url);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void deployThroughClassAnnotations() {
        String path = System.getProperty("jboss.aop.class.path", null);
        if (path == null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)"jboss.aop.class.path is NULL");
            }
            return;
        }
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("jboss.aop.class.path: " + path));
        }
        StringTokenizer t = new StringTokenizer(path, File.pathSeparator);
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            File f = new File(token);
            if (!f.exists()) {
                System.err.println("[error] Unable to find jboss.aop.class.path: " + f.getName());
            }
            try {
                URL url = f.toURL();
                Iterator it = ArchiveBrowser.getBrowser((URL)url, (ArchiveBrowser.Filter)new ClassFileFilter());
                AspectAnnotationLoader loader = new AspectAnnotationLoader(AspectManager.instance());
                loader.deployInputStreamIterator(it);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException("[error] failed to load aop class path: " + f.toString(), ex);
            }
        }
    }

    public static void preconfigThroughSystemProperty() {
        String path = System.getProperty("jboss.aop.path", null);
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("jboss.aop.path: " + path));
        }
        if (path == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(path, File.pathSeparator);
        int j = 0;
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug((Object)("jboss.aop.path[" + j + "]: " + token));
            }
            File f = new File(token);
            try {
                if (f.isDirectory()) {
                    FilenameFilter filter = new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith("aop.xml");
                        }
                    };
                    File[] files = f.listFiles(filter);
                    for (int i = 0; i < files.length; ++i) {
                        Deployment.deployXmlFile(files[i]);
                    }
                    continue;
                }
                Deployment.deployXmlFile(f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException("[error] failed to load aop path: " + f.toString(), ex);
            }
        }
    }

    private static void deployXmlFile(File f) throws Exception {
        URL url = f.toURL();
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug((Object)("deploying " + url));
        }
        AspectXmlLoader.deployXML(url);
    }
}

