/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotationproperty;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.aop.AOPTestDelegate;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotationproperty.Complex;
import org.jboss.test.aop.annotationproperty.POJO;
import org.jboss.test.aop.annotationproperty.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPropertyReplacementTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)AnnotationPropertyReplacementTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AOPTester");
        suite.addTestSuite(AnnotationPropertyReplacementTestCase.class);
        return suite;
    }

    public AnnotationPropertyReplacementTestCase(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new AOPTestDelegate(clazz);
    }

    public void testPropertyReplacement() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("value1", "Test");
                System.setProperty("ch", "a");
                System.setProperty("string", "Test123");
                System.setProperty("flt", "9.9");
                System.setProperty("dbl", "123456789.99");
                System.setProperty("shrt", "1");
                System.setProperty("lng", "987654321");
                System.setProperty("integer", "123");
                System.setProperty("bool", "true");
                System.setProperty("annotation", "@org.jboss.test.aop.annotationproperty.SimpleValue(\"Yes\")");
                System.setProperty("array", "{\"Test\", \"123\"}");
                System.setProperty("clazz", "java.lang.Long.class");
                System.setProperty("enumVal", "org.jboss.test.aop.annotationproperty.MyEnum.TWO");
                return null;
            }
        });
        URL url = this.getURLRelativeToProjectRoot("/src/resources/test/annotationproperty/annotations-aop.xml");
        AspectXmlLoader.deployXML((URL)url);
        POJO pojo = new POJO();
        Advisor advisor = ((Advised)pojo)._getAdvisor();
        SimpleValue value = (SimpleValue)advisor.resolveTypedAnnotation(SimpleValue.class);
        AnnotationPropertyReplacementTestCase.assertNotNull((Object)value);
        AnnotationPropertyReplacementTestCase.assertEquals(SimpleValue.class, value.annotationType());
        AnnotationPropertyReplacementTestCase.assertEquals((String)"Test", (String)value.value());
        Complex complex2 = (Complex)advisor.resolveTypedAnnotation(Complex.class);
        AnnotationPropertyReplacementTestCase.assertNotNull((Object)complex2);
        AnnotationPropertyReplacementTestCase.assertEquals(Complex.class, complex2.annotationType());
        AnnotationPropertyReplacementTestCase.assertEquals((char)'a', (char)complex2.ch());
        AnnotationPropertyReplacementTestCase.assertEquals((String)"Test123", (String)complex2.string());
        AnnotationPropertyReplacementTestCase.assertEquals((float)9.0f, (float)9.0f, (float)complex2.flt());
        this.assertEquals(1.2345678999E8, complex2.dbl());
        AnnotationPropertyReplacementTestCase.assertEquals((int)1, (int)complex2.shrt());
        AnnotationPropertyReplacementTestCase.assertEquals((long)987654321L, (long)complex2.lng());
        AnnotationPropertyReplacementTestCase.assertEquals((int)123, (int)complex2.integer());
        AnnotationPropertyReplacementTestCase.assertEquals((boolean)true, (boolean)complex2.bool());
        AnnotationPropertyReplacementTestCase.assertEquals(Long.class, complex2.clazz());
        AnnotationPropertyReplacementTestCase.assertEquals((String)"Yes", (String)complex2.annotation().value());
        this.assertEquals(new String[]{"Test", "123"}, complex2.array());
    }
}

