/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.bridgemethodnotwoven;

import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.test.aop.AOPTestDelegate;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.bridgemethod.POJO;
import org.jboss.test.aop.bridgemethod.SubPOJO;
import org.jboss.test.aop.bridgemethod.SubPOJO2;
import org.jboss.test.aop.bridgemethod.SuperPOJO;

public class BridgeMethodTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)BridgeMethodTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("BridgeMethodTestCase");
        suite.addTestSuite(BridgeMethodTestCase.class);
        return suite;
    }

    public BridgeMethodTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMethod() {
        try {
            ClassProxyFactory.newInstance(POJO.class);
            BridgeMethodTestCase.assertTrue((String)"ClassProxy failed to instrument class", (boolean)true);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            BridgeMethodTestCase.assertTrue((String)"ClassProxy failed to instrument class", (boolean)false);
        }
    }

    public void testGenericMethod() {
        AOPTestDelegate delegate = (AOPTestDelegate)this.getDelegate();
        Properties properties = delegate.getSystemProperties();
        if (((String)properties.get("java.vm.version")).startsWith("1.5")) {
            try {
                SuperPOJO superPojo = (SuperPOJO)ClassProxyFactory.newInstance(SubPOJO.class);
                BridgeMethodTestCase.assertTrue((String)"ClassProxy failed to instrument generic class", (boolean)true);
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.getMessage());
                e.printStackTrace();
                BridgeMethodTestCase.assertTrue((String)"ClassProxy failed to instrument generic class", (boolean)false);
            }
        }
    }

    public void testMethodOverride() {
        try {
            ClassProxyFactory.newInstance(SubPOJO2.class);
            BridgeMethodTestCase.assertTrue((String)"ClassProxy failed to instrument overrided class", (boolean)true);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            BridgeMethodTestCase.assertTrue((String)"ClassProxy failed to instrument overrided class", (boolean)false);
        }
    }
}

