/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.callerscope;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.advice.Scope;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.callerscope.Caller;
import org.jboss.test.aop.callerscope.Flag;
import org.jboss.test.aop.callerscope.GCTarget;
import org.jboss.test.aop.callerscope.POJO;
import org.jboss.test.aop.callerscope.PerClassAspect;
import org.jboss.test.aop.callerscope.PerClassInterceptor;
import org.jboss.test.aop.callerscope.PerClassJoinpointAspect;
import org.jboss.test.aop.callerscope.PerClassJoinpointInterceptor;
import org.jboss.test.aop.callerscope.PerInstanceAspect;
import org.jboss.test.aop.callerscope.PerInstanceInterceptor;
import org.jboss.test.aop.callerscope.PerJoinpointAspect;
import org.jboss.test.aop.callerscope.PerJoinpointInterceptor;
import org.jboss.test.aop.callerscope.PerVmAspect;
import org.jboss.test.aop.callerscope.PerVmInterceptor;
import org.jboss.util.collection.WeakIdentityHashMap;

public class CallerScopeTestCase
extends AOPTestWithSetup {
    Caller caller = new Caller();

    public static void main(String[] args) {
        TestRunner.run((Test)CallerScopeTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DotInPointcutNameTester");
        suite.addTestSuite(CallerScopeTestCase.class);
        return suite;
    }

    public CallerScopeTestCase(String name) {
        super(name);
    }

    public void testWeakIdentityHashMap() {
        System.out.println("*** testWeakIdentityHashMap()");
        String a = new String("a");
        String b = new String("a");
        Flag cCollected = new Flag();
        GCTarget c = new GCTarget(cCollected);
        Flag dCollected = new Flag();
        GCTarget d = new GCTarget(dCollected);
        Long l1 = new Long(1L);
        Long l2 = new Long(2L);
        Long l3 = new Long(3L);
        Long l4 = new Long(4L);
        WeakIdentityHashMap map = new WeakIdentityHashMap();
        map.put((Object)a, (Object)l1);
        map.put((Object)b, (Object)l2);
        map.put((Object)c, (Object)l3);
        map.put((Object)d, (Object)l4);
        CallerScopeTestCase.assertEquals((int)4, (int)map.size());
        System.gc();
        CallerScopeTestCase.assertEquals((int)4, (int)map.size());
        CallerScopeTestCase.assertEquals((Object)l1, (Object)map.get((Object)a));
        CallerScopeTestCase.assertEquals((Object)l2, (Object)map.get((Object)b));
        CallerScopeTestCase.assertEquals((Object)l3, (Object)map.get((Object)c));
        CallerScopeTestCase.assertEquals((Object)l4, (Object)map.get((Object)d));
        c = null;
        d = null;
        System.gc();
        for (int j = 0; !(j >= 30 || cCollected.value && dCollected.value); ++j) {
            for (int i = 0; i < 10000; ++i) {
                String string = new String("any string to fill memory space...");
            }
            System.gc();
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected exception, e");
            }
        }
        CallerScopeTestCase.assertEquals((int)2, (int)map.size());
        CallerScopeTestCase.assertEquals((Object)l1, (Object)map.get((Object)a));
        CallerScopeTestCase.assertEquals((Object)l2, (Object)map.get((Object)b));
        System.out.println("*** testWeakIdentityHashMap() - successful");
    }

    public void testPerVm() throws Exception {
        System.out.println("*** testPerVm");
        CallerScopeTestCase.clearInterceptions();
        POJO pojo = new POJO();
        CallerScopeTestCase.checkInterceptions(Scope.PER_VM);
        CallerScopeTestCase.clearInterceptions();
        pojo.perVmMethod();
        CallerScopeTestCase.checkInterceptions(Scope.PER_VM);
        System.out.println();
    }

    public void testPerClass() throws Exception {
        System.out.println("*** testPerClass");
        CallerScopeTestCase.clearInterceptions();
        POJO pojo = new POJO(1);
        CallerScopeTestCase.checkInterceptions(Scope.PER_CLASS);
        CallerScopeTestCase.clearInterceptions();
        pojo.perClassMethod();
        CallerScopeTestCase.checkInterceptions(Scope.PER_CLASS);
        System.out.println();
    }

    public void testPerInstance() throws Exception {
        System.out.println("*** testPerInstance");
        CallerScopeTestCase.clearInterceptions();
        POJO pojo = new POJO();
        CallerScopeTestCase.checkInterceptions(Scope.PER_VM);
        CallerScopeTestCase.clearInterceptions();
        pojo.perInstanceMethod();
        CallerScopeTestCase.checkInterceptions(Scope.PER_INSTANCE);
        this.caller.testPerInstance(pojo);
        System.out.println();
    }

    public void testPerJoinpoint() throws Exception {
        System.out.println("*** testPerJoinpoint");
        CallerScopeTestCase.clearInterceptions();
        POJO pojo = new POJO();
        CallerScopeTestCase.checkInterceptions(Scope.PER_VM);
        CallerScopeTestCase.clearInterceptions();
        pojo.perJoinpointMethod();
        CallerScopeTestCase.checkInterceptions(Scope.PER_JOINPOINT);
        System.out.println();
    }

    public void testPerClassJoinpoint() throws Exception {
        System.out.println("*** testPerClassJoinpoint");
        CallerScopeTestCase.clearInterceptions();
        POJO pojo = new POJO(false);
        CallerScopeTestCase.checkInterceptions(Scope.PER_CLASS_JOINPOINT);
        CallerScopeTestCase.clearInterceptions();
        pojo.perClassJoinpointMethod();
        CallerScopeTestCase.checkInterceptions(Scope.PER_CLASS_JOINPOINT);
        System.out.println();
    }

    static void clearInterceptions() {
        PerVmAspect.intercepted = false;
        PerVmInterceptor.intercepted = false;
        PerClassAspect.intercepted = false;
        PerClassInterceptor.intercepted = false;
        PerInstanceAspect.intercepted = false;
        PerInstanceInterceptor.intercepted = false;
        PerJoinpointAspect.intercepted = false;
        PerJoinpointInterceptor.intercepted = false;
        PerClassJoinpointAspect.intercepted = false;
        PerClassJoinpointInterceptor.intercepted = false;
    }

    static void checkInterceptions(Scope scope) {
        if (scope == Scope.PER_VM) {
            CallerScopeTestCase.checkInterceptions(true, true, false, false, false, false, false, false, false, false);
        } else if (scope == Scope.PER_CLASS) {
            CallerScopeTestCase.checkInterceptions(false, false, true, true, false, false, false, false, false, false);
        } else if (scope == Scope.PER_INSTANCE) {
            CallerScopeTestCase.checkInterceptions(false, false, false, false, true, true, false, false, false, false);
        } else if (scope == Scope.PER_JOINPOINT) {
            CallerScopeTestCase.checkInterceptions(false, false, false, false, false, false, true, true, false, false);
        } else if (scope == Scope.PER_CLASS_JOINPOINT) {
            CallerScopeTestCase.checkInterceptions(false, false, false, false, false, false, false, false, true, true);
        }
    }

    static void checkInterceptions(boolean perVmAspect, boolean perVmInterceptor, boolean perClassAspect, boolean perClassInterceptor, boolean perInstanceAspect, boolean perInstanceInterceptor, boolean perJoinpointAspect, boolean perJoinpointInterceptor, boolean perClassJoinpointAspect, boolean perClassJoinpointInterceptor) {
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerVMAspect", (boolean)perVmAspect, (boolean)PerVmAspect.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerVmInterceptor", (boolean)perVmInterceptor, (boolean)PerVmInterceptor.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerClassAspect", (boolean)perClassAspect, (boolean)PerClassAspect.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerClassInterceptor", (boolean)perClassInterceptor, (boolean)PerClassInterceptor.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerInstanceAspect", (boolean)perInstanceAspect, (boolean)PerInstanceAspect.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerInstanceInterceptor", (boolean)perInstanceInterceptor, (boolean)PerInstanceInterceptor.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerJoinpointAspect", (boolean)perJoinpointAspect, (boolean)PerJoinpointAspect.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerJoinpointInterceptor", (boolean)perJoinpointInterceptor, (boolean)PerJoinpointInterceptor.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerClassJoinpointAspect", (boolean)perClassJoinpointAspect, (boolean)PerClassJoinpointAspect.intercepted);
        CallerScopeTestCase.assertEquals((String)"Wrong intercepted value for PerClassJoinpointInterceptor", (boolean)perClassJoinpointInterceptor, (boolean)PerClassJoinpointInterceptor.intercepted);
    }
}

