/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.dynamicgenadvisor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructionInvocation;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.test.aop.dynamicgenadvisor.Interceptions;

public class MyInterceptor
implements Interceptor {
    public String getName() {
        return "MyInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        FieldReadInvocation fi;
        ConstructorInvocation ci;
        System.out.println("MyInterceptor.invoke()");
        if (invocation instanceof ConstructorInvocation) {
            ci = (ConstructorInvocation)invocation;
            Interceptions.addConstructorInterception(this.getClass(), ci.getConstructor());
        }
        if (invocation instanceof ConstructionInvocation) {
            ci = (ConstructionInvocation)invocation;
            Interceptions.addConstructionInterception(this.getClass(), ci.getConstructor());
        } else if (invocation instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)invocation;
            Interceptions.addMethodInterception(this.getClass(), mi.getMethod());
        } else if (invocation instanceof FieldReadInvocation) {
            fi = (FieldReadInvocation)invocation;
            Interceptions.addFieldReadInterception(this.getClass(), fi.getField());
        } else if (invocation instanceof FieldWriteInvocation) {
            fi = (FieldWriteInvocation)invocation;
            Interceptions.addFieldWriteInterception(this.getClass(), fi.getField());
        }
        return invocation.invokeNext();
    }

    private String getClassName(Constructor c) {
        return this.getClassName(c.getDeclaringClass().getName());
    }

    private String getClassName(Method m) {
        return this.getClassName(m.getDeclaringClass().getName());
    }

    private String getClassName(Field f) {
        return this.getClassName(f.getDeclaringClass().getName());
    }

    private String getClassName(String s) {
        return s.substring(s.lastIndexOf(46) + 1);
    }
}

