/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import org.jboss.annotation.factory.javassist.AnnotationProxy;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.SecurityActions;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.util.ReflectToJavassist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortableAnnotationElement {
    private static volatile boolean closingDownManager;

    public static void setClosingDownManager(boolean closing) {
        closingDownManager = closing;
    }

    public static boolean isInvisibleAnnotationPresent(Field field, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
            return AnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation);
        }
        return false;
    }

    public static boolean isInvisibleAnnotationPresent(CtField field, String annotation) {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            FieldInfo mi = field.getFieldInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return false;
            }
            return invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    public static boolean isVisibleAnnotationPresent(CtField field, String annotation) {
        if (closingDownManager) {
            return false;
        }
        FieldInfo mi = field.getFieldInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation) != null;
    }

    public static boolean isAnyAnnotationPresent(CtField ctField, String annotation) {
        if (closingDownManager) {
            return false;
        }
        FieldInfo mi = ctField.getFieldInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            return invisible != null && invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    public static boolean isInvisibleAnnotationPresent(Method method, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
            if (ctMethod == null) {
                return false;
            }
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return false;
            }
            return invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(Field field, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (AnnotationElement.isVisibleAnnotationPresent(field, annotation)) {
            return true;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtField ctField = ReflectToJavassist.fieldToJavassist(field);
            return AnnotationElement.isAnyAnnotationPresent(ctField, annotation);
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(Method method, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (AnnotationElement.isVisibleAnnotationPresent(method, annotation)) {
            return true;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
            if (ctMethod == null) {
                return false;
            }
            boolean present = AnnotationElement.isAnyAnnotationPresent(ctMethod, annotation);
            return present;
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(CtMethod ctMethod, String annotation) {
        if (closingDownManager) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            return invisible != null && invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    public static boolean isInvisibleAnnotationPresent(Constructor<?> con, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
            return AnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation);
        }
        return false;
    }

    public static boolean isInvisibleAnnotationPresent(CtConstructor ctMethod, String annotation) {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return false;
            }
            return invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    public static boolean isVisibleAnnotationPresent(CtConstructor ctMethod, String annotation) {
        if (closingDownManager) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation) != null;
    }

    public static boolean isAnyAnnotationPresent(Constructor<?> con, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (AnnotationElement.isVisibleAnnotationPresent(con, annotation)) {
            return true;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
            return AnnotationElement.isAnyAnnotationPresent(ctMethod, annotation);
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(CtConstructor ctMethod, String annotation) {
        if (closingDownManager) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            return invisible != null && invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    public static boolean isInvisibleAnnotationPresent(Class<?> clazz, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            if (clazz == Void.TYPE) {
                return false;
            }
            ClassFile cf = AnnotationElement.getClassFile(clazz);
            AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return false;
            }
            return invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(CtClass clazz, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        try {
            if (clazz == CtClass.voidType) {
                return false;
            }
            CtClass theClass = clazz;
            while (theClass.isArray()) {
                theClass = theClass.getComponentType();
            }
            if (theClass.isPrimitive()) {
                return false;
            }
            ClassFile cf = theClass.getClassFile2();
            AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
            if (visible != null && visible.getAnnotation(annotation) != null) {
                return true;
            }
            if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
                AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
                return invisible != null && invisible.getAnnotation(annotation) != null;
            }
            return false;
        }
        catch (RuntimeException e) {
            String name = clazz != null ? clazz.getName() : null;
            throw new RuntimeException("Error looking for " + annotation + " in " + name, e);
        }
    }

    public static boolean isAnyAnnotationPresent(Class<?> clazz, String annotation) throws Exception {
        if (closingDownManager) {
            return false;
        }
        if (clazz == Void.TYPE) {
            return false;
        }
        if (AnnotationElement.isVisibleAnnotationPresent(clazz, annotation)) {
            return true;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            ClassFile cf = AnnotationElement.getClassFile(clazz);
            AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
            return invisible != null && invisible.getAnnotation(annotation) != null;
        }
        return false;
    }

    protected static ClassFile getClassFile(Class<?> clazz) throws NotFoundException {
        ClassPool pool = AspectManager.instance().findClassPool(SecurityActions.getClassLoader(clazz));
        CtClass ct = pool.get(clazz.getName());
        ClassFile cf = ct.getClassFile2();
        return cf;
    }

    protected static Object create(AnnotationsAttribute group, Class<? extends Annotation> annotation) throws Exception {
        if (group == null) {
            return null;
        }
        javassist.bytecode.annotation.Annotation info = group.getAnnotation(annotation.getName());
        if (info == null) {
            return null;
        }
        return AnnotationProxy.createProxy(info, annotation);
    }

    public static Object getInvisibleAnnotation(Method method, Class<? extends Annotation> annotation) {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            try {
                CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
                if (ctMethod == null) {
                    return null;
                }
                MethodInfo mi = ctMethod.getMethodInfo2();
                AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
                if (invisible == null) {
                    return null;
                }
                return PortableAnnotationElement.create(invisible, annotation);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static Object getInvisibleAnnotation(Constructor<?> con, Class<? extends Annotation> annotation) {
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            try {
                CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
                MethodInfo mi = ctMethod.getMethodInfo2();
                AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
                if (invisible == null) {
                    return null;
                }
                return PortableAnnotationElement.create(invisible, annotation);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static Object getInvisibleAnnotation(Field field, Class<? extends Annotation> annotation) {
        if (closingDownManager) {
            return false;
        }
        try {
            CtField ctField = ReflectToJavassist.fieldToJavassist(field);
            FieldInfo mi = ctField.getFieldInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return null;
            }
            return PortableAnnotationElement.create(invisible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInvisibleAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (closingDownManager) {
            return false;
        }
        try {
            if (clazz == Void.TYPE) {
                return null;
            }
            ClassFile cf = PortableAnnotationElement.getClassFile(clazz);
            AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return null;
            }
            return PortableAnnotationElement.create(invisible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getAnyAnnotation(Method method, Class<? extends Annotation> annotation) {
        Annotation rtn = AnnotationElement.getVisibleAnnotation(method, annotation);
        if (rtn != null) {
            return rtn;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            return PortableAnnotationElement.getInvisibleAnnotation(method, annotation);
        }
        return null;
    }

    public static Object getAnyAnnotation(Constructor<?> con, Class<? extends Annotation> annotation) {
        Annotation rtn = AnnotationElement.getVisibleAnnotation(con, annotation);
        if (rtn != null) {
            return rtn;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            return PortableAnnotationElement.getInvisibleAnnotation(con, annotation);
        }
        return null;
    }

    public static Object getAnyAnnotation(Field field, Class<? extends Annotation> annotation) {
        Annotation rtn = AnnotationElement.getVisibleAnnotation(field, annotation);
        if (rtn != null) {
            return rtn;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            return PortableAnnotationElement.getInvisibleAnnotation(field, annotation);
        }
        return null;
    }

    public static Object getAnyAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (clazz == Void.TYPE) {
            return null;
        }
        Annotation rtn = AnnotationElement.getVisibleAnnotation(clazz, annotation);
        if (rtn != null) {
            return rtn;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            return PortableAnnotationElement.getInvisibleAnnotation(clazz, annotation);
        }
        return null;
    }

    public static boolean isAnyAnnotationPresent(Field field, Class<? extends Annotation> annotation) throws Exception {
        if (AnnotationElement.isVisibleAnnotationPresent(field, annotation)) {
            return true;
        }
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
            return PortableAnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation.getName());
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) throws Exception {
        if (clazz == Void.TYPE) {
            return false;
        }
        if (AnnotationElement.isVisibleAnnotationPresent(clazz, annotation)) {
            return true;
        }
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            ClassFile cf = PortableAnnotationElement.getClassFile(clazz);
            AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return false;
            }
            return invisible.getAnnotation(annotation.getName()) != null;
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(Constructor<?> con, Class<? extends Annotation> annotation) throws Exception {
        if (AnnotationElement.isVisibleAnnotationPresent(con, annotation)) {
            return true;
        }
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
            return PortableAnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation.getName());
        }
        return false;
    }

    public static boolean isAnyAnnotationPresent(Method method, Class<? extends Annotation> annotation) throws Exception {
        if (AnnotationElement.isVisibleAnnotationPresent(method, annotation)) {
            return true;
        }
        if (closingDownManager) {
            return false;
        }
        if (PortableAnnotationElement.includeInvisibleAnnotation(annotation)) {
            CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
            if (ctMethod == null) {
                return false;
            }
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return false;
            }
            return invisible.getAnnotation(annotation.getName()) != null;
        }
        return false;
    }

    protected static boolean includeInvisibleAnnotation(Class<? extends Annotation> annotation) {
        return PortableAnnotationElement.includeInvisibleAnnotation(annotation.getPackage().getName());
    }

    protected static boolean includeInvisibleAnnotation(String annotation) {
        for (String includedAnnotation : AspectManager.instance().getIncludedInvisibleAnnotations()) {
            if (!includedAnnotation.equals("*") && !annotation.startsWith(includedAnnotation)) continue;
            return true;
        }
        return false;
    }
}

