/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.ConstructorJoinPointGenerator;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.aop.util.logging.AOPLogger;

public class GeneratedAdvisorConstructorExecutionTransformer
extends ConstructorExecutionTransformer {
    private static final AOPLogger logger = AOPLogger.getLogger(GeneratedAdvisorConstructorExecutionTransformer.class);

    public GeneratedAdvisorConstructorExecutionTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected boolean addInfoAsWeakReference() {
        return false;
    }

    protected boolean markInfoAsSynthetic() {
        return false;
    }

    protected void generateConstructorInfoField(CtClass clazz, CtConstructor constructor, int index) throws CannotCompileException, NotFoundException {
        String ciname = this.addConstructorInfoField(4, ((GeneratedAdvisorInstrumentor)this.getInstrumentor()).getGenadvisor(), GeneratedAdvisorConstructorExecutionTransformer.getConstructorInfoFieldName(clazz.getSimpleName(), index));
        this.addJoinpoint(clazz, constructor, ciname, index);
        long wrapperHash = JavassistMethodHashing.methodHash(clazz.getDeclaredMethod(GeneratedAdvisorConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()), constructor.getParameterTypes()));
        long constructorHash = JavassistMethodHashing.constructorHash(constructor);
        ((GeneratedAdvisorInstrumentor)this.getInstrumentor()).initialiseConstructorInfoField(ciname, index, constructorHash, wrapperHash);
    }

    private void addJoinpoint(CtClass clazz, CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException {
        CtClass joinpoint = this.createJoinpointClass(clazz, constructor, ciname, index);
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)this.getInstrumentor()).getGenadvisor();
        CtField field = new CtField(joinpoint, ConstructorJoinPointGenerator.getGeneratedJoinPointFieldName(clazz.getSimpleName(), index), genadvisor);
        field.setModifiers(1);
        genadvisor.addField(field);
    }

    private CtClass createJoinpointClass(CtClass clazz, CtConstructor constructor, String ciname, int index) throws CannotCompileException, NotFoundException {
        return ConstructorJoinPointGenerator.createJoinpointBaseClass((GeneratedAdvisorInstrumentor)this.getInstrumentor(), clazz, constructor, ciname, index);
    }

    protected void initialiseWrapper(int mod, CtConstructor constructor, int index) throws NotFoundException, CannotCompileException {
        CtClass genadvisor = this.getGenAdvisor();
        CtClass clazz = constructor.getDeclaringClass();
        CtClass[] exceptions = constructor.getExceptionTypes();
        CtClass type = constructor.getDeclaringClass();
        CtMethod innerWmethod = CtNewMethod.make(clazz, this.getInnerWrapperMethodName(constructor), constructor.getParameterTypes(), exceptions, null, genadvisor);
        innerWmethod.setModifiers(Modifier.clear(mod, 8) & 1);
        this.setTemporaryWrapperCode(type, innerWmethod);
        genadvisor.addMethod(innerWmethod);
        CtMethod wmethod = CtNewMethod.make(clazz, GeneratedAdvisorConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()), constructor.getParameterTypes(), exceptions, null, clazz);
        wmethod.setModifiers(mod);
        wmethod.setBody("{return ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")" + "aop$classAdvisor$aop" + ")." + this.getInnerWrapperMethodName(constructor) + "($$);}");
        Instrumentor.addSyntheticAttribute(wmethod);
        clazz.addMethod(wmethod);
        this.getWrapper().prepareForWrapping(constructor, 0);
    }

    protected void setEmptyWrapperCode(CtConstructor constructor) throws NotFoundException {
        CtClass clazz = constructor.getDeclaringClass();
        String innerCode = "{     return new " + clazz.getName() + "($$); " + "}";
        try {
            CtMethod innerWrapperMethod = this.getInnerWrapperMethod(constructor);
            innerWrapperMethod.setBody(innerCode);
        }
        catch (CannotCompileException e) {
            logger.error(innerCode);
            throw new RuntimeException(e);
        }
        try {
            CtMethod outerWrappedMethod = this.getWrapperMethod(constructor);
            outerWrappedMethod.setBody(this.outerDelegatingBody(constructor));
        }
        catch (CannotCompileException e) {
            logger.error(this.outerDelegatingBody(constructor));
            throw new RuntimeException(e);
        }
    }

    protected void setEmptyWrapperCodeLater(CtConstructor constructor) throws NotFoundException {
        CtMethod outerWrapperMethod = this.getWrapperMethod(constructor);
        this.codifier.addPendingCode(outerWrapperMethod, this.outerDelegatingBody(constructor));
        CtMethod innerWrapperMethod = this.getInnerWrapperMethod(constructor);
        String innerCode = "{     return new " + constructor.getDeclaringClass().getName() + "($$); " + "}";
        this.codifier.addPendingCode(innerWrapperMethod, innerCode);
    }

    private CtMethod getInnerWrapperMethod(CtConstructor constructor) throws NotFoundException {
        CtClass genadvisor = this.getGenAdvisor();
        return genadvisor.getDeclaredMethod(this.getInnerWrapperMethodName(constructor), constructor.getParameterTypes());
    }

    private String getInnerWrapperMethodName(CtConstructor constructor) {
        return GeneratedAdvisorConstructorExecutionTransformer.constructorFactory(GeneratedAdvisorInstrumentor.getAdvisorName(constructor.getDeclaringClass()));
    }

    private String outerDelegatingBody(CtConstructor constructor) {
        return "{return ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(constructor.getDeclaringClass()) + ")" + "aop$classAdvisor$aop" + ")." + this.getInnerWrapperMethodName(constructor) + "($$);}";
    }

    private CtClass getGenAdvisor() {
        return ((GeneratedAdvisorInstrumentor)this.getInstrumentor()).getGenadvisor();
    }

    protected void createWrapper(ConstructorExecutionTransformer.ConstructorTransformation trans) throws CannotCompileException, NotFoundException {
        CtMethod outerWrapper = this.getWrapperMethod(trans.getConstructor());
        outerWrapper.setBody(this.outerDelegatingBody(trans.getConstructor()));
        CtMethod innerWrapper = this.getInnerWrapperMethod(trans.getConstructor());
        String joinpointName = ConstructorJoinPointGenerator.getGeneratedJoinPointFieldName(trans.getConstructor().getDeclaringClass().getSimpleName(), trans.getIndex());
        String infoName = GeneratedAdvisorConstructorExecutionTransformer.getConstructorInfoFieldName(trans.getConstructor().getDeclaringClass().getSimpleName(), trans.getIndex());
        String code = "{" + GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName) + "   try" + "   {" + "      if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "      {" + "         if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "         {" + "            super." + "generateJoinPointClass" + "(" + infoName + ");" + "         }" + "      }" + "      if (" + joinpointName + " == null)" + "      { " + "         return new " + trans.getClassName() + "($$); " + "      }" + "      else" + "      {" + "         return " + joinpointName + "." + "invokeJoinpoint" + "($$);" + "      }" + "   } finally {" + GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName) + "   }" + "}";
        this.codifier.addPendingCode(innerWrapper, code);
    }
}

