/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CtClass;
import javassist.CtConstructor;
import javassist.Modifier;
import org.jboss.aop.instrument.ConstructionTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedConstructionInvocations;

public class OptimizedConstructionTransformer
extends ConstructionTransformer {
    public OptimizedConstructionTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected void insertInterception(CtConstructor constructor, int index) throws Exception {
        CtClass type = constructor.getDeclaringClass();
        OptimizedConstructionInvocations.createOptimizedInvocationClass(this.instrumentor, type, constructor, index);
        this.createWrapper(type, constructor, constructor.getDeclaringClass(), index);
    }

    private void createWrapper(CtClass type, CtConstructor constructor, CtClass clazz, int index) throws Exception {
        String invocationClass = OptimizedConstructionInvocations.getOptimizedInvocationClassName(type, index);
        if (!Modifier.isPublic(constructor.getModifiers())) {
            invocationClass = invocationClass.substring(invocationClass.lastIndexOf(46) + 1);
            invocationClass = clazz.getName() + "$" + invocationClass;
        }
        String infoName = OptimizedConstructionTransformer.getConstructionInfoFieldName(clazz.getSimpleName(), index);
        String code = "    " + OptimizedConstructionTransformer.constructionInfoFromWeakReference("info", infoName) + "    org.jboss.aop.advice.Interceptor[] interceptors = info.getInterceptors(); " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + invocationClass + " invocation = new " + invocationClass + "(interceptors, " + "aop$classAdvisor$aop" + ".getConstructors()[" + index + "]); " + OptimizedBehaviourInvocations.setArguments(constructor.getParameterTypes().length) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       invocation.setTargetObject(this); " + "       invocation.invokeNext(); " + "    } ";
        constructor.insertAfter(code, false);
    }
}

