/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotationc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotationc.BytecodePOJO;
import org.jboss.test.aop.annotationc.ClassAnnotation;
import org.jboss.test.aop.annotationc.MyEnum;
import org.jboss.test.aop.annotationc.complex;
import org.jboss.test.aop.annotationc.empty;
import org.jboss.test.aop.annotationc.single;

public class AnnotationTester
extends AOPTestWithSetup {
    public static Test suite() {
        TestSuite suite = new TestSuite("AnnotationTester");
        suite.addTestSuite(AnnotationTester.class);
        return suite;
    }

    public AnnotationTester(String name) {
        super(name);
    }

    public void testCreateAnnotation() throws Exception {
        String expr = "@org.jboss.test.aop.annotationc.complex (ch='a', string=\"hello world\", flt=5.5, dbl=6.6, shrt=5, lng=6, integer=7, bool=true, annotation=@org.jboss.test.aop.annotationc.single(\"hello\"), array={\"hello\", \"world\"}, clazz=java.lang.String, enumVal=org.jboss.test.aop.annotationc.MyEnum.ONE)";
        complex c = (complex)AnnotationCreator.createAnnotation((String)expr, complex.class);
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        single s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.ONE) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testClassAnnotation() {
        empty e = (empty)AnnotationElement.getAnyAnnotation(BytecodePOJO.class, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        single s = (single)AnnotationElement.getAnyAnnotation(BytecodePOJO.class, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        complex c = (complex)AnnotationElement.getAnyAnnotation(BytecodePOJO.class, complex.class);
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.ONE) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testClassGetVisibleAnnotations() {
        empty e = null;
        single s = null;
        complex c = null;
        try {
            Annotation[] annotations = AnnotationElement.getVisibleAnnotations(BytecodePOJO.class);
            for (int i = 0; i < annotations.length; ++i) {
                if (complex.class.isAssignableFrom(annotations[i].getClass())) {
                    c = (complex)annotations[i];
                    continue;
                }
                if (empty.class.isAssignableFrom(annotations[i].getClass())) {
                    e = (empty)annotations[i];
                    continue;
                }
                if (!single.class.isAssignableFrom(annotations[i].getClass())) continue;
                s = (single)annotations[i];
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        AnnotationTester.assertNotNull(c);
        AnnotationTester.assertNotNull(e);
        AnnotationTester.assertNotNull(s);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.ONE) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testConstructorAnnotation() {
        Constructor<?> con = BytecodePOJO.class.getConstructors()[0];
        empty e = (empty)AnnotationElement.getAnyAnnotation(con, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        single s = (single)AnnotationElement.getAnyAnnotation(con, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        complex c = (complex)AnnotationElement.getAnyAnnotation(con, complex.class);
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.TWO) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testConstructorGetVisibleAnnotations() throws Exception {
        Constructor<?> con = BytecodePOJO.class.getConstructors()[0];
        empty e = null;
        complex c = null;
        single s = null;
        try {
            Annotation[] annotations = AnnotationElement.getVisibleAnnotations(con);
            for (int i = 0; i < annotations.length; ++i) {
                if (complex.class.isAssignableFrom(annotations[i].getClass())) {
                    c = (complex)annotations[i];
                    continue;
                }
                if (empty.class.isAssignableFrom(annotations[i].getClass())) {
                    e = (empty)annotations[i];
                    continue;
                }
                if (!single.class.isAssignableFrom(annotations[i].getClass())) continue;
                s = (single)annotations[i];
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        AnnotationTester.assertNotNull(c);
        AnnotationTester.assertNotNull(e);
        AnnotationTester.assertNotNull(s);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.TWO) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testMethodAnnotation() throws Exception {
        Method con = BytecodePOJO.class.getMethod("method", new Class[0]);
        empty e = (empty)AnnotationElement.getAnyAnnotation((Method)con, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        single s = (single)AnnotationElement.getAnyAnnotation((Method)con, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        complex c = (complex)AnnotationElement.getAnyAnnotation((Method)con, complex.class);
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.TWO) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testMethodGetVisibleAnnotations() throws Exception {
        Method con = BytecodePOJO.class.getMethod("method", new Class[0]);
        empty e = null;
        complex c = null;
        single s = null;
        try {
            Annotation[] annotations = AnnotationElement.getVisibleAnnotations((Method)con);
            for (int i = 0; i < annotations.length; ++i) {
                if (complex.class.isAssignableFrom(annotations[i].getClass())) {
                    c = (complex)annotations[i];
                    continue;
                }
                if (empty.class.isAssignableFrom(annotations[i].getClass())) {
                    e = (empty)annotations[i];
                    continue;
                }
                if (!single.class.isAssignableFrom(annotations[i].getClass())) continue;
                s = (single)annotations[i];
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        AnnotationTester.assertNotNull(c);
        AnnotationTester.assertNotNull(e);
        AnnotationTester.assertNotNull(s);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.TWO) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testPrimitiveClassAnnotationCreation() throws Exception {
        this.testPrimitiveClassCreate("void.class", Void.TYPE);
        this.testPrimitiveClassCreate("int.class", Integer.TYPE);
        this.testPrimitiveClassCreate("short.class", Short.TYPE);
        this.testPrimitiveClassCreate("long.class", Long.TYPE);
        this.testPrimitiveClassCreate("double.class", Double.TYPE);
        this.testPrimitiveClassCreate("float.class", Float.TYPE);
        this.testPrimitiveClassCreate("char.class", Character.TYPE);
        this.testPrimitiveClassCreate("boolean.class", Boolean.TYPE);
    }

    private void testPrimitiveClassCreate(String sPrimitive, Class primitive) throws Exception {
        String expr = "@org.jboss.test.aop.annotationc.ClassAnnotation (" + sPrimitive + ")";
        ClassAnnotation c = (ClassAnnotation)AnnotationCreator.createAnnotation((String)expr, ClassAnnotation.class);
        if (!c.value().equals(primitive)) {
            throw new RuntimeException("failed to match " + primitive.getName());
        }
    }

    public void testPrimitiveClassMemberAnnotation() throws Exception {
        Class<BytecodePOJO> clazz = BytecodePOJO.class;
        Class[] types = new Class[]{};
        this.primitive(clazz.getMethod("someVoid", types), Void.TYPE);
        this.primitive(clazz.getMethod("someInt", types), Integer.TYPE);
        this.primitive(clazz.getMethod("someShort", types), Short.TYPE);
        this.primitive(clazz.getMethod("someLong", types), Long.TYPE);
        this.primitive(clazz.getMethod("someDouble", types), Double.TYPE);
        this.primitive(clazz.getMethod("someFloat", types), Float.TYPE);
        this.primitive(clazz.getMethod("someChar", types), Character.TYPE);
        this.primitive(clazz.getMethod("someBoolean", types), Boolean.TYPE);
    }

    private void primitive(Method method, Class primitive) {
        ClassAnnotation ca = (ClassAnnotation)AnnotationElement.getAnyAnnotation((Method)method, ClassAnnotation.class);
        if (ca == null) {
            throw new RuntimeException("Failed to get ClassAnnotation for: " + method);
        }
        if (!ca.value().equals(primitive)) {
            throw new RuntimeException("failed to match " + primitive.getName() + "  for method: " + method);
        }
    }

    public void testFieldAnnotation() throws Exception {
        Field con = BytecodePOJO.class.getField("field");
        empty e = (empty)AnnotationElement.getAnyAnnotation((Field)con, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        single s = (single)AnnotationElement.getAnyAnnotation((Field)con, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        complex c = (complex)AnnotationElement.getAnyAnnotation((Field)con, complex.class);
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.ONE) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testFieldGetVisibleAnnotations() throws Exception {
        Field con = BytecodePOJO.class.getField("field");
        empty e = null;
        complex c = null;
        single s = null;
        try {
            Annotation[] annotations = AnnotationElement.getVisibleAnnotations((Field)con);
            for (int i = 0; i < annotations.length; ++i) {
                if (complex.class.isAssignableFrom(annotations[i].getClass())) {
                    c = (complex)annotations[i];
                    continue;
                }
                if (empty.class.isAssignableFrom(annotations[i].getClass())) {
                    e = (empty)annotations[i];
                    continue;
                }
                if (!single.class.isAssignableFrom(annotations[i].getClass())) continue;
                s = (single)annotations[i];
            }
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        AnnotationTester.assertNotNull(c);
        AnnotationTester.assertNotNull(e);
        AnnotationTester.assertNotNull(s);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("hello world")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        if (c == null) {
            throw new RuntimeException("failed to get @complex");
        }
        if (c.ch() != 'a') {
            throw new RuntimeException("@complex.ch has wrong value");
        }
        if (!c.string().equals("hello world")) {
            throw new RuntimeException("@complex.string has wrong value");
        }
        if ((double)c.flt() != 5.5) {
            throw new RuntimeException("@complex.flt has wrong value");
        }
        if (c.dbl() != 6.6) {
            throw new RuntimeException("@complex.dbl has wrong value");
        }
        if (c.shrt() != 5) {
            throw new RuntimeException("@complex.shrt has wrong value");
        }
        if (c.lng() != 6L) {
            throw new RuntimeException("@complex.lng has wrong value");
        }
        if (c.integer() != 7) {
            throw new RuntimeException("@complex.integer has wrong value");
        }
        if (!c.bool()) {
            throw new RuntimeException("@complex.bool has wrong value");
        }
        s = c.annotation();
        if (s == null) {
            throw new RuntimeException("@complex.annotation is null");
        }
        if (!s.value().equals("hello")) {
            throw new RuntimeException("@complex.annotation has wrong value");
        }
        if (!c.array()[0].equals("hello")) {
            throw new RuntimeException("@complex.array[0] has wrong value");
        }
        if (!c.array()[1].equals("world")) {
            throw new RuntimeException("@complex.array[1] has wrong value");
        }
        if (!String.class.equals((Object)c.clazz())) {
            throw new RuntimeException("@complex.clazz has wrong value");
        }
        if (c.enumVal() != MyEnum.ONE) {
            throw new RuntimeException("@complex.enumVal has wrong value");
        }
    }

    public void testInnerClass() throws Exception {
        empty e = (empty)AnnotationElement.getAnyAnnotation(BytecodePOJO.InnerClass.class, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        single s = (single)AnnotationElement.getAnyAnnotation(BytecodePOJO.InnerClass.class, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("inner")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Constructor<?>[] ctors = BytecodePOJO.InnerClass.class.getDeclaredConstructors();
        Arrays.sort(ctors, ConstructorComparator.INSTANCE);
        System.out.println(ctors[0]);
        System.out.println(ctors[1]);
        Constructor<?> def = ctors[0];
        e = (empty)AnnotationElement.getAnyAnnotation(def, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation(def, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("inner ctor")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Constructor<?> con = ctors[1];
        e = (empty)AnnotationElement.getAnyAnnotation(con, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation(con, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("inner ctor 2")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Method m = BytecodePOJO.InnerClass.class.getDeclaredMethod("method", Integer.TYPE);
        e = (empty)AnnotationElement.getAnyAnnotation((Method)m, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation((Method)m, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("inner method")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Field f = BytecodePOJO.InnerClass.class.getDeclaredField("field");
        e = (empty)AnnotationElement.getAnyAnnotation((Field)f, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation((Field)f, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("inner field")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
    }

    public void testStaticInnerClass() throws Exception {
        empty e = (empty)AnnotationElement.getAnyAnnotation(BytecodePOJO.StaticInnerClass.class, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        single s = (single)AnnotationElement.getAnyAnnotation(BytecodePOJO.StaticInnerClass.class, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("static inner")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Constructor def = BytecodePOJO.StaticInnerClass.class.getDeclaredConstructor(new Class[0]);
        e = (empty)AnnotationElement.getAnyAnnotation(def, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation(def, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("static inner ctor")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Constructor con = BytecodePOJO.StaticInnerClass.class.getDeclaredConstructor(Integer.TYPE);
        e = (empty)AnnotationElement.getAnyAnnotation(con, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation(con, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("static inner ctor 2")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Method m = BytecodePOJO.StaticInnerClass.class.getDeclaredMethod("method", Integer.TYPE);
        e = (empty)AnnotationElement.getAnyAnnotation((Method)m, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation((Method)m, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("static inner method")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
        Field f = BytecodePOJO.StaticInnerClass.class.getDeclaredField("field");
        e = (empty)AnnotationElement.getAnyAnnotation((Field)f, empty.class);
        if (e == null) {
            throw new RuntimeException("failed to get @empty");
        }
        s = (single)AnnotationElement.getAnyAnnotation((Field)f, single.class);
        if (s == null) {
            throw new RuntimeException("failed to get @single");
        }
        if (!s.value().equals("static inner field")) {
            throw new RuntimeException("@single.value mismatch: " + s.value());
        }
    }
}

