/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.array;

import java.util.List;
import junit.framework.Assert;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.array.ArrayElementReadInvocation;
import org.jboss.aop.array.ArrayElementWriteInvocation;
import org.jboss.aop.array.ArrayReference;
import org.jboss.aop.array.ArrayRegistry;
import org.jboss.aop.array.BooleanArrayElementWriteInvocation;
import org.jboss.aop.array.ByteArrayElementWriteInvocation;
import org.jboss.aop.array.CharArrayElementWriteInvocation;
import org.jboss.aop.array.DoubleArrayElementWriteInvocation;
import org.jboss.aop.array.FloatArrayElementWriteInvocation;
import org.jboss.aop.array.IntArrayElementWriteInvocation;
import org.jboss.aop.array.LongArrayElementWriteInvocation;
import org.jboss.aop.array.ObjectArrayElementWriteInvocation;
import org.jboss.aop.array.ShortArrayElementWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;

public class TestArrayElementInterceptor
implements Interceptor {
    public static int index;
    public static Object value;
    public static List<ArrayReference> owners;

    public static void clear() {
        index = -1;
        value = null;
        owners = null;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof ArrayElementReadInvocation) {
            index = ((ArrayElementReadInvocation)invocation).getIndex();
            value = null;
        } else if (invocation instanceof ArrayElementWriteInvocation) {
            index = ((ArrayElementWriteInvocation)invocation).getIndex();
            value = ((ArrayElementWriteInvocation)invocation).getValue();
            this.checkType((ArrayElementWriteInvocation)invocation);
        }
        owners = ArrayRegistry.getInstance().getArrayOwners(invocation.getTargetObject());
        invocation.getMetaData().addMetaData((Object)"test", (Object)"invoked", (Object)"TestArrayElementInterceptor");
        return invocation.invokeNext();
    }

    private void checkType(ArrayElementWriteInvocation invocation) {
        if (!(invocation instanceof ObjectArrayElementWriteInvocation)) {
            if (invocation instanceof ByteArrayElementWriteInvocation) {
                byte b = ((ByteArrayElementWriteInvocation)invocation).getByteValue();
                Assert.assertEquals((byte)b, (byte)((Byte)invocation.getValue()));
            } else if (invocation instanceof BooleanArrayElementWriteInvocation) {
                boolean b = ((BooleanArrayElementWriteInvocation)invocation).getBooleanValue();
                Assert.assertEquals((boolean)b, (boolean)((Boolean)invocation.getValue()));
            } else if (invocation instanceof CharArrayElementWriteInvocation) {
                char c = ((CharArrayElementWriteInvocation)invocation).getCharValue();
                Assert.assertEquals((char)c, (char)((Character)invocation.getValue()).charValue());
            } else if (invocation instanceof DoubleArrayElementWriteInvocation) {
                double d = ((DoubleArrayElementWriteInvocation)invocation).getDoubleValue();
                Assert.assertEquals((Object)d, (Object)((Double)invocation.getValue()));
            } else if (invocation instanceof FloatArrayElementWriteInvocation) {
                float f = ((FloatArrayElementWriteInvocation)invocation).getFloatValue();
                Assert.assertEquals((Object)Float.valueOf(f), (Object)Float.valueOf(((Float)invocation.getValue()).floatValue()));
            } else if (invocation instanceof IntArrayElementWriteInvocation) {
                int i = ((IntArrayElementWriteInvocation)invocation).getIntValue();
                Assert.assertEquals((int)i, (int)((Integer)invocation.getValue()));
            } else if (invocation instanceof LongArrayElementWriteInvocation) {
                long l = ((LongArrayElementWriteInvocation)invocation).getLongValue();
                Assert.assertEquals((long)l, (long)((Long)invocation.getValue()));
            } else if (invocation instanceof ShortArrayElementWriteInvocation) {
                short s = ((ShortArrayElementWriteInvocation)invocation).getShortValue();
                Assert.assertEquals((short)s, (short)((Short)invocation.getValue()));
            } else {
                throw new RuntimeException("Dodgy invocation type " + invocation.getClass().getName());
            }
        }
    }

    public static class Value {
        public Object value;
    }
}

