/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.dynamicinvoke;

import java.lang.reflect.Method;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.dynamicinvoke.MyInterceptor;
import org.jboss.test.aop.dynamicinvoke.POJO;

public class DynamicInvokeTestCase
extends AOPTestWithSetup {
    Advisor advisor;
    POJO pojo;

    public DynamicInvokeTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.pojo = new POJO();
        this.advisor = ((Advised)this.pojo)._getAdvisor();
        this.pojo.advised();
        DynamicInvokeTestCase.assertTrue((boolean)MyInterceptor.isInvoked());
        MyInterceptor.clearHistory();
        this.pojo.unadvised();
        DynamicInvokeTestCase.assertFalse((boolean)MyInterceptor.isInvoked());
        MyInterceptor.clearHistory();
    }

    public void testDynamicInvokeAdvisedMethod() throws Throwable {
        this.invokeMethodDynamically("advised", true);
    }

    public void testDynamicInvokeUnadvisedMethod() throws Throwable {
        this.invokeMethodDynamically("unadvised", false);
    }

    public void invokeMethodDynamically(String methodName, boolean intercepted) throws Throwable {
        Method method = POJO.class.getDeclaredMethod(methodName, new Class[0]);
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInvocation methodInvocation = new MethodInvocation(null, hash, method, null, this.advisor);
        this.advisor.dynamicInvoke((Object)this.pojo, (Invocation)methodInvocation);
        DynamicInvokeTestCase.assertSame((Object)intercepted, (Object)MyInterceptor.isInvoked());
        DynamicInvokeTestCase.assertEquals((String)methodName, (String)POJO.getLastRun());
    }
}

