/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15annotateddeclare;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class SystemOutDecorator
extends PrintStream {
    static PrintStream sysout = null;
    ArrayList warnings = new ArrayList();

    public SystemOutDecorator(OutputStream out) {
        super(out);
        sysout = System.out;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void println(String msg) {
        super.println(msg);
        if (msg.startsWith("WARNING:")) {
            System.out.println(">>>>>");
            super.println(msg);
            System.out.println("<<<<<");
            this.warnings.add(msg);
        }
    }

    public static SystemOutDecorator initialise() {
        SystemOutDecorator sys = new SystemOutDecorator(System.out);
        System.setOut(sys);
        return sys;
    }

    public void kill() {
        System.setOut(sysout);
    }

    String getRidOfAllWhiteSpace(String msg) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (ch == '\n' || ch == '\t' || ch == ' ' || ch == '\r') continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

