/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.nameddomain;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.nameddomain.POJO;
import org.jboss.test.aop.nameddomain.Proxied;

public class NamedDomainTestCase
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)NamedDomainTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("NamedDomainTestCase");
        suite.addTestSuite(NamedDomainTestCase.class);
        return suite;
    }

    public NamedDomainTestCase(String name) {
        super(name);
    }

    public void testWovenNamedDomains() {
        AspectManager manager = AspectManager.instance();
        POJO pojo = new POJO();
        pojo.someMethod();
        Advisor advisor = ((Advised)pojo)._getAdvisor();
        AspectManager domain = advisor.getManager();
        String fqn = domain.getManagerFQN();
        System.out.println("fqn: " + fqn);
        AspectManager foundDomain = manager.findManagerByName(fqn);
        NamedDomainTestCase.assertSame((Object)domain, (Object)foundDomain);
        InstanceAdvisor ia = ((Advised)pojo)._getInstanceAdvisor();
        NamedDomainTestCase.assertNotNull((Object)ia);
        AspectManager instanceDomain = ((Advisor)ia).getManager();
        fqn = instanceDomain.getManagerFQN();
        System.out.println("fqn: " + fqn);
        AspectManager foundInstanceDomain = manager.findManagerByName(fqn);
        NamedDomainTestCase.assertSame((Object)instanceDomain, (Object)foundInstanceDomain);
        for (Field field : pojo.getClass().getDeclaredFields()) {
            System.out.println("F " + field.getName() + " - " + field.isSynthetic());
        }
        for (AccessibleObject accessibleObject : pojo.getClass().getDeclaredMethods()) {
            System.out.println("M " + ((Method)accessibleObject).getName() + " - " + ((Method)accessibleObject).isSynthetic());
        }
    }

    public void testProxiedNamedDomains() throws Exception {
        Proxied tgt = new Proxied();
        URL url = this.getURLRelativeToProjectRoot("/src/resources/test/nameddomain/manual-aop.xml");
        AspectXmlLoader.deployXML((URL)url);
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setTarget((Object)tgt);
        GeneratedAOPProxyFactory factory = new GeneratedAOPProxyFactory();
        Proxied proxied = (Proxied)factory.createAdvisedProxy(params);
        proxied.someMethod();
        Advisor advisor = ((AspectManaged)proxied).getAdvisor();
        NamedDomainTestCase.assertNotNull((Object)advisor);
        AspectManager domain = advisor.getManager();
        String fqn = domain.getManagerFQN();
        AspectManager foundDomain = AspectManager.instance().findManagerByName(fqn);
        NamedDomainTestCase.assertSame((Object)domain, (Object)foundDomain);
        InstanceAdvisor instanceAdvisor = ((AspectManaged)proxied).getInstanceAdvisor();
        NamedDomainTestCase.assertNotNull((Object)instanceAdvisor);
        AspectManager instanceDomain = advisor.getManager();
        fqn = instanceDomain.getManagerFQN();
        AspectManager foundInstanceDomain = AspectManager.instance().findManagerByName(fqn);
        NamedDomainTestCase.assertSame((Object)instanceDomain, (Object)foundInstanceDomain);
    }
}

