/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.precedence;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.precedence.Interceptions;
import org.jboss.test.aop.precedence.POJO;

public class PrecedenceTester
extends AOPTestWithSetup {
    static final String[] PRECEDENCE_ALL_CONSTRUCTOR = new String[]{"FirstInterceptor", "FirstInterceptor2", "SimpleInterceptor2", "SimpleInterceptor3", "TestAspect.advice", "TestAspect2.advice", "LastAspect.advice", "LastAspect2.advice"};
    static final String[] PRECEDENCE_ALL = new String[]{"FirstInterceptor", "FirstInterceptor2", "SimpleInterceptor", "SimpleInterceptor2", "SimpleInterceptor3", "TestAspect.advice", "TestAspect2.advice", "TestAspect3.advice", "LastAspect.advice", "LastAspect2.advice"};
    static final String[] PRECEDENCE_TWO = new String[]{"FirstInterceptor", "FirstInterceptor2", "SimpleInterceptor", "TestAspect.advice", "TestAspect.advice2", "TestAspect.advice3", "TestAspect2.advice", "LastAspect.advice", "LastAspect2.advice"};
    static final String[] PRECEDENCE_THREE = new String[]{"FirstInterceptor", "FirstInterceptor2", "TestAspect.advice", "TestAspect.advice2", "TestAspect.advice3", "LastAspect.advice", "LastAspect2.advice"};
    static final String[] PRECEDENCE_SEVEN = new String[]{"SimpleInterceptor", "SimpleInterceptor2", "SimpleInterceptor3", "TestAspect.advice", "TestAspect.advice2", "TestAspect.advice3"};
    private POJO pojo;

    public static Test suite() {
        TestSuite suite = new TestSuite("PrecedenceTester");
        suite.addTestSuite(PrecedenceTester.class);
        return suite;
    }

    public PrecedenceTester(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.pojo = new POJO();
        Interceptions.reset();
    }

    public void testConstructor() throws Exception {
        System.out.println("*** Invoke constructor");
        Interceptions.reset();
        new POJO();
        this.checkInterceptions(PRECEDENCE_ALL_CONSTRUCTOR);
    }

    public void testVarRead() {
        System.out.println("*** Invoke field read");
        Interceptions.reset();
        int i = this.pojo.var;
        this.checkInterceptions(PRECEDENCE_ALL);
    }

    public void testVarWrite() {
        System.out.println("*** Invoke field write");
        Interceptions.reset();
        this.pojo.var = 1;
        this.checkInterceptions(PRECEDENCE_ALL);
    }

    public void testOneMethod() {
        System.out.println("*** Invoke oneMethod");
        Interceptions.reset();
        this.pojo.oneMethod();
        this.checkInterceptions(PRECEDENCE_ALL);
    }

    public void testTwoMethod() {
        Interceptions.reset();
        this.pojo.twoMethod();
        this.checkInterceptions(PRECEDENCE_TWO);
    }

    public void testThreeMethod() {
        Interceptions.reset();
        this.pojo.threeMethod();
        this.checkInterceptions(PRECEDENCE_THREE);
    }

    public void testFourMethod() {
        Interceptions.reset();
        this.pojo.fourMethod();
        this.checkInterceptions(PRECEDENCE_TWO);
    }

    public void testFiveMethod() {
        Interceptions.reset();
        POJO.factoryMethod();
        this.checkInterceptions(PRECEDENCE_THREE);
    }

    public void testSixMethod() {
        Interceptions.reset();
        this.pojo.sixMethod();
        this.checkInterceptions(PRECEDENCE_THREE);
    }

    public void testSevenMethod() {
        Interceptions.reset();
        this.pojo.sevenMethod();
        this.checkInterceptions(PRECEDENCE_SEVEN);
    }

    private void checkInterceptions(String[] expected) {
        ArrayList<String> intercepted = Interceptions.intercepted;
        PrecedenceTester.assertEquals((String)"Wrong number of interceptions", (int)expected.length, (int)intercepted.size());
        for (int i = 0; i < expected.length; ++i) {
            PrecedenceTester.assertEquals((String)("Wrong interception at index " + i), (String)expected[i], (String)intercepted.get(i));
        }
    }
}

