/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.CodeConversionObserver;
import org.jboss.aop.instrument.Codifier;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WrapperTransformer;
import org.jboss.aop.util.Advisable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldAccessTransformer
implements CodeConversionObserver {
    static final String FIELD_INFO_CLASS_NAME = "org.jboss.aop.FieldInfo";
    Instrumentor instrumentor;
    boolean optimize;
    private Codifier codifier;
    private JoinpointClassifier classifier;
    protected static final String[] transformations = new String[]{"get", "set"};
    protected static final int GET_INDEX = 0;
    protected static final int SET_INDEX = 1;
    protected static final WrapperTransformer wrapper = new WrapperTransformer(transformations);

    protected FieldAccessTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
        this.optimize = AspectManager.optimize;
        this.codifier = new Codifier();
        this.classifier = instrumentor.joinpointClassifier;
    }

    protected void buildFieldWrappers(CtClass clazz, ClassAdvisor advisor, boolean shouldReplaceArrayAccess) throws NotFoundException, CannotCompileException {
        List<CtField> fields = Instrumentor.getAdvisableFields(clazz);
        int fieldIndex = this.fieldOffset(clazz.getSuperclass());
        boolean skipFieldInterception = true;
        if (fields.size() > 0) {
            Iterator<CtField> it = fields.iterator();
            int index = 0;
            while (it.hasNext()) {
                CtField field = it.next();
                JoinpointClassification classificationGet = this.instrumentor.joinpointClassifier.classifyFieldGet(field, advisor);
                JoinpointClassification classificationSet = this.instrumentor.joinpointClassifier.classifyFieldSet(field, advisor);
                if (this.isPrepared(classificationGet) || this.isPrepared(classificationSet)) {
                    if (!Modifier.isPrivate(field.getModifiers())) {
                        skipFieldInterception = false;
                    }
                    this.doBuildFieldWrappers(clazz, field, fieldIndex, shouldReplaceArrayAccess, classificationGet, classificationSet);
                }
                ++index;
                ++fieldIndex;
            }
        }
        if (skipFieldInterception && this.superClassHasAdvisedFields(clazz.getSuperclass())) {
            skipFieldInterception = false;
        }
        ClassLoader cl = clazz.getClassPool().getClassLoader();
        if (skipFieldInterception) {
            advisor.getManager().getInterceptionMarkers(cl).skipFieldAccess(clazz.getName());
        } else {
            advisor.getManager().getInterceptionMarkers(cl).addFieldInterceptionMarker(clazz.getName());
        }
    }

    private boolean superClassHasAdvisedFields(CtClass superClass) throws NotFoundException {
        ClassAdvisor advisor;
        if (superClass == null || superClass.getName().indexOf("java.") == 0) {
            return false;
        }
        try {
            advisor = this.instrumentor.getManager().getTempClassAdvisor(superClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<CtField> fields = Instrumentor.getAdvisableFields(superClass);
        if (fields.size() > 0) {
            for (CtField field : fields) {
                if (Modifier.isPrivate(field.getModifiers())) continue;
                JoinpointClassification classificationGet = this.instrumentor.joinpointClassifier.classifyFieldGet(field, advisor);
                if (this.isPrepared(classificationGet)) {
                    return true;
                }
                JoinpointClassification classificationSet = this.instrumentor.joinpointClassifier.classifyFieldSet(field, advisor);
                if (!this.isPrepared(classificationSet)) continue;
                return true;
            }
        }
        return this.superClassHasAdvisedFields(superClass.getSuperclass());
    }

    protected boolean isPrepared(JoinpointClassification classification) {
        return classification != JoinpointClassification.NOT_INSTRUMENTED;
    }

    protected abstract void doBuildFieldWrappers(CtClass var1, CtField var2, int var3, boolean var4, JoinpointClassification var5, JoinpointClassification var6) throws NotFoundException, CannotCompileException;

    protected String getArrayWriteRegistration(boolean shouldReplaceArrayAccess, String target, CtField field, String oldValue, String newValue) throws NotFoundException {
        if (shouldReplaceArrayAccess && (field.getType().isArray() || field.getType().getName().equals("java.lang.Object"))) {
            return "org.jboss.aop.array.ArrayAdvisor.updateArrayField(" + target + ", \"" + field.getName() + "\", " + oldValue + ", " + newValue + ");";
        }
        return "";
    }

    public boolean replaceFieldAccess(List<CtField> fields, CtClass clazz, ClassAdvisor fieldsAdvisor) throws NotFoundException {
        CodeConverter converter = this.instrumentor.getCodeConverter();
        boolean converted = false;
        for (CtField field : fields) {
            JoinpointClassification fieldSetClassification;
            if (Modifier.isPrivate(field.getModifiers()) || !Advisable.isAdvisable(field)) continue;
            JoinpointClassification fieldGetClassification = this.classifier.classifyFieldGet(field, fieldsAdvisor);
            if (fieldGetClassification.equals(JoinpointClassification.WRAPPED)) {
                converted = true;
                converter.replaceFieldRead(field, clazz, FieldAccessTransformer.fieldRead(field.getName()));
            }
            if (!(fieldSetClassification = this.classifier.classifyFieldSet(field, fieldsAdvisor)).equals(JoinpointClassification.WRAPPED)) continue;
            converted = true;
            converter.replaceFieldWrite(field, clazz, FieldAccessTransformer.fieldWrite(field.getName()));
        }
        return converted;
    }

    public void wrap(CtClass clazz, Collection<Integer> fieldsGet, Collection<Integer> fieldsSet) throws CannotCompileException, NotFoundException {
        CtMethod method;
        String code;
        CtField field;
        List<CtField> advisableFields = Instrumentor.getAdvisableFields(clazz);
        CtField[] fields = new CtField[advisableFields.size()];
        fields = advisableFields.toArray(fields);
        for (int fieldIndex : fieldsGet) {
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared(field, 0)) continue;
            wrapper.wrap(field, 0);
            code = "{" + field.getType().getName() + " var; return var;}";
            method = this.getWrapperReadMethod(field, clazz);
            method.setBody(code);
            code = this.getWrapperBody(clazz, field, true, fieldIndex);
            if (!Modifier.isPrivate(field.getModifiers())) {
                this.instrumentor.converter.replaceFieldRead(field, clazz, FieldAccessTransformer.fieldRead(field.getName()));
                this.codifier.addPendingCode(method, code);
                continue;
            }
            this.replaceFieldAccessInternally(clazz, field, true, false, fieldIndex);
            method.setBody(code);
        }
        for (int fieldIndex : fieldsSet) {
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared(field, 1)) continue;
            wrapper.wrap(field, 1);
            code = "{  }";
            method = this.getWrapperWriteMethod(field, clazz);
            method.setBody(code);
            code = this.getWrapperBody(clazz, field, false, fieldIndex);
            if (!Modifier.isPrivate(field.getModifiers())) {
                this.instrumentor.converter.replaceFieldWrite(field, clazz, FieldAccessTransformer.fieldWrite(field.getName()));
                this.codifier.addPendingCode(method, code);
                continue;
            }
            this.replaceFieldAccessInternally(clazz, field, false, true, fieldIndex);
            method.setBody(code);
        }
    }

    protected CtMethod getWrapperReadMethod(CtField field, CtClass clazz) throws NotFoundException {
        return clazz.getDeclaredMethod(FieldAccessTransformer.fieldRead(field.getName()));
    }

    protected CtMethod getWrapperWriteMethod(CtField field, CtClass clazz) throws NotFoundException {
        return clazz.getDeclaredMethod(FieldAccessTransformer.fieldWrite(field.getName()));
    }

    public void unwrap(CtClass clazz, Collection<Integer> fieldsGet, Collection<Integer> fieldsSet) throws CannotCompileException, NotFoundException {
        String target;
        CtMethod method;
        CtField field;
        List<CtField> advisableFields = Instrumentor.getAdvisableFields(clazz);
        CtField[] fields = new CtField[advisableFields.size()];
        fields = advisableFields.toArray(fields);
        for (int fieldIndex : fieldsGet) {
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared(field, 0)) continue;
            wrapper.unwrap(field, 0);
            method = clazz.getDeclaredMethod(FieldAccessTransformer.fieldRead(field.getName()));
            target = Modifier.isStatic(field.getModifiers()) ? clazz.getName() : "((" + clazz.getName() + ")$1)";
            method.setBody("return " + target + "." + field.getName() + ";");
        }
        for (int fieldIndex : fieldsSet) {
            field = fields[fieldIndex];
            if (wrapper.isNotPrepared(field, 1)) continue;
            wrapper.unwrap(field, 1);
            method = clazz.getDeclaredMethod(FieldAccessTransformer.fieldWrite(field.getName()));
            target = Modifier.isStatic(field.getModifiers()) ? clazz.getName() : "((" + clazz.getName() + ")$1)";
            method.setBody(target + "." + field.getName() + "=$2" + ";");
        }
    }

    @Override
    public void codeConverted() throws NotFoundException, CannotCompileException {
        this.codifier.codifyPending();
    }

    protected int fieldOffset(CtClass clazz) throws NotFoundException {
        if (clazz == null) {
            return 0;
        }
        if (clazz.getName().equals("java.lang.Object")) {
            return 0;
        }
        int offset = this.fieldOffset(clazz.getSuperclass());
        CtField[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Advisable.isAdvisable(fields[i])) continue;
            ++offset;
        }
        return offset;
    }

    protected String addFieldReadInfoFieldWithAccessors(int modifiers, CtClass addTo, CtField field) throws NotFoundException, CannotCompileException {
        return this.addFieldReadInfoFieldWithAccessors(modifiers, addTo, field, null);
    }

    protected String addFieldReadInfoFieldWithAccessors(int modifiers, CtClass addTo, CtField field, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        String name = FieldAccessTransformer.getFieldReadInfoFieldName(field.getName());
        TransformerCommon.addInfoField(this.instrumentor, FIELD_INFO_CLASS_NAME, name, modifiers, addTo, this.addInfoAsWeakReference(), init, this.markInfoAsSynthetic());
        return name;
    }

    protected String addFieldWriteInfoField(int modifiers, CtClass addTo, CtField field) throws NotFoundException, CannotCompileException {
        return this.addFieldWriteInfoField(modifiers, addTo, field, null);
    }

    protected String addFieldWriteInfoField(int modifiers, CtClass addTo, CtField field, CtField.Initializer init) throws NotFoundException, CannotCompileException {
        String name = FieldAccessTransformer.getFieldWriteInfoFieldName(field.getName());
        TransformerCommon.addInfoField(this.instrumentor, FIELD_INFO_CLASS_NAME, name, modifiers, addTo, this.addInfoAsWeakReference(), init, this.markInfoAsSynthetic());
        return name;
    }

    protected boolean addInfoAsWeakReference() {
        return true;
    }

    protected boolean markInfoAsSynthetic() {
        return true;
    }

    public static String getFieldReadInfoFieldName(String fieldName) {
        return "aop$FieldInfo_r_" + fieldName;
    }

    public static String getFieldWriteInfoFieldName(String fieldName) {
        return "aop$FieldInfo_w_" + fieldName;
    }

    public static String fieldRead(String fieldName) {
        return fieldName + "_r_" + "$aop";
    }

    public static String fieldWrite(String fieldName) {
        return fieldName + "_w_" + "$aop";
    }

    protected static String fieldInfoFromWeakReference(String localName, String fieldInfoName) {
        return TransformerCommon.infoFromWeakReference(FIELD_INFO_CLASS_NAME, localName, fieldInfoName);
    }

    protected int getStaticModifiers(CtField field) {
        int mod = 8;
        mod = (field.getModifiers() & 1) != 0 ? (mod |= 1) : ((field.getModifiers() & 4) != 0 ? (mod |= 4) : ((field.getModifiers() & 2) != 0 ? (mod |= 2) : (mod |= 1)));
        return mod;
    }

    protected abstract void replaceFieldAccessInternally(CtClass var1, CtField var2, boolean var3, boolean var4, int var5) throws CannotCompileException;

    protected void buildWrapperPlaceHolders(CtClass clazz, CtField field, boolean doGet, boolean doSet, int mod) throws NotFoundException, CannotCompileException {
        if (doGet) {
            this.buildReadWrapperPlaceHolder(clazz, field, FieldAccessTransformer.fieldRead(field.getName()), mod);
        }
        if (doSet) {
            this.buildWriteWrapperPlaceHolder(clazz, field, FieldAccessTransformer.fieldWrite(field.getName()), mod);
        }
    }

    protected CtMethod buildReadWrapperPlaceHolder(CtClass clazz, CtField field, String wrapperName, int mod) throws NotFoundException, CannotCompileException {
        AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
        CtClass ftype = field.getType();
        CtClass[] readParam = new CtClass[]{classPool.get("java.lang.Object")};
        String code = "{" + ftype.getName() + " var = ";
        if (ftype.isPrimitive()) {
            if (ftype == CtClass.booleanType) {
                code = code + false;
            } else if (ftype == CtClass.byteType) {
                code = code + "(byte)0";
            } else if (ftype == CtClass.charType) {
                code = code + "(char)0";
            } else if (ftype == CtClass.doubleType) {
                code = code + "0.0";
            } else if (ftype == CtClass.floatType) {
                code = code + "(float)0.0";
            } else if (ftype == CtClass.intType) {
                code = code + "0";
            } else if (ftype == CtClass.longType) {
                code = code + "(long)0";
            } else if (ftype == CtClass.shortType) {
                code = code + "(short)0";
            }
        } else {
            code = code + "null";
        }
        code = code + "; return var;}";
        CtMethod rmethod = CtNewMethod.make(ftype, wrapperName, readParam, null, code, clazz);
        rmethod.setModifiers(mod);
        Instrumentor.addSyntheticAttribute(rmethod);
        clazz.addMethod(rmethod);
        return rmethod;
    }

    protected CtMethod buildWriteWrapperPlaceHolder(CtClass clazz, CtField field, String wrapperName, int mod) throws NotFoundException, CannotCompileException {
        AOPClassPool classPool = (AOPClassPool)this.instrumentor.getClassPool();
        CtClass ftype = field.getType();
        CtClass[] writeParam = new CtClass[]{classPool.get("java.lang.Object"), ftype};
        CtMethod wmethod = CtNewMethod.make(CtClass.voidType, wrapperName, writeParam, null, "{}", clazz);
        wmethod.setModifiers(mod);
        Instrumentor.addSyntheticAttribute(wmethod);
        clazz.addMethod(wmethod);
        SignatureAttribute ai = (SignatureAttribute)field.getFieldInfo2().getAttribute("Signature");
        if (ai != null) {
            MethodInfo wrapperInfo = wmethod.getMethodInfo2();
            SignatureAttribute methodAtt = new SignatureAttribute(wrapperInfo.getConstPool(), "(" + ai.getSignature() + ")V");
            wrapperInfo.addAttribute(methodAtt);
        }
        return wmethod;
    }

    protected abstract String getWrapperBody(CtClass var1, CtField var2, boolean var3, int var4) throws NotFoundException, CannotCompileException;

    protected abstract class FieldAccessExprEditor
    extends ExprEditor {
        CtClass clazz;
        CtField field;
        boolean doGet;
        boolean doSet;
        int fieldIndex;

        public FieldAccessExprEditor(CtClass clazz, CtField field, boolean doGet, boolean doSet, int index) {
            this.clazz = clazz;
            this.field = field;
            this.doGet = doGet;
            this.doSet = doSet;
            this.fieldIndex = index;
        }

        public void edit(FieldAccess fieldAccess) throws CannotCompileException {
            if (!fieldAccess.getClassName().equals(this.clazz.getName())) {
                return;
            }
            if (!fieldAccess.getFieldName().equals(this.field.getName())) {
                return;
            }
            if (this.calledByInvocationClass(fieldAccess)) {
                return;
            }
            if (fieldAccess.isReader() && this.doGet) {
                this.replaceRead(fieldAccess);
            }
            if (fieldAccess.isWriter() && this.doSet) {
                this.replaceWrite(fieldAccess);
            }
        }

        private boolean calledByInvocationClass(FieldAccess fieldAccess) {
            try {
                return this.isInvocationClass(fieldAccess.where().getDeclaringClass());
            }
            catch (RuntimeException e) {
                return true;
            }
        }

        private boolean isInvocationClass(CtClass superClazz) {
            try {
                if (superClazz == null) {
                    return false;
                }
                if (superClazz.getName().equals("java.lang.Object")) {
                    return false;
                }
                if (superClazz.getName().equals("org.jboss.aop.joinpoint.Invocation")) {
                    return true;
                }
                return this.isInvocationClass(superClazz.getSuperclass());
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        protected abstract void replaceRead(FieldAccess var1) throws CannotCompileException;

        protected abstract void replaceWrite(FieldAccess var1) throws CannotCompileException;
    }
}

