/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedMethodInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.joinpoint.MethodCallByConstructor;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.util.ReflectToJavassist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodByConJoinPointGenerator
extends JoinPointGenerator {
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_MByC_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_MByC_";
    private static final Class<MethodCalledByConstructorInvocation> INVOCATION_TYPE = MethodCalledByConstructorInvocation.class;
    private static final Class<MethodCallByConstructor> JOINPOINT_TYPE = MethodCallByConstructor.class;
    private static final CtClass INVOCATION_CT_TYPE;
    boolean hasTargetObject;
    WeakReference<Class<?>> returnType;

    public MethodByConJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info, MethodByConJoinPointGenerator.getParameters((MethodByConInfo)info), ((MethodByConInfo)info).getMethod().getParameterTypes().length, false);
        if (!((MethodByConInfo)info).getMethod().getReturnType().equals(Void.TYPE)) {
            this.returnType = new WeakReference(((MethodByConInfo)info).getMethod().getReturnType());
        }
        this.hasTargetObject = !java.lang.reflect.Modifier.isStatic(((MethodByConInfo)info).getMethod().getModifiers());
    }

    private static JoinPointGenerator.JoinPointParameters getParameters(MethodByConInfo info) {
        if (Modifier.isStatic(info.getMethod().getModifiers())) {
            return JoinPointGenerator.JoinPointParameters.CALLER_ARGS;
        }
        return JoinPointGenerator.JoinPointParameters.TARGET_CALLER_ARGS;
    }

    @Override
    protected void initialiseJoinPointNames(JoinPointInfo info) {
        MethodByConInfo minfo = (MethodByConInfo)info;
        this.joinpointClassName = MethodByConJoinPointGenerator.getGeneratedJoinPointClassName(this.callingIndex(minfo), this.calledClass(minfo), this.calledMethodHash(minfo));
        this.joinpointFieldName = MethodByConJoinPointGenerator.getGeneratedJoinPointFieldName(this.callingIndex(minfo), this.calledClass(minfo), this.calledMethodHash(minfo));
    }

    private int callingIndex(MethodByConInfo info) {
        return info.getCallingIndex();
    }

    private String calledClass(MethodByConInfo info) {
        return info.getCalledClass().getName();
    }

    private long calledMethodHash(MethodByConInfo info) {
        return info.getCalledMethodHash();
    }

    @Override
    protected boolean isVoid() {
        return this.getReturnClassType() == null;
    }

    @Override
    protected Class<?> getReturnClassType() {
        if (this.returnType == null) {
            return null;
        }
        return (Class)this.returnType.get();
    }

    @Override
    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointBean joinPoint, JoinPointGenerator.AdviceSetup setup) {
        Method method = ((MethodCallByConstructor)joinPoint).getMethod();
        return new AdviceMethodProperties(joinPoint, setup.getAspectClass(), setup.getAdviceName(), JOINPOINT_TYPE, INVOCATION_TYPE, method.getGenericReturnType(), method.getGenericParameterTypes(), method.getParameterTypes(), method.getGenericExceptionTypes(), method.getDeclaringClass(), this.hasTargetObject(), ((MethodCallByConstructor)joinPoint).getCallingClass(), this.hasCallingObject());
    }

    @Override
    protected boolean isCaller() {
        return true;
    }

    @Override
    protected boolean hasCallingObject() {
        return true;
    }

    @Override
    protected boolean hasTargetObject() {
        return this.hasTargetObject;
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, int callingIndex, CtClass callingClass, CtMethod targetMethod, String classname, long calledHash, String ciname) throws NotFoundException, CannotCompileException {
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingIndex, classname, targetMethod, calledHash, ciname);
        return generator.generate();
    }

    protected static String getGeneratedJoinPointClassName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_CLASS_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    protected static String getGeneratedJoinPointFieldName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_FIELD_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass callingClass;
        int callingIndex;
        CtField callingField;
        CtClass targetClass;
        String classname;
        CtMethod targetMethod;
        long calledHash;
        String ciname;
        boolean hasTargetObject;
        CtClass jp;
        CtClass[] params;
        CtClass methodInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, int callingIndex, String classname, CtMethod targetMethod, long calledHash, String ciname) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.callingClass = callingClass;
            this.callingIndex = callingIndex;
            this.classname = classname;
            this.targetClass = instrumentor.forName(classname);
            this.targetMethod = targetMethod;
            this.calledHash = calledHash;
            this.ciname = ciname;
            this.params = targetMethod.getParameterTypes();
            this.methodInfoClass = instrumentor.forName(CallerTransformer.METHOD_BY_CON_INFO_CLASS_NAME);
            this.hasTargetObject = !Modifier.isStatic(targetMethod.getModifiers());
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            OptimizedBehaviourInvocations.addArgumentFieldsAndAccessors(this.instrumentor.getClassPool(), this.jp, this.params, false);
            if (this.hasTargetObject) {
                this.addTypedTargetField();
            }
            this.addTypedCallingField();
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructors();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = MethodByConJoinPointGenerator.getGeneratedJoinPointClassName(this.callingIndex, this.targetClass.getName(), this.calledHash);
            this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass invocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(invocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addTypedTargetField() throws CannotCompileException {
            CtField targetField = new CtField(this.targetClass, "typedTargetObject", this.jp);
            this.jp.addField(targetField);
            targetField.setModifiers(4);
        }

        private void addTypedCallingField() throws CannotCompileException {
            this.callingField = new CtField(this.callingClass, "typedCallingObject", this.jp);
            this.jp.addField(this.callingField);
            this.callingField.setModifiers(4);
        }

        private void addPublicConstructor() throws CannotCompileException {
            CtConstructor publicConstructor = CtNewConstructor.make(new CtClass[]{this.methodInfoClass}, new CtClass[0], "{super($1, null, null, $1.getInterceptors()); this.info = $1;}", this.jp);
            this.jp.addConstructor(publicConstructor);
        }

        protected void addProtectedConstructors() throws CannotCompileException {
            int offset = this.hasTargetObject ? 3 : 2;
            CtClass[] ctorParams1 = new CtClass[this.params.length + offset];
            CtClass[] ctorParams2 = new CtClass[offset];
            ctorParams1[0] = ctorParams2[0] = this.jp;
            if (this.hasTargetObject) {
                ctorParams1[1] = ctorParams2[1] = this.targetClass;
                ctorParams1[2] = ctorParams2[2] = this.callingClass;
            } else {
                ctorParams1[1] = ctorParams2[1] = this.callingClass;
            }
            System.arraycopy(this.params, 0, ctorParams1, offset, this.params.length);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            if (this.hasTargetObject) {
                body.append("   super.").append("targetObject").append("=$2;");
                body.append("   this.").append("typedTargetObject").append("=$2;");
                body.append("   super.").append("callingObject").append("=$3;");
                body.append("   this.").append(this.callingField.getName()).append("=$3;");
            } else {
                body.append("   super.").append("callingObject").append("=$2;");
                body.append("   this.").append(this.callingField.getName()).append("=$2;");
            }
            StringBuffer setArguments = new StringBuffer();
            for (int i = offset; i < ctorParams1.length; ++i) {
                setArguments.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            setArguments.append("}");
            CtConstructor protectedConstructor = CtNewConstructor.make(ctorParams1, new CtClass[0], body.toString() + setArguments.toString(), this.jp);
            protectedConstructor.setModifiers(4);
            this.jp.addConstructor(protectedConstructor);
            if (this.params.length > 0) {
                protectedConstructor = CtNewConstructor.make(ctorParams2, new CtClass[0], body.toString() + "}", this.jp);
                protectedConstructor.setModifiers(4);
                this.jp.addConstructor(protectedConstructor);
            }
        }

        private CtClass[] getInvokeJoinPointParameters() {
            if (this.hasTargetObject) {
                CtClass[] invokeParams = new CtClass[this.params.length + 2];
                invokeParams[0] = this.targetClass;
                invokeParams[1] = this.callingClass;
                System.arraycopy(this.params, 0, invokeParams, 2, this.params.length);
                return invokeParams;
            }
            CtClass[] invokeParams = new CtClass[this.params.length + 1];
            invokeParams[0] = this.callingClass;
            System.arraycopy(this.params, 0, invokeParams, 1, this.params.length);
            return invokeParams;
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            CtMethod invokeJoinpointMethod = CtNewMethod.make(this.targetMethod.getReturnType(), "invokeJoinpoint", this.getInvokeJoinPointParameters(), JoinPointGenerator.THROWS_THROWABLE, null, this.jp);
            invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(invokeJoinpointMethod);
            return invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
            infoField.setModifiers(4);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            OptimizedMethodInvocations.addDispatch(this.jp, "dispatch", this.targetMethod, !this.hasTargetObject);
            this.addInvokeJoinPointDispatchMethod();
            this.addInvokeTargetMethod();
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            int offset = this.hasTargetObject ? 2 : 1;
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + offset + 1));
            }
            StringBuffer body = new StringBuffer("{");
            if (Modifier.isStatic(this.targetMethod.getModifiers())) {
                body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
            } else {
                body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "$1." + this.targetMethod.getName() + "(" + parameters + ");");
            }
            body.append("}");
            try {
                CtMethod dispatch = CtNewMethod.make(isVoid ? CtClass.voidType : this.targetMethod.getReturnType(), "dispatch", this.getInvokeJoinPointParameters(), this.targetMethod.getExceptionTypes(), body.toString(), this.jp);
                dispatch.setModifiers(4);
                this.jp.addMethod(dispatch);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(this.jp, "dispatch", this.getInvokeJoinPointParameters()), e);
            }
        }

        private void addInvokeTargetMethod() throws CannotCompileException, NotFoundException {
            CtMethod template = INVOCATION_CT_TYPE.getDeclaredMethod("invokeTarget");
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            String body = isVoid ? "{dispatch(); return null;}" : "{return ($w)dispatch();}";
            CtMethod invokeTarget = CtNewMethod.make(template.getReturnType(), template.getName(), template.getParameterTypes(), template.getExceptionTypes(), body, this.jp);
            this.jp.addMethod(invokeTarget);
        }
    }
}

