/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class DefaultPropertyInfo
extends AbstractPropertyInfo {
    private static final long serialVersionUID = 1L;
    private MethodInfo getter;
    private MethodInfo setter;

    public DefaultPropertyInfo() {
        this(null, null, null, null, null);
    }

    public DefaultPropertyInfo(String name) {
        this(name, name, null, null, null);
    }

    public DefaultPropertyInfo(String name, String upperName, TypeInfo type, MethodInfo getter, MethodInfo setter) {
        super(name, upperName, type);
        this.getter = getter;
        this.setter = setter;
    }

    public DefaultPropertyInfo(String name, String upperName, TypeInfo type, MethodInfo getter, MethodInfo setter, AnnotationValue[] annotations) {
        super(name, upperName, type, annotations);
        this.getter = getter;
        this.setter = setter;
    }

    public MethodInfo getGetter() {
        return this.getter;
    }

    public void setGetter(MethodInfo getter) {
        this.getter = getter;
    }

    public MethodInfo getSetter() {
        return this.setter;
    }

    public void setSetter(MethodInfo setter) {
        this.setter = setter;
    }

    public boolean isReadable() {
        return this.getGetter() != null;
    }

    public boolean isWritable() {
        return this.getSetter() != null;
    }

    public Object get(Object bean) throws Throwable {
        if (bean == null) {
            throw new IllegalArgumentException("Null bean");
        }
        if (this.getter == null) {
            throw new IllegalArgumentException("Property is not readable: " + this.getName() + " for " + this.getBeanInfo().getName());
        }
        return this.getter.invoke(bean, null);
    }

    public void set(Object bean, Object value) throws Throwable {
        if (bean == null) {
            throw new IllegalArgumentException("Null bean");
        }
        if (this.setter == null) {
            throw new IllegalArgumentException("Property is not writable: " + this.getName() + " for " + this.getBeanInfo().getName());
        }
        this.setter.invoke(bean, new Object[]{value});
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object == null || !(object instanceof DefaultPropertyInfo)) {
            return false;
        }
        DefaultPropertyInfo other = (DefaultPropertyInfo)object;
        if (DefaultPropertyInfo.notEqual(this.getter, other.getter)) {
            return false;
        }
        return !DefaultPropertyInfo.notEqual(this.setter, other.setter);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" getter=").append(this.getter);
        buffer.append(" setter=").append(this.setter);
    }
}

