/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationInfoImpl;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.ArrayInfoImpl;
import org.jboss.reflect.plugins.ClassInfoHelper;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.EnumConstantInfoImpl;
import org.jboss.reflect.plugins.EnumInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.plugins.PackageInfoImpl;
import org.jboss.reflect.plugins.introspection.ParameterizedArrayInfo;
import org.jboss.reflect.plugins.introspection.ParameterizedClassInfo;
import org.jboss.reflect.plugins.introspection.ReflectClassInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectConstructorInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectFieldInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectMethodInfoImpl;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.NumberInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.collection.WeakTypeCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionTypeInfoFactoryImpl
extends WeakTypeCache<TypeInfo>
implements TypeInfoFactory,
AnnotationHelper,
ClassInfoHelper {
    static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];

    public void generateTypeInfo(Class<?> clazz, ClassInfoImpl info) {
    }

    @Override
    public ClassInfoImpl getSuperClass(ClassInfoImpl classInfo) {
        Class<? extends Object> superClazz;
        Class<? extends Object> clazz = classInfo.getType();
        ClassInfoImpl superType = null;
        if (!clazz.isInterface() && (superClazz = clazz.getSuperclass()) != null) {
            superType = (ClassInfoImpl)this.getTypeInfo(superClazz);
        }
        return superType;
    }

    @Override
    public ClassInfo getGenericSuperClass(ClassInfoImpl classInfo) {
        Type superClazz;
        Class<? extends Object> clazz = classInfo.getType();
        ClassInfo superType = null;
        if (!clazz.isInterface() && (superClazz = clazz.getGenericSuperclass()) != null) {
            superType = (ClassInfo)this.getTypeInfo(superClazz);
        }
        return superType;
    }

    @Override
    public AnnotationValue[] getAnnotations(Object obj) {
        if (!(obj instanceof AnnotatedElement)) {
            throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
        }
        Annotation[] annotations = this.readAnnotations((AnnotatedElement)obj);
        if (annotations.length == 0) {
            return NO_ANNOTATIONS;
        }
        AnnotationValue[] annotationValues = new AnnotationValue[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(annotations[i].annotationType());
            annotationValues[i] = this.createAnnotationValue(info, annotations[i]);
        }
        return annotationValues;
    }

    @Override
    public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann) {
        return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
    }

    @Override
    public ConstructorInfoImpl[] getConstructors(ClassInfoImpl classInfo) {
        Constructor<?>[] constructors;
        Class<? extends Object> clazz = classInfo.getType();
        ReflectConstructorInfoImpl[] infos = null;
        if (!clazz.isInterface() && (constructors = this.getDeclaredConstructors(clazz)) != null && constructors.length > 0) {
            infos = new ReflectConstructorInfoImpl[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                Class<?>[] parameterTypes;
                AnnotationValue[] annotations = this.getAnnotations(constructors[i]);
                Type[] genericParameterTypes = constructors[i].getGenericParameterTypes();
                if (genericParameterTypes.length != (parameterTypes = constructors[i].getParameterTypes()).length) {
                    genericParameterTypes = parameterTypes;
                }
                infos[i] = new ReflectConstructorInfoImpl(annotations, this.getTypeInfos(genericParameterTypes), this.getParameterAnnotations(constructors[i].getParameterAnnotations()), this.getClassInfos(constructors[i].getGenericExceptionTypes()), constructors[i].getModifiers(), (ClassInfo)this.getTypeInfo(constructors[i].getDeclaringClass()));
                infos[i].setConstructor(constructors[i]);
            }
        }
        return infos;
    }

    @Override
    public FieldInfoImpl[] getFields(final ClassInfoImpl classInfo) {
        return AccessController.doPrivileged(new PrivilegedAction<FieldInfoImpl[]>(){

            @Override
            public FieldInfoImpl[] run() {
                Class<? extends Object> clazz = classInfo.getType();
                Field[] fields = IntrospectionTypeInfoFactoryImpl.this.getDeclaredFields(clazz);
                if (fields == null || fields.length == 0) {
                    return null;
                }
                FieldInfoImpl[] infos = new ReflectFieldInfoImpl[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    AnnotationValue[] annotations = IntrospectionTypeInfoFactoryImpl.this.getAnnotations(fields[i]);
                    infos[i] = new ReflectFieldInfoImpl(annotations, fields[i].getName(), IntrospectionTypeInfoFactoryImpl.this.getTypeInfo(fields[i].getGenericType()), fields[i].getModifiers(), (ClassInfo)IntrospectionTypeInfoFactoryImpl.this.getTypeInfo(fields[i].getDeclaringClass()));
                    ((ReflectFieldInfoImpl)infos[i]).setField(fields[i]);
                }
                return infos;
            }
        });
    }

    @Override
    public MethodInfoImpl[] getMethods(final ClassInfoImpl classInfo) {
        return AccessController.doPrivileged(new PrivilegedAction<MethodInfoImpl[]>(){

            @Override
            public MethodInfoImpl[] run() {
                Class<? extends Object> clazz = classInfo.getType();
                Method[] methods = IntrospectionTypeInfoFactoryImpl.this.getDeclaredMethods(clazz);
                if (methods == null || methods.length == 0) {
                    return null;
                }
                MethodInfoImpl[] infos = new ReflectMethodInfoImpl[methods.length];
                for (int i = 0; i < methods.length; ++i) {
                    AnnotationValue[] annotations = IntrospectionTypeInfoFactoryImpl.this.getAnnotations(methods[i]);
                    infos[i] = new ReflectMethodInfoImpl(annotations, methods[i].getName(), IntrospectionTypeInfoFactoryImpl.this.getTypeInfo(methods[i].getGenericReturnType()), IntrospectionTypeInfoFactoryImpl.this.getTypeInfos(methods[i].getGenericParameterTypes()), IntrospectionTypeInfoFactoryImpl.this.getParameterAnnotations(methods[i].getParameterAnnotations()), IntrospectionTypeInfoFactoryImpl.this.getClassInfos(methods[i].getGenericExceptionTypes()), methods[i].getModifiers(), (ClassInfo)IntrospectionTypeInfoFactoryImpl.this.getTypeInfo(methods[i].getDeclaringClass()));
                    ((ReflectMethodInfoImpl)infos[i]).setMethod(methods[i]);
                }
                return infos;
            }
        });
    }

    @Override
    public InterfaceInfo[] getInterfaces(ClassInfoImpl classInfo) {
        Class<? extends Object> clazz = classInfo.getType();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return null;
        }
        InterfaceInfo[] infos = new InterfaceInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            infos[i] = (InterfaceInfo)this.getTypeInfo(interfaces[i]);
        }
        return infos;
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces(ClassInfoImpl classInfo) {
        Class<? extends Object> clazz = classInfo.getType();
        Type[] interfaces = clazz.getGenericInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return null;
        }
        InterfaceInfo[] infos = new InterfaceInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            infos[i] = (InterfaceInfo)this.getTypeInfo(interfaces[i]);
        }
        return infos;
    }

    @Override
    public PackageInfoImpl getPackage(ClassInfoImpl classInfo) {
        Class<? extends Object> clazz = classInfo.getType();
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            return null;
        }
        AnnotationValue[] annotations = this.getAnnotations(pkg);
        return new PackageInfoImpl(pkg.getName(), annotations);
    }

    public TypeInfo[] getTypeInfos(Type[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        TypeInfo[] result = new TypeInfo[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = this.getTypeInfo(classes[i]);
        }
        return result;
    }

    public ClassInfo[] getClassInfos(Type[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        ClassInfo[] result = new ClassInfo[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = (ClassInfo)this.getTypeInfo(classes[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeInfo getTypeInfo(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
        if (primitive != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(clazz.getName());
        if (number != null) {
            NumberInfo numberInfo = number;
            synchronized (numberInfo) {
                if (number.getPhase() != NumberInfo.Phase.INITIALIZING) {
                    if (number.getPhase() != NumberInfo.Phase.COMPLETE) {
                        number.initializing();
                        number.setDelegate((TypeInfo)this.get(clazz));
                    }
                    return number;
                }
            }
        }
        return (TypeInfo)this.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeInfo getTypeInfo(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        String name = null;
        if (type instanceof Class) {
            name = ((Class)type).getName();
        }
        if (name != null) {
            PrimitiveInfo primitive = PrimitiveInfo.valueOf(name);
            if (primitive != null) {
                return primitive;
            }
            NumberInfo number = NumberInfo.valueOf(name);
            if (number != null) {
                NumberInfo numberInfo = number;
                synchronized (numberInfo) {
                    if (number.getPhase() != NumberInfo.Phase.INITIALIZING) {
                        if (number.getPhase() != NumberInfo.Phase.COMPLETE) {
                            number.initializing();
                            number.setDelegate((TypeInfo)this.get(type));
                        }
                        return number;
                    }
                }
            }
        }
        return (TypeInfo)this.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null class name");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(name);
        if (primitive != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(name);
        if (number != null) {
            NumberInfo numberInfo = number;
            synchronized (numberInfo) {
                if (number.getPhase() != NumberInfo.Phase.INITIALIZING) {
                    if (number.getPhase() != NumberInfo.Phase.COMPLETE) {
                        number.initializing();
                        number.setDelegate(this.resolveComplexTypeInfo(cl, name));
                    }
                    return number;
                }
            }
        }
        return this.resolveComplexTypeInfo(cl, name);
    }

    @Override
    protected TypeInfo getGenericArrayType(GenericArrayType type) {
        Type compType = type.getGenericComponentType();
        TypeInfo componentType = this.getTypeInfo(compType);
        return new ArrayInfoImpl(componentType);
    }

    protected TypeInfo resolveComplexTypeInfo(ClassLoader cl, String name) throws ClassNotFoundException {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Class<?> clazz = Class.forName(name, false, cl);
        return this.getTypeInfo(clazz);
    }

    @Override
    protected TypeInfo instantiate(Class<?> clazz) {
        ClassInfoImpl result;
        if (clazz.isArray()) {
            TypeInfo componentType = this.getTypeInfo(clazz.getComponentType());
            result = new ArrayInfoImpl(componentType);
        } else if (clazz.isEnum()) {
            EnumInfoImpl enumInfoImpl = new EnumInfoImpl(clazz.getName(), clazz.getModifiers());
            result = enumInfoImpl;
            Field[] fields = clazz.getFields();
            EnumConstantInfoImpl[] constants = new EnumConstantInfoImpl[fields.length];
            int i = 0;
            for (Field field : fields) {
                AnnotationValue[] annotations = this.getAnnotations(field);
                constants[i++] = new EnumConstantInfoImpl(field.getName(), enumInfoImpl, annotations);
            }
            enumInfoImpl.setEnumConstants(constants);
        } else if (clazz.isAnnotation()) {
            result = new AnnotationInfoImpl(clazz.getName(), clazz.getModifiers());
            Method[] methods = this.getDeclaredMethods(clazz);
            AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
            for (int i = 0; i < methods.length; ++i) {
                atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), null);
            }
            ((AnnotationInfoImpl)result).setAttributes(atttributes);
        } else {
            result = new ReflectClassInfoImpl(clazz.getName());
        }
        result.setType(clazz);
        result.setTypeInfoFactory(this);
        result.setClassInfoHelper(this);
        result.setAnnotationHelper(this);
        return result;
    }

    @Override
    protected TypeInfo instantiate(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        ClassInfo rawTypeInfo = (ClassInfo)this.getTypeInfo(rawType);
        if (rawTypeInfo instanceof ArrayInfo) {
            return new ParameterizedArrayInfo(this, (ArrayInfo)rawTypeInfo, type);
        }
        return new ParameterizedClassInfo(this, rawTypeInfo, type);
    }

    @Override
    protected void generate(Class<?> clazz, TypeInfo result) {
        this.generateTypeInfo(clazz, (ClassInfoImpl)result);
    }

    @Override
    protected void generate(ParameterizedType type, TypeInfo result) {
    }

    protected Constructor<?>[] getDeclaredConstructors(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructors();
        }
        PrivilegedAction<Constructor<?>[]> action = new PrivilegedAction<Constructor<?>[]>(){

            @Override
            public Constructor<?>[] run() {
                return clazz.getDeclaredConstructors();
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected Field[] getDeclaredFields(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredFields();
        }
        PrivilegedAction<Field[]> action = new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected Method[] getDeclaredMethods(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        PrivilegedAction<Method[]> action = new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        };
        return AccessController.doPrivileged(action);
    }

    private Annotation[] readAnnotations(final AnnotatedElement ao) {
        if (System.getSecurityManager() == null) {
            return ao.getAnnotations();
        }
        PrivilegedAction<Annotation[]> action = new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return ao.getAnnotations();
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected AnnotationValue[][] getParameterAnnotations(Annotation[][] annotations) {
        AnnotationValue[][] annotationValues = new AnnotationValue[annotations.length][];
        for (int param = 0; param < annotations.length; ++param) {
            annotationValues[param] = new AnnotationValue[annotations[param].length];
            for (int ann = 0; ann < annotations[param].length; ++ann) {
                AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(annotations[param][ann].annotationType());
                annotationValues[param][ann] = this.createAnnotationValue(info, annotations[param][ann]);
            }
        }
        return annotationValues;
    }

    @Override
    public TypeInfo[] getActualTypeArguments(ParameterizedClassInfo classInfo) {
        ParameterizedType type = classInfo.parameterizedType;
        Type[] types = type.getActualTypeArguments();
        if (types == null) {
            return null;
        }
        TypeInfo[] result = new TypeInfo[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.getTypeInfo(types[i]);
        }
        return result;
    }

    @Override
    public TypeInfo getOwnerType(ParameterizedClassInfo classInfo) {
        ParameterizedType type = classInfo.parameterizedType;
        Type owner = type.getOwnerType();
        if (owner == null) {
            return null;
        }
        return this.getTypeInfo(owner);
    }

    @Override
    public TypeInfo getComponentType(ClassInfo classInfo) {
        if (!classInfo.isCollection()) {
            return null;
        }
        return this.findActualType(classInfo, Collection.class, 0);
    }

    @Override
    public TypeInfo getKeyType(ClassInfo classInfo) {
        if (!classInfo.isMap()) {
            return null;
        }
        return this.findActualType(classInfo, Map.class, 0);
    }

    @Override
    public TypeInfo getValueType(ClassInfo classInfo) {
        if (!classInfo.isMap()) {
            return null;
        }
        return this.findActualType(classInfo, Map.class, 1);
    }

    protected TypeInfo findActualType(ClassInfo classInfo, Class<?> reference, int parameter) {
        Type result;
        Type type = classInfo.getType();
        if (classInfo instanceof ParameterizedClassInfo) {
            type = ((ParameterizedClassInfo)classInfo).parameterizedType;
        }
        if ((result = IntrospectionTypeInfoFactoryImpl.locateActualType(reference, parameter, classInfo.getType(), type)) instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)result;
            result = typeVariable.getBounds()[0];
        }
        return this.getTypeInfo(result);
    }

    protected static Type locateActualType(Class reference, int parameter, Class clazz, Type type) {
        Type genericSuperClass;
        Type[] interfaces;
        if (reference.equals(clazz)) {
            if (type instanceof Class) {
                Class typeClass = (Class)type;
                return typeClass.getTypeParameters()[parameter];
            }
            ParameterizedType parameterized = (ParameterizedType)type;
            return parameterized.getActualTypeArguments()[parameter];
        }
        for (Type intf : interfaces = clazz.getGenericInterfaces()) {
            Class interfaceClass;
            if (intf instanceof Class) {
                interfaceClass = (Class)intf;
            } else if (intf instanceof ParameterizedType) {
                ParameterizedType interfaceType = (ParameterizedType)intf;
                interfaceClass = (Class)interfaceType.getRawType();
            } else {
                throw new IllegalStateException("Unexpected type " + intf.getClass());
            }
            Type result = null;
            if (reference.isAssignableFrom(interfaceClass) && (result = IntrospectionTypeInfoFactoryImpl.locateActualType(reference, parameter, interfaceClass, intf)) instanceof TypeVariable) {
                result = IntrospectionTypeInfoFactoryImpl.getParameter(clazz, type, (TypeVariable)result);
            }
            if (result == null) continue;
            return result;
        }
        Class superClass = clazz.getSuperclass();
        Type result = IntrospectionTypeInfoFactoryImpl.locateActualType(reference, parameter, superClass, genericSuperClass = clazz.getGenericSuperclass());
        if (result instanceof TypeVariable) {
            result = IntrospectionTypeInfoFactoryImpl.getParameter(clazz, type, (TypeVariable)result);
        }
        return result;
    }

    private static Type getParameter(Class<?> clazz, Type type, TypeVariable<?> variable) {
        TypeVariable<Class<?>>[] variables = clazz.getTypeParameters();
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].getName().equals(variable.getName())) continue;
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterized = (ParameterizedType)type;
                return parameterized.getActualTypeArguments()[i];
            }
            return variable;
        }
        return Object.class;
    }
}

