/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.annotatedAdviceParams;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.joinpoint.Construction;
import org.jboss.aop.joinpoint.ConstructorCallByConstructor;
import org.jboss.aop.joinpoint.ConstructorCallByMethod;
import org.jboss.aop.joinpoint.ConstructorExecution;
import org.jboss.aop.joinpoint.FieldAccess;
import org.jboss.aop.joinpoint.JoinPointBean;
import org.jboss.aop.joinpoint.MethodCallByConstructor;
import org.jboss.aop.joinpoint.MethodCallByMethod;
import org.jboss.aop.joinpoint.MethodExecution;
import org.jboss.aop.util.MethodHashing;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.annotatedAdviceParams.JoinPointAspect;
import org.jboss.test.aop.annotatedAdviceParams.JoinPointPOJO;
import org.jboss.test.aop.annotatedAdviceParams.POJOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinPointTestCase
extends AOPTestWithSetup {
    private JoinPointPOJO pojo;

    public static void main(String[] args) {
        TestRunner.run((Test)JoinPointTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("JoinPointTestCase");
        suite.addTestSuite(JoinPointTestCase.class);
        return suite;
    }

    public JoinPointTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        JoinPointAspect.clear();
        this.pojo = new JoinPointPOJO();
    }

    public void tearDown() throws Exception {
        JoinPointBean joinPoint = JoinPointAspect.beforeJoinPoint;
        if (joinPoint == null && (joinPoint = JoinPointAspect.afterJoinPoint) == null && (joinPoint = JoinPointAspect.throwingJoinPoint) == null) {
            joinPoint = JoinPointAspect.finallyJoinPoint;
        }
        if (joinPoint != null) {
            JoinPointTestCase.assertSame((Object)((Advised)this.pojo)._getAdvisor(), (Object)joinPoint.getAdvisor());
            JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getClazz());
        }
        super.tearDown();
    }

    public void testFieldWrite1() {
        this.pojo.number = 0;
        JoinPointTestCase.assertEquals((String)"before1", (String)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertEquals((String)"after1", (String)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.afterJoinPoint instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)JoinPointAspect.afterJoinPoint;
        JoinPointTestCase.assertEquals((String)"number", (String)fieldAccess.getField().getName());
        JoinPointTestCase.assertFalse((boolean)fieldAccess.isRead());
    }

    public void testFieldWrite2() {
        this.pojo.text = "test2";
        JoinPointTestCase.assertEquals((String)"before2", (String)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertEquals((String)"finally1", (String)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertSame((Object)JoinPointAspect.beforeJoinPoint, (Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.beforeJoinPoint instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertEquals((String)"text", (String)fieldAccess.getField().getName());
        JoinPointTestCase.assertFalse((boolean)fieldAccess.isRead());
    }

    public void testFieldWrite3() {
        String text = this.pojo.text;
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertEquals((String)"after5", (String)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.afterJoinPoint instanceof FieldAccess));
        FieldAccess fieldAccess = (FieldAccess)JoinPointAspect.afterJoinPoint;
        JoinPointTestCase.assertEquals((String)"text", (String)fieldAccess.getField().getName());
        JoinPointTestCase.assertTrue((boolean)fieldAccess.isRead());
    }

    public void testMethodExecution1() throws Exception {
        this.pojo.method1();
        JoinPointTestCase.assertEquals((String)"before3", (String)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertEquals((String)"after3", (String)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.beforeJoinPoint instanceof MethodExecution));
        MethodExecution joinPoint = (MethodExecution)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertEquals((String)"method1", (String)joinPoint.getMethod().getName());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getHash());
    }

    public void testMethodExecution2() throws Exception {
        this.pojo.method2(false);
        JoinPointTestCase.assertEquals((String)"before4", (String)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertEquals((String)"after4", (String)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertSame((Object)JoinPointAspect.beforeJoinPoint, (Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.beforeJoinPoint instanceof MethodExecution));
        MethodExecution joinPoint = (MethodExecution)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertEquals((String)"method2", (String)joinPoint.getMethod().getName());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getHash());
    }

    public void testMethodExecutionException1() throws Exception {
        boolean exceptionThrown = false;
        try {
            this.pojo.method2(true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        JoinPointTestCase.assertEquals((String)"before4", (String)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertEquals((String)"throwing1", (String)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertSame((Object)JoinPointAspect.beforeJoinPoint, (Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.beforeJoinPoint instanceof MethodExecution));
        MethodExecution joinPoint = (MethodExecution)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertEquals((String)"method2", (String)joinPoint.getMethod().getName());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getHash());
    }

    public void testMethodExecutionException2() throws Exception {
        boolean exceptionThrown = false;
        try {
            this.pojo.method3();
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        JoinPointTestCase.assertEquals((String)"before4", (String)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertEquals((String)"finally2", (String)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.beforeJoinPoint instanceof MethodExecution));
        MethodExecution joinPoint = (MethodExecution)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertEquals((String)"method3", (String)joinPoint.getMethod().getName());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getHash());
    }

    public void testMethodExecutionException3() throws Exception {
        boolean exceptionThrown = false;
        try {
            this.pojo.method4();
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertEquals((String)"throwing3", (String)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertEquals((String)"finally3", (String)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertSame((Object)JoinPointAspect.throwingJoinPoint, (Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.throwingJoinPoint instanceof MethodExecution));
        MethodExecution joinPoint = (MethodExecution)JoinPointAspect.throwingJoinPoint;
        JoinPointTestCase.assertEquals((String)"method4", (String)joinPoint.getMethod().getName());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getHash());
    }

    public void testMethodExecutionException4() {
        boolean exceptionThrown = false;
        try {
            this.pojo.method5();
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertEquals((String)"throwing4", (String)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
    }

    public void testMethodExecutionException5() throws Exception {
        boolean exceptionThrown = false;
        try {
            this.pojo.method6();
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertEquals((String)"throwing5", (String)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
        JoinPointTestCase.assertTrue((boolean)(JoinPointAspect.throwingJoinPoint instanceof MethodExecution));
        MethodExecution joinPoint = (MethodExecution)JoinPointAspect.throwingJoinPoint;
        JoinPointTestCase.assertEquals((String)"method6", (String)joinPoint.getMethod().getName());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getHash());
    }

    public void testConstructorCallByConstructor() throws POJOException {
        new JoinPointPOJO(11, false);
        this.assertFullInterception(ConstructorCallByConstructor.class, "before6", "after4", "finally5", false);
        ConstructorCallByConstructor joinPoint = (ConstructorCallByConstructor)JoinPointAspect.beforeJoinPoint;
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingConstructor().getDeclaringClass());
        Class<?>[] callerParameters = joinPoint.getCallingConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Integer.TYPE, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
    }

    public void testConstructorCallByConstructorException() {
        boolean exceptionThrown = false;
        try {
            new JoinPointPOJO(12, true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(ConstructorCallByConstructor.class, "before6", "throwing6", "finally5", exceptionThrown);
        ConstructorCallByConstructor joinPoint = (ConstructorCallByConstructor)JoinPointAspect.beforeJoinPoint;
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingConstructor().getDeclaringClass());
        Class<?>[] callerParameters = joinPoint.getCallingConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Integer.TYPE, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
    }

    public void testConstructorCallByMethod() throws Exception {
        this.pojo.callConstructor(false);
        this.assertFullInterception(ConstructorCallByMethod.class, "before3", "after5", "finally6", false);
        ConstructorCallByMethod joinPoint = (ConstructorCallByMethod)JoinPointAspect.beforeJoinPoint;
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"callConstructor", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testConstructorCallByMethodException() throws Exception {
        boolean exceptionThrown = false;
        try {
            this.pojo.callConstructor(true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(ConstructorCallByMethod.class, "before3", "throwing7", "finally6", true);
        ConstructorCallByMethod joinPoint = (ConstructorCallByMethod)JoinPointAspect.beforeJoinPoint;
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"callConstructor", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testConstructorCallByStaticMethod() throws Exception {
        JoinPointPOJO.staticCallConstructor(false);
        this.assertFullInterception(ConstructorCallByMethod.class, "before3", "after5", "finally6", false);
        ConstructorCallByMethod joinPoint = (ConstructorCallByMethod)JoinPointAspect.beforeJoinPoint;
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"staticCallConstructor", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testConstructorCallByStaticMethodException() throws Exception {
        boolean exceptionThrown = false;
        try {
            JoinPointPOJO.staticCallConstructor(true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(ConstructorCallByMethod.class, "before3", "throwing7", "finally6", exceptionThrown);
        ConstructorCallByMethod joinPoint = (ConstructorCallByMethod)JoinPointAspect.beforeJoinPoint;
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"staticCallConstructor", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testMethodCallByConstructor() throws Exception {
        new JoinPointPOJO(false, false);
        this.assertFullInterception(MethodCallByConstructor.class, "before7", "after6", "finally3", false);
        MethodCallByConstructor joinPoint = (MethodCallByConstructor)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingConstructor().getDeclaringClass());
        Class<?>[] callerParameters = joinPoint.getCallingConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
    }

    public void testMethodCallByConstructorException() throws Exception {
        boolean exceptionThrown = false;
        try {
            new JoinPointPOJO(true, true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(MethodCallByConstructor.class, "before7", "throwing8", "finally3", exceptionThrown);
        MethodCallByConstructor joinPoint = (MethodCallByConstructor)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingConstructor().getDeclaringClass());
        Class<?>[] callerParameters = joinPoint.getCallingConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
    }

    public void testMethodCallByMethod() throws Exception {
        this.pojo.callMethod(false);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "after6", "finally7", false);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"callMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testMethodCallByMethodException() throws Exception {
        boolean exceptionThrown = false;
        try {
            this.pojo.callMethod(true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "throwing8", "finally7", exceptionThrown);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"callMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testMethodCallByStaticMethod() throws Exception {
        JoinPointPOJO.staticCallMethod(this.pojo, false);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "after6", "finally7", false);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"staticCallMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testMethodCallByStaticMethodException() throws Exception {
        boolean exceptionThrown = false;
        try {
            JoinPointPOJO.staticCallMethod(this.pojo, true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "throwing8", "finally7", exceptionThrown);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"staticCallMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testStaticMethodCallByConstructor() throws Exception {
        new JoinPointPOJO('a', false);
        this.assertFullInterception(MethodCallByConstructor.class, "before7", "after6", "finally3", false);
        MethodCallByConstructor joinPoint = (MethodCallByConstructor)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledStaticMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingConstructor().getDeclaringClass());
        Class<?>[] callerParameters = joinPoint.getCallingConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Character.TYPE, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
    }

    public void testStaticMethodCallByConstructorException() throws Exception {
        boolean exceptionThrown = false;
        try {
            new JoinPointPOJO('b', true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(MethodCallByConstructor.class, "before7", "throwing8", "finally3", exceptionThrown);
        MethodCallByConstructor joinPoint = (MethodCallByConstructor)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledStaticMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingConstructor().getDeclaringClass());
        Class<?>[] callerParameters = joinPoint.getCallingConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Character.TYPE, callerParameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[1]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
    }

    public void testStaticMethodCallByMethod() throws Exception {
        this.pojo.callStaticMethod(false);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "after6", "finally7", false);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledStaticMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"callStaticMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testStaticMethodCallByMethodException() throws Exception {
        boolean exceptionThrown = false;
        try {
            this.pojo.callStaticMethod(true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "throwing8", "finally7", exceptionThrown);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledStaticMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"callStaticMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testStaticMethodCallByStaticMethod() throws Exception {
        JoinPointPOJO.staticCallStaticMethod(false);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "after6", "finally7", false);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledStaticMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"staticCallStaticMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testStaticMethodCallByStaticMethodException() throws Exception {
        boolean exceptionThrown = false;
        try {
            JoinPointPOJO.staticCallStaticMethod(true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(MethodCallByMethod.class, "before8", "throwing8", "finally7", exceptionThrown);
        MethodCallByMethod joinPoint = (MethodCallByMethod)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame((Object)"calledStaticMethod", (Object)joinPoint.getMethod().getName());
        Class<?>[] parameters = joinPoint.getMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)parameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getMethod().getDeclaringClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCalledClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, (Object)joinPoint.getCallingClass());
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getCallingMethod().getDeclaringClass());
        JoinPointTestCase.assertSame((Object)"staticCallStaticMethod", (Object)joinPoint.getCallingMethod().getName());
        Class<?>[] callerParameters = joinPoint.getCallingMethod().getParameterTypes();
        JoinPointTestCase.assertEquals((int)1, (int)callerParameters.length);
        JoinPointTestCase.assertSame(Boolean.TYPE, callerParameters[0]);
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getMethod()), (long)joinPoint.getCalledMethodHash());
        JoinPointTestCase.assertEquals((long)MethodHashing.methodHash((Method)joinPoint.getCallingMethod()), (long)joinPoint.getCallingMethodHash());
    }

    public void testConstructorExecution() throws POJOException {
        new JoinPointPOJO(5, false);
        this.assertFullInterception(ConstructorExecution.class, "before2", "after7", "finally7", false);
        ConstructorExecution joinPoint = (ConstructorExecution)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)parameters.length);
        JoinPointTestCase.assertSame(Short.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[1]);
    }

    public void testConstructorExecutionException() {
        boolean exceptionThrown = false;
        try {
            new JoinPointPOJO(15, true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        this.assertFullInterception(ConstructorExecution.class, "before2", "throwing2", "finally7", exceptionThrown);
        ConstructorExecution joinPoint = (ConstructorExecution)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)parameters.length);
        JoinPointTestCase.assertSame(Short.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[1]);
    }

    public void testConstruction() throws POJOException {
        new JoinPointPOJO(5.0f, false);
        this.assertFullInterception(Construction.class, "before3", "after5", "finally8", false);
        Construction joinPoint = (Construction)JoinPointAspect.beforeJoinPoint;
        JoinPointTestCase.assertSame(JoinPointPOJO.class, joinPoint.getConstructor().getDeclaringClass());
        Class<?>[] parameters = joinPoint.getConstructor().getParameterTypes();
        JoinPointTestCase.assertEquals((int)2, (int)parameters.length);
        JoinPointTestCase.assertSame(Float.TYPE, parameters[0]);
        JoinPointTestCase.assertSame(Boolean.TYPE, parameters[1]);
    }

    public void testConstructionException() {
        boolean exceptionThrown = false;
        try {
            new JoinPointPOJO(51.0f, true);
        }
        catch (POJOException e) {
            exceptionThrown = true;
        }
        JoinPointTestCase.assertTrue((boolean)exceptionThrown);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNull((Object)JoinPointAspect.finallyJoinPoint);
    }

    private void assertFullInterception(Class<? extends JoinPointBean> expectedType, String beforeAdvice, String afterAdvice, String finallyAdvice, boolean exceptionThrown) {
        JoinPointBean afterJoinPoint = null;
        JoinPointTestCase.assertEquals((String)beforeAdvice, (String)JoinPointAspect.beforeAdvice);
        if (exceptionThrown) {
            JoinPointTestCase.assertNull((Object)JoinPointAspect.afterAdvice);
            JoinPointTestCase.assertNull((Object)JoinPointAspect.afterJoinPoint);
            JoinPointTestCase.assertEquals((String)afterAdvice, (String)JoinPointAspect.throwingAdvice);
            afterJoinPoint = JoinPointAspect.throwingJoinPoint;
        } else {
            JoinPointTestCase.assertEquals((String)afterAdvice, (String)JoinPointAspect.afterAdvice);
            afterJoinPoint = JoinPointAspect.afterJoinPoint;
            JoinPointTestCase.assertNull((String)afterAdvice, (Object)JoinPointAspect.throwingAdvice);
            JoinPointTestCase.assertNull((Object)JoinPointAspect.throwingJoinPoint);
        }
        JoinPointTestCase.assertEquals((String)finallyAdvice, (String)JoinPointAspect.finallyAdvice);
        JoinPointTestCase.assertNotNull((Object)JoinPointAspect.beforeJoinPoint);
        JoinPointTestCase.assertTrue((boolean)expectedType.isAssignableFrom(JoinPointAspect.beforeJoinPoint.getClass()));
        JoinPointTestCase.assertSame((Object)JoinPointAspect.beforeJoinPoint, (Object)afterJoinPoint);
        JoinPointTestCase.assertSame((Object)afterJoinPoint, (Object)JoinPointAspect.finallyJoinPoint);
    }
}

