/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.basic;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.metadata.ThreadMetaData;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.basic.AfterInterceptor;
import org.jboss.test.aop.basic.BeforeInterceptor;
import org.jboss.test.aop.basic.CFlowedPOJO;
import org.jboss.test.aop.basic.CallerInterceptor;
import org.jboss.test.aop.basic.CallerTypedefCaller;
import org.jboss.test.aop.basic.CallingPOJO;
import org.jboss.test.aop.basic.EmptyInterface;
import org.jboss.test.aop.basic.ExecutionTypedefPOJO;
import org.jboss.test.aop.basic.ExecutionTypedefPOJO2;
import org.jboss.test.aop.basic.ExecutionTypedefPOJO3;
import org.jboss.test.aop.basic.Implements1;
import org.jboss.test.aop.basic.Implements2;
import org.jboss.test.aop.basic.InstanceOfInterceptor;
import org.jboss.test.aop.basic.InterceptorCounter;
import org.jboss.test.aop.basic.InterfaceMixin;
import org.jboss.test.aop.basic.InterfaceUsedInHasImpl;
import org.jboss.test.aop.basic.Introduction;
import org.jboss.test.aop.basic.Introduction2;
import org.jboss.test.aop.basic.MixedParametersPOJO;
import org.jboss.test.aop.basic.NamedInterceptor;
import org.jboss.test.aop.basic.NoInterceptorsPOJO;
import org.jboss.test.aop.basic.NotAllAdvisedFieldsPOJO;
import org.jboss.test.aop.basic.NotPOJO;
import org.jboss.test.aop.basic.POJO;
import org.jboss.test.aop.basic.POJOAspectTester;
import org.jboss.test.aop.basic.POJOChild;
import org.jboss.test.aop.basic.POJOConstructorTest;
import org.jboss.test.aop.basic.POJOMethodInterceptor;
import org.jboss.test.aop.basic.POJORef;
import org.jboss.test.aop.basic.POJOWildCardConstructorTest;
import org.jboss.test.aop.basic.PrivatePOJO;
import org.jboss.test.aop.basic.SimpleInterceptor;
import org.jboss.test.aop.basic.SomeException;
import org.jboss.test.aop.basic.SubclassInterfaceUsedInHasImpl;
import org.jboss.test.aop.basic.SubclassIntroduction;

public class AOPTester
extends AOPTestWithSetup {
    public static void main(String[] args) {
        TestRunner.run((Test)AOPTester.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AOPTester");
        suite.addTestSuite(AOPTester.class);
        return suite;
    }

    public AOPTester(String name) {
        super(name);
    }

    public void testBasic() {
        System.out.println("RUNNING TEST BASIC");
        try {
            POJO pojo = new POJO();
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            pojo.someMethod();
            if (!"someMethod".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            InstanceOfInterceptor.intercepted = false;
            Implements1 impl1 = new Implements1();
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("failed all(instanceof) constructor interception");
            }
            InstanceOfInterceptor.intercepted = false;
            impl1.foo = 1;
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("failed all(instanceof) field interception");
            }
            InstanceOfInterceptor.intercepted = false;
            impl1.someMethod();
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("failed all(instanceof) method interception");
            }
            InstanceOfInterceptor.intercepted = false;
            Implements2 impl2 = new Implements2();
            if (InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("failed method only (instanceof) constructor interception");
            }
            InstanceOfInterceptor.intercepted = false;
            impl2.someMethod();
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("failed method only(instanceof) method interception");
            }
            InstanceOfInterceptor.intercepted = false;
            CFlowedPOJO cflow = new CFlowedPOJO();
            InterceptorCounter.count = 0;
            cflow.method3();
            if (InterceptorCounter.count > 0) {
                throw new RuntimeException("method3 count should be null");
            }
            InterceptorCounter.count = 0;
            cflow.method1();
            if (InterceptorCounter.count != 1) {
                throw new RuntimeException("method1 count should be 1");
            }
            InterceptorCounter.count = 0;
            cflow.recursive(1);
            if (InterceptorCounter.count == 0) {
                throw new RuntimeException("recursive never get intercepted");
            }
            if (InterceptorCounter.count > 1) {
                throw new RuntimeException("recursive too many interceptions");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void testInheritance() {
        System.out.println("RUNNING TEST INHERITANCE");
        try {
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            POJOChild pojo = new POJOChild();
            pojo.someMethod2();
            if (!"someMethod2".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            pojo.someMethod();
            if (!"someMethod".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void testMetadata() {
        System.out.println("RUNNING TEST METADATA");
        try {
            POJOChild pojo = new POJOChild();
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            pojo.someMethod();
            if (!"someMethod".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            pojo.anotherMethod();
            if (!"anotherMethod".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"Required".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            pojo.someMethod2();
            if (!"someMethod2".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            pojo.someMethod3();
            if (!"someMethod3".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"Supports".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            ThreadMetaData.instance().addMetaData((Object)"transaction", (Object)"trans-attribute", (Object)"Never");
            pojo.someMethod3();
            if (!"someMethod3".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"Never".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            ThreadMetaData.instance().clear();
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            InstanceAdvisor instanceAdvisor = ((Advised)pojo)._getInstanceAdvisor();
            instanceAdvisor.getMetaData().addMetaData((Object)"transaction", (Object)"trans-attribute", (Object)"NotSupported");
            pojo.someMethod3();
            if (!"someMethod3".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"NotSupported".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            ThreadMetaData.instance().clear();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void testDynamicInterceptors() {
        System.out.println("RUNNING TEST DYNAMIC INTERCEPTORS");
        try {
            POJOChild pojo = new POJOChild();
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            BeforeInterceptor.lastIntercepted = null;
            BeforeInterceptor.lastTransAttributeAccessed = null;
            ((Advised)pojo)._getInstanceAdvisor().insertInterceptor((Interceptor)new BeforeInterceptor());
            pojo.someMethod();
            if (!"someMethod".equals(SimpleInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(SimpleInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            if (!"someMethod".equals(BeforeInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(BeforeInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            SimpleInterceptor.lastIntercepted = null;
            SimpleInterceptor.lastTransAttributeAccessed = null;
            BeforeInterceptor.lastIntercepted = null;
            BeforeInterceptor.lastTransAttributeAccessed = null;
            AfterInterceptor.lastIntercepted = null;
            AfterInterceptor.lastTransAttributeAccessed = null;
            ((Advised)pojo)._getInstanceAdvisor().appendInterceptor((Interceptor)new AfterInterceptor());
            pojo.someMethod();
            if (!"someMethod".equals(BeforeInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(BeforeInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            if (!"someMethod".equals(AfterInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"RequiresNew".equals(AfterInterceptor.lastTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void testFieldInterception() {
        System.out.println("RUNNING TEST FIELD INTERCEPTION");
        try {
            POJO pojo = new POJO();
            SimpleInterceptor.lastFieldIntercepted = null;
            SimpleInterceptor.lastFieldTransAttributeAccessed = null;
            pojo.accessField();
            if (!"privateField".equals(SimpleInterceptor.lastFieldIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"NotSupported".equals(SimpleInterceptor.lastFieldTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            POJOChild child = new POJOChild();
            SimpleInterceptor.lastFieldIntercepted = null;
            SimpleInterceptor.lastFieldTransAttributeAccessed = null;
            child.accessField();
            if (!"privateField".equals(SimpleInterceptor.lastFieldIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"NotSupported".equals(SimpleInterceptor.lastFieldTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            SimpleInterceptor.lastFieldIntercepted = null;
            SimpleInterceptor.lastFieldTransAttributeAccessed = null;
            child.accessProtectedField();
            if (!"protectedField".equals(SimpleInterceptor.lastFieldIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"Supports".equals(SimpleInterceptor.lastFieldTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            POJORef ref = new POJORef();
            SimpleInterceptor.lastFieldIntercepted = null;
            SimpleInterceptor.lastFieldTransAttributeAccessed = null;
            ref.refPOJO();
            if (!"protectedField".equals(SimpleInterceptor.lastFieldIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"Supports".equals(SimpleInterceptor.lastFieldTransAttributeAccessed)) {
                throw new RuntimeException("Failed on metadata test");
            }
            pojo.accessStaticField();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void testMethodInterception() {
        System.out.println("RUNNING METHOD INTERCEPTION");
        try {
            PrivatePOJO priv = new PrivatePOJO();
            SimpleInterceptor.lastIntercepted = null;
            priv.callPrivate();
            if (SimpleInterceptor.lastIntercepted == null) {
                throw new RuntimeException("unable to intercept private method");
            }
            POJO.staticMethod();
            POJOConstructorTest vanilla = new POJOConstructorTest();
            vanilla.data = "error";
            vanilla.someMethod();
            if (!vanilla.data.equals("someMethod")) {
                throw new RuntimeException("someMethod() didn't get correct method metadata");
            }
            vanilla.data = "error";
            vanilla.another();
            if (!vanilla.data.equals("another()")) {
                throw new RuntimeException("another() didn't get correct method metadata: " + vanilla.data);
            }
            vanilla.data = "nothing";
            POJOMethodInterceptor.wasHit = false;
            vanilla.another(1);
            if (POJOMethodInterceptor.wasHit) {
                throw new RuntimeException("interceptor should not have been called");
            }
            if (!vanilla.data.equals("nothing")) {
                throw new RuntimeException("another(int) shouldn't get intercepted: " + vanilla.data);
            }
            vanilla.data = "nothing";
            vanilla.another(1, 1);
            if (!vanilla.data.equals("another(int, int)")) {
                throw new RuntimeException("another(int, int) didn't get intercepted: " + vanilla.data);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void testAspect() {
        System.out.println("RUNNING ASPECT TEST");
        try {
            POJO.staticMethod();
            POJOAspectTester vanilla = new POJOAspectTester();
            if (!vanilla.marker.equals("interceptConstructor")) {
                throw new RuntimeException("vanilla constructor didn't get intercepted");
            }
            vanilla.marker = "error";
            vanilla.someMethod();
            if (!vanilla.marker.equals("interceptMethod")) {
                throw new RuntimeException("vanilla.someMethod() didn't get intercepted");
            }
            vanilla.marker = "error";
            vanilla.field = 5;
            if (!vanilla.marker.equals("interceptField")) {
                throw new RuntimeException("vanilla.field  didn't get intercepted");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void testConstructorInterception() {
        System.out.println("RUNNING CONSTRUCTOR INTERCEPTION");
        try {
            POJO pojo = new POJO();
            System.out.println("pojo=" + pojo);
            POJOChild child = new POJOChild();
            System.out.println("child=" + child);
            POJORef ref = new POJORef();
            ref.constructPOJO();
            POJOWildCardConstructorTest wild = new POJOWildCardConstructorTest();
            if (wild == null) {
                throw new RuntimeException("wild was null!");
            }
            if (wild.data.equals("error")) {
                throw new RuntimeException("wild() didn't intercept");
            }
            wild = new POJOWildCardConstructorTest(1);
            if (wild.data.equals("error")) {
                throw new RuntimeException("wild(int) didn't intercept");
            }
            POJOConstructorTest vanilla = new POJOConstructorTest();
            if (vanilla == null) {
                throw new RuntimeException("vanilla was null!");
            }
            System.out.println("calling vanilla.data.equals");
            if (vanilla.data.equals("error")) {
                throw new RuntimeException("vanilla() didn't intercept");
            }
            if (!vanilla.data.equals("empty")) {
                throw new RuntimeException("vanilla() didn't get correct constructor metadata");
            }
            vanilla = new POJOConstructorTest(1, 1);
            if (vanilla.data.equals("error")) {
                throw new RuntimeException("vanilla(int, int) didn't intercept");
            }
            if (!vanilla.data.equals("int, int")) {
                throw new RuntimeException("vanilla(int, int) didn't get correct constructor metadata");
            }
            vanilla = new POJOConstructorTest(1);
            if (!vanilla.data.equals("error")) {
                throw new RuntimeException("vanilla(int) did intercept when it shouldn't have");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void testExceptions() {
        Object pojo;
        System.out.println("TEST AOP EXCEPTIONS");
        try {
            pojo = new NoInterceptorsPOJO();
            ((NoInterceptorsPOJO)pojo).throwException();
        }
        catch (SomeException ignored) {
            System.out.println("caught SomeException successfully");
        }
        try {
            pojo = new POJO();
            ((POJO)pojo).throwException();
        }
        catch (SomeException ignored) {
            System.out.println("caught SomeException successfully");
        }
    }

    public void testMixin() {
        try {
            System.out.println("TEST MIXIN");
            POJO pojo = new POJO();
            System.out.println("TEST Introduction");
            Introduction intro = (Introduction)((Object)pojo);
            System.out.println(intro.helloWorld("world"));
            System.out.println("TEST Introduction2");
            Introduction2 intro2 = (Introduction2)((Object)pojo);
            System.out.println(intro2.goodbye("world"));
            System.out.println("TEST InterfaceMixin");
            InterfaceMixin mixin = (InterfaceMixin)((Object)pojo);
            System.out.println(mixin.whazup());
            POJOChild child = new POJOChild();
            System.out.println("TEST child Introduction");
            intro = (Introduction)((Object)child);
            System.out.println(intro.helloWorld("world"));
            System.out.println("TEST child Introduction2");
            intro2 = (Introduction2)((Object)child);
            System.out.println(intro2.goodbye("world"));
            System.out.println("TEST child AnotherIntroduction");
            SubclassIntroduction sub = (SubclassIntroduction)((Object)child);
            System.out.println(sub.subclassHelloWorld("world"));
            System.out.println("TEST metadata introduction pointcut");
            NoInterceptorsPOJO nopojo = new NoInterceptorsPOJO();
            Introduction introduction = (Introduction)((Object)nopojo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void testInstanceMixin() throws Exception {
        try {
            AfterInterceptor.lastIntercepted = null;
            AfterInterceptor.lastTransAttributeAccessed = null;
            BeforeInterceptor.lastIntercepted = null;
            BeforeInterceptor.lastTransAttributeAccessed = null;
            System.out.println("TEST INSTANCE MIXIN");
            POJO pojo = new POJO();
            ((Advised)pojo)._getInstanceAdvisor().insertInterceptor((Interceptor)new BeforeInterceptor());
            Introduction intro = (Introduction)((Object)pojo);
            System.out.println(intro.helloWorld("world"));
            if (!"helloWorld".equals(BeforeInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            AfterInterceptor.lastIntercepted = null;
            AfterInterceptor.lastTransAttributeAccessed = null;
            BeforeInterceptor.lastIntercepted = null;
            BeforeInterceptor.lastTransAttributeAccessed = null;
            ((Advised)pojo)._getInstanceAdvisor().appendInterceptor((Interceptor)new AfterInterceptor());
            System.out.println(intro.helloWorld("world"));
            if (!"helloWorld".equals(BeforeInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"helloWorld".equals(AfterInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            AfterInterceptor.lastIntercepted = null;
            AfterInterceptor.lastTransAttributeAccessed = null;
            BeforeInterceptor.lastIntercepted = null;
            BeforeInterceptor.lastTransAttributeAccessed = null;
            POJOChild child = new POJOChild();
            ((Advised)child)._getInstanceAdvisor().insertInterceptor((Interceptor)new BeforeInterceptor());
            ((Advised)child)._getInstanceAdvisor().appendInterceptor((Interceptor)new AfterInterceptor());
            Introduction2 intro2 = (Introduction2)((Object)child);
            System.out.println(intro2.goodbye("world"));
            if (!"goodbye".equals(BeforeInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
            if (!"goodbye".equals(AfterInterceptor.lastIntercepted)) {
                throw new RuntimeException("Failed on interception test");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void testCallerPointcut() {
        CallingPOJO callingPOJO = new CallingPOJO();
        callingPOJO.callSomeMethod();
        callingPOJO.nocallSomeMethod();
        callingPOJO.callUnadvised();
    }

    public void testNot() {
        System.out.println("TEST !STATIC in pointcut expression");
        NotPOJO pojo = new NotPOJO();
        CallerInterceptor.called = false;
        pojo.hello();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("should have intercepted NotPOJO.hello()");
        }
        CallerInterceptor.called = false;
        NotPOJO.world();
        if (CallerInterceptor.called) {
            throw new RuntimeException("should not have intercepted NotPOJO.world()");
        }
    }

    public void testInterfaceUsedInHas() {
        System.out.println("TEST Interface used in has");
        SubclassInterfaceUsedInHasImpl pojo = new SubclassInterfaceUsedInHasImpl();
        Class<InterfaceUsedInHasImpl> clazz = InterfaceUsedInHasImpl.class;
        System.out.println(clazz.getName() + " methods=" + Arrays.asList(clazz.getDeclaredMethods()));
        clazz = SubclassInterfaceUsedInHasImpl.class;
        System.out.println(clazz.getName() + " methods=" + Arrays.asList(clazz.getDeclaredMethods()));
        CallerInterceptor.called = false;
        System.out.println("About to invoke pojo.someMethod()");
        pojo.someMethod();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("should have intercepted InterfaceUsedInHas.someMethod()");
        }
        CallerInterceptor.called = false;
        System.out.println("About to invoke pojo.someOtherMethod()");
        pojo.someOtherMethod();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("should have intercepted SubclassInterfaceUsedInHasImpl.someOtherMethod()");
        }
    }

    public void testTypedefExecution() {
        System.out.println("RUNNING TEST TYPEDEF EXECUTION");
        System.out.println("intercept class constructor");
        CallerInterceptor.called = false;
        ExecutionTypedefPOJO pojo = new ExecutionTypedefPOJO();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO constructor");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept class field read");
        int i = pojo.field1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO.field1 read " + i);
        }
        CallerInterceptor.called = false;
        System.out.println("intercept class field write");
        pojo.field1 = 1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO.field1 write");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept class field read");
        i = pojo.field2;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO.field2 read");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept class field write");
        pojo.field2 = 1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO.field1 write");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept class method execution");
        pojo.method();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO.method() execution");
        }
        CallerInterceptor.called = false;
        try {
            Serializable ser = (Serializable)((Object)pojo);
            System.out.println(ser);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("ExecutionTypedefPOJO does not implement serializable");
        }
        try {
            EmptyInterface ei = (EmptyInterface)((Object)pojo);
            System.out.println(ei);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("ExecutionTypedefPOJO does not implement EmptyInterface");
        }
        try {
            Introduction intro = (Introduction)((Object)pojo);
            intro.helloWorld("lalala");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("ExecutionTypedefPOJO does not implement Introduction");
        }
        System.out.println("intercept instanceof constructor");
        ExecutionTypedefPOJO2 pojo2 = new ExecutionTypedefPOJO2();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO2 constructor");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept instanceof field read");
        i = pojo2.field1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO2.field1 read");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept instanceof field write");
        pojo2.field1 = 1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO2.field1 write");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept instanceof field read");
        i = pojo2.field2;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO2.field2 read");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept instanceof field write");
        pojo2.field2 = 1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO2.field1 write");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept instanceof method execution");
        pojo2.method();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO2 method execution");
        }
        CallerInterceptor.called = false;
        try {
            Serializable ser = (Serializable)((Object)pojo);
            System.out.println("Serializable " + ser);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("ExecutionTypedefPOJO2 does not implement serializable");
        }
        System.out.println("intercept annotation constructor");
        ExecutionTypedefPOJO3 pojo3 = new ExecutionTypedefPOJO3();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO3 constructor");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept annotation field read");
        i = pojo3.field1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO3.field1 read");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept annotation field write");
        pojo3.field1 = 1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO3.field1 write");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept annotation field read");
        i = pojo3.field2;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO3.field2 read");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept annotation field write");
        pojo3.field2 = 1;
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO3.field2 write");
        }
        CallerInterceptor.called = false;
        System.out.println("intercept annotation method execution");
        pojo3.method();
        if (!CallerInterceptor.called) {
            throw new RuntimeException("Did not intercept ExecutionTypedefPOJO3 method execution");
        }
        try {
            Serializable ser = (Serializable)((Object)pojo);
            System.out.println(ser);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("ExecutionTypedefPOJO does not implement serializable");
        }
    }

    public void testTypedefCaller() {
        System.out.println("RUNNING TEST TYPEDEF CALLER");
        CallerTypedefCaller caller = new CallerTypedefCaller();
        caller.call();
    }

    public void testPointcutExceptions() {
        System.out.println("RUNNING TEST POINTCUT EXCEPTIONS");
        try {
            InstanceOfInterceptor.intercepted = false;
            POJO pojo = new POJO(1);
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("Constructor not intercepted");
            }
            InstanceOfInterceptor.intercepted = false;
            pojo.withSomeException();
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("Method 1) not intercepted");
            }
            InstanceOfInterceptor.intercepted = false;
            pojo.withExceptionAndOthers("h");
            if (InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("Method 2) intercepted");
            }
            InstanceOfInterceptor.intercepted = false;
            pojo.withExceptionAndOthers(1);
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("Method 3) not intercepted");
            }
            InstanceOfInterceptor.intercepted = false;
            pojo.withClassCastException(1);
            if (!InstanceOfInterceptor.intercepted) {
                throw new RuntimeException("Method 4) not intercepted");
            }
        }
        catch (NotSerializableException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
        catch (SomeException e) {
            throw new RuntimeException(e);
        }
    }

    public void testPointcutExceptionsCaller() {
        System.out.println("RUNNING TEST POINTCUT EXCEPTIONS CALLER");
        CallingPOJO callingPOJO = new CallingPOJO();
        callingPOJO.callUnadvisedWithPointcutException();
    }

    public void testNotAllAdvisedFields() {
        System.out.println("RUNNING TEST NOT ALL ADVISED FIELDS");
        NotAllAdvisedFieldsPOJO pojo = new NotAllAdvisedFieldsPOJO();
        SimpleInterceptor.lastFieldIntercepted = null;
        AOPTester.assertEquals((int)5, (int)pojo.notadvised);
        AOPTester.assertNull((Object)SimpleInterceptor.lastFieldIntercepted);
        SimpleInterceptor.lastFieldIntercepted = null;
        AOPTester.assertEquals((int)10, (int)pojo.thisisadvised);
        AOPTester.assertEquals((String)"thisisadvised", (String)SimpleInterceptor.lastFieldIntercepted);
        SimpleInterceptor.lastFieldIntercepted = null;
        pojo.thisisadvised = 20;
        AOPTester.assertEquals((String)"thisisadvised", (String)SimpleInterceptor.lastFieldIntercepted);
        AOPTester.assertEquals((int)20, (int)pojo.thisisadvised);
    }

    public void testMixWildCardsAndSpecifiedParameters() {
        NamedInterceptor.invoked.clear();
        MixedParametersPOJO pojo = new MixedParametersPOJO(1, "5", 6L);
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("A"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("B"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("C"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("D"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("E"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("F"));
        AOPTester.assertFalse((String)"Didn't find NotBound", (boolean)NamedInterceptor.invoked.contains("NotBound"));
        NamedInterceptor.invoked.clear();
        pojo.method(1, "5", 6, "X");
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("A"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("B"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("C"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("D"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("E"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("F"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("G"));
        AOPTester.assertTrue((String)"Found A", (boolean)NamedInterceptor.invoked.contains("H"));
        AOPTester.assertFalse((String)"Didn't find NotBound", (boolean)NamedInterceptor.invoked.contains("NotBound"));
    }

    public void testInstanceAdvisorGetInstance() {
        POJO pojo1 = new POJO();
        POJO pojo2 = new POJO();
        InstanceAdvisor ia1 = ((InstanceAdvised)pojo1)._getInstanceAdvisor();
        AOPTester.assertNotNull((Object)ia1);
        InstanceAdvisor ia2 = ((InstanceAdvised)pojo2)._getInstanceAdvisor();
        AOPTester.assertNotNull((Object)ia2);
        Object instance1 = ia1.getInstance();
        AOPTester.assertNotNull((Object)instance1);
        AOPTester.assertSame((Object)pojo1, (Object)instance1);
        Object instance2 = ia2.getInstance();
        AOPTester.assertNotNull((Object)instance2);
        AOPTester.assertSame((Object)pojo2, (Object)instance2);
    }
}

