/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.jdk15.dynamic.common.scenario;

import java.util.Map;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.test.aop.jdk15.dynamic.common.BindingInterceptor;
import org.jboss.test.aop.jdk15.dynamic.common.InstanceInterceptor;
import org.jboss.test.aop.jdk15.dynamic.common.POJOWrappingInfo;
import org.jboss.test.aop.jdk15.dynamic.common.scenario.POJO;

public class ScenarioRunner {
    private static final AdviceBinding constructorExecution;
    private static final AdviceBinding methodExecution;
    private static final AdviceBinding fieldRead;
    private static final AdviceBinding fieldWrite;
    private static CtClass POJO_CLASS;
    private static CtField FIELD;
    private static CtMethod METHOD;
    private static String NOT_ADVISED_METHOD;
    private static CtClass POJO_CLIENT;
    private int instancesCollected = 0;

    public ScenarioRunner() {
        InstanceInterceptor.resetCounts();
        BindingInterceptor.resetCounts();
    }

    public POJOWrappingInfo[] interceptPerClassLoadBefore() throws Exception {
        POJOWrappingInfo[] wrappingInfos = new POJOWrappingInfo[3];
        this.executeJoinpoints(false);
        wrappingInfos[0] = ScenarioRunner.getCurrentWrappingInfo();
        this.addBindings();
        wrappingInfos[1] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(false);
        this.removeBindings();
        wrappingInfos[2] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(false);
        return wrappingInfos;
    }

    private static POJOWrappingInfo getCurrentWrappingInfo() throws Exception {
        return new POJOWrappingInfo(POJO_CLASS, FIELD, METHOD, NOT_ADVISED_METHOD, POJO_CLIENT);
    }

    public POJOWrappingInfo[] interceptPerClassLoadAfter() throws Exception {
        POJOWrappingInfo[] wrappingInfos = new POJOWrappingInfo[2];
        this.addBindings();
        this.executeJoinpoints(false);
        this.executeJoinpoints(false);
        wrappingInfos[0] = ScenarioRunner.getCurrentWrappingInfo();
        this.removeBindings();
        wrappingInfos[1] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(false);
        return wrappingInfos;
    }

    public POJOWrappingInfo[] addAndRemoveBindingTwice() throws Exception {
        POJOWrappingInfo[] wrappingInfos = new POJOWrappingInfo[5];
        this.executeJoinpoints(false);
        wrappingInfos[0] = ScenarioRunner.getCurrentWrappingInfo();
        this.addBindings();
        wrappingInfos[1] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(false);
        this.removeBindings();
        wrappingInfos[2] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(false);
        this.addBindings();
        wrappingInfos[3] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(false);
        this.removeBindings();
        wrappingInfos[4] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(false);
        return wrappingInfos;
    }

    public POJOWrappingInfo[] executeAfterBindingRemoval() throws Exception {
        this.addBindings();
        this.removeBindings();
        this.executeJoinpoints(false);
        return new POJOWrappingInfo[]{ScenarioRunner.getCurrentWrappingInfo()};
    }

    public POJOWrappingInfo[] interceptPerInstance() throws Exception {
        this.executeJoinpoints(false);
        POJOWrappingInfo[] wrappingInfos = new POJOWrappingInfo[2];
        wrappingInfos[0] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(true);
        wrappingInfos[1] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(true);
        return wrappingInfos;
    }

    public POJOWrappingInfo[] interceptPerInstanceGC() throws Exception {
        this.instancesCollected = 0;
        this.executeJoinpoints(false);
        POJOWrappingInfo[] wrappingInfos = new POJOWrappingInfo[3];
        wrappingInfos[0] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(true);
        wrappingInfos[1] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(true);
        while (this.instancesCollected < 3) {
            for (int i = 0; i < 10000; ++i) {
                String string = new String("any string to fill memory space...");
            }
            System.gc();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected exception, e");
            }
        }
        this.executeJoinpoints(false);
        this.executeJoinpoints(false);
        wrappingInfos[2] = ScenarioRunner.getCurrentWrappingInfo();
        return wrappingInfos;
    }

    public POJOWrappingInfo[] interceptPerClassPerInstance() throws Exception {
        this.executeJoinpoints(false);
        POJOWrappingInfo[] wrappingInfos = new POJOWrappingInfo[3];
        wrappingInfos[0] = ScenarioRunner.getCurrentWrappingInfo();
        this.addBindings();
        wrappingInfos[1] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(true);
        wrappingInfos[2] = ScenarioRunner.getCurrentWrappingInfo();
        this.removeBindings();
        this.executeJoinpoints(false);
        return wrappingInfos;
    }

    public POJOWrappingInfo[] interceptPerInstancePerClass() throws Exception {
        this.executeJoinpoints(true);
        this.executeJoinpoints(true);
        POJOWrappingInfo[] wrappingInfos = new POJOWrappingInfo[3];
        wrappingInfos[0] = ScenarioRunner.getCurrentWrappingInfo();
        this.addBindings();
        wrappingInfos[1] = ScenarioRunner.getCurrentWrappingInfo();
        this.executeJoinpoints(true);
        wrappingInfos[2] = ScenarioRunner.getCurrentWrappingInfo();
        this.removeBindings();
        this.executeJoinpoints(false);
        return wrappingInfos;
    }

    void pojoCollected() {
        ++this.instancesCollected;
    }

    private void executeJoinpoints(boolean interceptInstance) {
        POJO pojo = new POJO(this);
        InstanceInterceptor instanceInterceptor = null;
        if (interceptInstance) {
            instanceInterceptor = new InstanceInterceptor();
            Advised advised = (Advised)pojo;
            advised._getInstanceAdvisor().insertInterceptor((Interceptor)instanceInterceptor);
        }
        ++pojo.counter;
        pojo.someMethod();
        if (POJO_CLASS == null) {
            ScenarioRunner.loadPOJOData();
        }
    }

    private static void loadPOJOData() {
        Map cls = AspectManager.getRegisteredCLs();
        AOPClassPool classPool = (AOPClassPool)cls.get(POJO.class.getClassLoader());
        try {
            POJO_CLASS = classPool.getLocally(POJO.class.getName());
            FIELD = POJO_CLASS.getDeclaredField("counter");
            METHOD = POJO_CLASS.getDeclaredMethod("someMethod");
            NOT_ADVISED_METHOD = ClassAdvisor.notAdvisedMethodName((String)POJO.class.getName(), (String)METHOD.getName());
            POJO_CLIENT = classPool.getLocally(ScenarioRunner.class.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    void addBindings() {
        AspectManager aspectManager = AspectManager.instance();
        aspectManager.addBinding(constructorExecution);
        aspectManager.addBinding(fieldRead);
        aspectManager.addBinding(fieldWrite);
        aspectManager.addBinding(methodExecution);
    }

    private void removeBindings() {
        AspectManager aspectManager = AspectManager.instance();
        aspectManager.removeBinding(constructorExecution.getName());
        aspectManager.removeBinding(fieldRead.getName());
        aspectManager.removeBinding(fieldWrite.getName());
        aspectManager.removeBinding(methodExecution.getName());
    }

    static {
        try {
            constructorExecution = new AdviceBinding("execution(*.POJO->new(..))", null);
            constructorExecution.addInterceptor(BindingInterceptor.class);
            fieldRead = new AdviceBinding("get(public int *.POJO->counter)", null);
            fieldRead.addInterceptor(BindingInterceptor.class);
            fieldWrite = new AdviceBinding("set(public int *.POJO->counter)", null);
            fieldWrite.addInterceptor(BindingInterceptor.class);
            methodExecution = new AdviceBinding("execution(public void *.POJO->someMethod())", null);
            methodExecution.addInterceptor(BindingInterceptor.class);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }
}

