/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.proxy;

import java.io.Externalizable;
import java.lang.annotation.Annotation;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.proxy.AnnotationImpl;
import org.jboss.test.aop.proxy.Mixin;
import org.jboss.test.aop.proxy.MixinInterface;
import org.jboss.test.aop.proxy.OtherMixin;
import org.jboss.test.aop.proxy.OtherMixinInterface;
import org.jboss.test.aop.proxy.SomeInterface;

public class SerializeContainerProxyCacheKeyTestCase
extends AOPTestWithSetup {
    public SerializeContainerProxyCacheKeyTestCase(String arg0) {
        super(arg0);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("SerializeContainerProxyCacheKeyTestCase");
        suite.addTestSuite(SerializeContainerProxyCacheKeyTestCase.class);
        return suite;
    }

    public void testSerializeKeyNoMetaData() throws Exception {
        ContainerProxyCacheKey original1 = new ContainerProxyCacheKey("/", SerializeContainerProxyCacheKeyTestCase.class, new Class[]{Externalizable.class, SomeInterface.class}, this.getMixins(), null);
        ContainerProxyCacheKey original2 = new ContainerProxyCacheKey("/", SerializeContainerProxyCacheKeyTestCase.class, new Class[]{Externalizable.class}, this.getMixins(), null);
        SerializeContainerProxyCacheKeyTestCase.assertFalse((boolean)original1.equals((Object)original2));
        MarshalledObject<ContainerProxyCacheKey> mo1 = new MarshalledObject<ContainerProxyCacheKey>(original1);
        MarshalledObject<ContainerProxyCacheKey> mo2 = new MarshalledObject<ContainerProxyCacheKey>(original2);
        ContainerProxyCacheKey deserialized1 = mo1.get();
        ContainerProxyCacheKey deserialized2 = mo2.get();
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)original1, (Object)deserialized1);
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)deserialized1, (Object)original1);
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)original2, (Object)deserialized2);
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)deserialized2, (Object)original2);
        SerializeContainerProxyCacheKeyTestCase.assertFalse((boolean)deserialized1.equals((Object)deserialized2));
    }

    public void testEqualsMetaDataNotSerialized() {
        MetaData md = this.getMetaData("A", "testEqualsMetaDataNotSerialized");
        ContainerProxyCacheKey original1 = new ContainerProxyCacheKey("/", SerializeContainerProxyCacheKeyTestCase.class, new Class[]{Externalizable.class, SomeInterface.class}, this.getMixins(), md);
        ContainerProxyCacheKey original2 = new ContainerProxyCacheKey("/", SerializeContainerProxyCacheKeyTestCase.class, new Class[]{Externalizable.class, SomeInterface.class}, this.getMixins(), md);
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)original1, (Object)original2);
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)original2, (Object)original1);
        ContainerProxyCacheKey original3 = new ContainerProxyCacheKey("/", SerializeContainerProxyCacheKeyTestCase.class, new Class[]{Externalizable.class, SomeInterface.class}, this.getMixins(), null);
        SerializeContainerProxyCacheKeyTestCase.assertFalse((boolean)original1.equals((Object)original3));
        MetaData md2 = this.getMetaData("A", "testEqualsMetaDataNotSerialized2");
        ContainerProxyCacheKey original4 = new ContainerProxyCacheKey("/", SerializeContainerProxyCacheKeyTestCase.class, new Class[]{Externalizable.class, SomeInterface.class}, this.getMixins(), md2);
        SerializeContainerProxyCacheKeyTestCase.assertFalse((boolean)original1.equals((Object)original4));
    }

    public void testSerializeKeyWithMetaData() throws Exception {
        MetaData md = this.getMetaData("A", "testSerializeKeyWithMetaData");
        ContainerProxyCacheKey original1 = new ContainerProxyCacheKey("/", SerializeContainerProxyCacheKeyTestCase.class, new Class[]{Externalizable.class, SomeInterface.class}, this.getMixins(), md);
        MarshalledObject<ContainerProxyCacheKey> mo1 = new MarshalledObject<ContainerProxyCacheKey>(original1);
        ContainerProxyCacheKey deserialized1 = mo1.get();
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)original1, (Object)deserialized1);
        SerializeContainerProxyCacheKeyTestCase.assertEquals((Object)deserialized1, (Object)original1);
    }

    private MetaData getMetaData(String app, String instance) {
        BasicMetaDataRepository repository = new BasicMetaDataRepository();
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.add(new Scope(CommonLevels.APPLICATION, (Object)app));
        scopes.add(new Scope(CommonLevels.INSTANCE, (Object)instance));
        ScopeKey scopeKey = new ScopeKey(scopes);
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(scopeKey);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader);
        loader.addAnnotation((Annotation)new AnnotationImpl());
        MetaData md = repository.getMetaData(scopeKey);
        return md;
    }

    private AOPProxyFactoryMixin[] getMixins() {
        AOPProxyFactoryMixin[] mixins = new AOPProxyFactoryMixin[]{new AOPProxyFactoryMixin(Mixin.class, new Class[]{MixinInterface.class}, "abc"), new AOPProxyFactoryMixin(OtherMixin.class, new Class[]{OtherMixinInterface.class})};
        return mixins;
    }
}

