/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.rebuildingchain;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.rebuildingchain.ConstructorExecutionSyncThread;
import org.jboss.test.aop.rebuildingchain.FieldReadSyncThread;
import org.jboss.test.aop.rebuildingchain.FieldWriteSyncThread;
import org.jboss.test.aop.rebuildingchain.MethodExecutionSyncThread;
import org.jboss.test.aop.rebuildingchain.RebuildThread;
import org.jboss.test.aop.rebuildingchain.StaticFieldReadSyncThread;
import org.jboss.test.aop.rebuildingchain.StaticFieldWriteSyncThread;
import org.jboss.test.aop.rebuildingchain.StaticMethodExecutionSyncThread;
import org.jboss.test.aop.rebuildingchain.SyncThread;

public class RebuildingChainTestCase
extends AOPTestWithSetup {
    private static boolean failed = false;

    public RebuildingChainTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("RebuildingChainTestCase");
        suite.addTestSuite(RebuildingChainTestCase.class);
        return suite;
    }

    public void setUp() throws Exception {
        failed = false;
        super.setUp();
    }

    public void testFieldReadWithSetDone() throws Exception {
        this.assertRebuildingChainWithSetDone(new FieldReadSyncThread(), "get(int org.jboss.test.aop.rebuildingchain.FieldReadSyncThread->field)", "FieldRead");
    }

    public void testFieldReadWithJoin() throws Exception {
        this.assertRebuildingChainWithJoin(new FieldReadSyncThread(), "get(int org.jboss.test.aop.rebuildingchain.FieldReadSyncThread->field)", "FieldRead");
    }

    public void testStaticFieldReadWithSetDone() throws Exception {
        this.assertRebuildingChainWithSetDone(new StaticFieldReadSyncThread(), "get(int org.jboss.test.aop.rebuildingchain.StaticFieldReadSyncThread->field)", "StaticFieldRead");
    }

    public void testStaticFieldReadWithJoin() throws Exception {
        this.assertRebuildingChainWithJoin(new StaticFieldReadSyncThread(), "get(int org.jboss.test.aop.rebuildingchain.StaticFieldReadSyncThread->field)", "StaticFieldRead");
    }

    public void testFieldWriteWithSetDone() throws Exception {
        this.assertRebuildingChainWithSetDone(new FieldWriteSyncThread(), "set(int org.jboss.test.aop.rebuildingchain.FieldWriteSyncThread->field)", "FieldWrite");
    }

    public void testFieldWriteWithJoin() throws Exception {
        this.assertRebuildingChainWithJoin(new FieldWriteSyncThread(), "set(int org.jboss.test.aop.rebuildingchain.FieldWriteSyncThread->field)", "FieldWrite");
    }

    public void testStaticFieldWriteWithSetDone() throws Exception {
        this.assertRebuildingChainWithSetDone(new StaticFieldWriteSyncThread(), "set(int org.jboss.test.aop.rebuildingchain.StaticFieldWriteSyncThread->field)", "StaticFieldWrite");
    }

    public void testStaticFieldWriteWithJoin() throws Exception {
        this.assertRebuildingChainWithJoin(new StaticFieldWriteSyncThread(), "set(int org.jboss.test.aop.rebuildingchain.StaticFieldWriteSyncThread->field)", "StaticFieldWrite");
    }

    public void testConstructorExecutionWithSetDone() throws Exception {
        this.assertRebuildingChainWithSetDone(new ConstructorExecutionSyncThread(), "execution(org.jboss.test.aop.rebuildingchain.ConstructorExecutionSyncThread$Pojo->new())", "ConstructorExecution");
    }

    public void testConstructorExecutionWithJoin() throws Exception {
        this.assertRebuildingChainWithJoin(new ConstructorExecutionSyncThread(), "execution(org.jboss.test.aop.rebuildingchain.ConstructorExecutionSyncThread$Pojo->new())", "ConstructorExecution");
    }

    public void testMethodExecutionWithSetDone() throws Exception {
        this.assertRebuildingChainWithSetDone(new MethodExecutionSyncThread(), "execution(* org.jboss.test.aop.rebuildingchain.MethodExecutionSyncThread->method())", "MethodExecution");
    }

    public void testMethodExecutionWithJoin() throws Exception {
        this.assertRebuildingChainWithJoin(new MethodExecutionSyncThread(), "execution(* org.jboss.test.aop.rebuildingchain.MethodExecutionSyncThread->method())", "MethodExecution");
    }

    public void testStaticMethodExecutionWithSetDone() throws Exception {
        this.assertRebuildingChainWithSetDone(new StaticMethodExecutionSyncThread(), "execution(* org.jboss.test.aop.rebuildingchain.StaticMethodExecutionSyncThread->method())", "StaticMethodExecution");
    }

    public void testStaticMethodExecutionWithJoin() throws Exception {
        this.assertRebuildingChainWithJoin(new StaticMethodExecutionSyncThread(), "execution(* org.jboss.test.aop.rebuildingchain.StaticMethodExecutionSyncThread->method())", "StaticMethodExecution");
    }

    private void assertRebuildingChainWithSetDone(SyncThread st, String pointcutExpression, String bindingPrefix) throws Exception {
        RebuildThread rt = this.startThreads(st, pointcutExpression, bindingPrefix);
        Thread.sleep(200L);
        st.setDone(true);
        rt.setDone(true);
        rt.unlinkAdvice();
        RebuildingChainTestCase.assertFalse((String)"Failed to match pointcut when rebuilding the chain....", (boolean)failed);
    }

    private void assertRebuildingChainWithJoin(SyncThread st, String pointcutExpression, String bindingPrefix) throws Exception {
        RebuildThread rt = this.startThreads(st, pointcutExpression, bindingPrefix + "Join");
        st.join();
        rt.join();
        rt.unlinkAdvice();
        RebuildingChainTestCase.assertFalse((String)"Failed to match pointcut when rebuilding the chain....", (boolean)failed);
    }

    private RebuildThread startThreads(SyncThread st, String pointcutExpression, String bindingPrefix) throws Exception {
        System.out.println("testing rebuildingchain!");
        RebuildThread rt = new RebuildThread(pointcutExpression, bindingPrefix);
        rt.linkNewAdvice();
        Thread.sleep(20L);
        rt.start();
        st.start();
        return rt;
    }

    public static void setTestFailed() {
        failed = true;
    }
}

