/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.typedAdvices;

import org.jboss.aop.advice.NoMatchingAdviceException;
import org.jboss.test.aop.AOPTestWithSetup;
import org.jboss.test.aop.typedAdvices.ArgsAspect;
import org.jboss.test.aop.typedAdvices.GeneralAspect;
import org.jboss.test.aop.typedAdvices.InvalidAdviceNamePOJO;
import org.jboss.test.aop.typedAdvices.InvalidPOJO;
import org.jboss.test.aop.typedAdvices.POJO;
import org.jboss.test.aop.typedAdvices.SimpleAspect;
import org.jboss.test.aop.typedAdvices.SubValue;
import org.jboss.test.aop.typedAdvices.SuperValue;
import org.jboss.test.aop.typedAdvices.TestException;

public class BeforeAfterThrowingTestCase
extends AOPTestWithSetup {
    public BeforeAfterThrowingTestCase(String arg0) {
        super(arg0);
    }

    public void testSimple() throws Exception {
        System.out.println("=== TESING SIMPLE");
        POJO pojo = new POJO();
        System.out.println("* Calling method1 with error=false");
        SimpleAspect.clear();
        BeforeAfterThrowingTestCase.assertEquals((int)1, (int)pojo.method1(false));
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.around);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.after);
        BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.throwing);
        System.out.println("* Calling method1 with error=true");
        SimpleAspect.clear();
        try {
            pojo.method1(true);
            BeforeAfterThrowingTestCase.assertFalse((String)"Should not get here", (boolean)true);
        }
        catch (TestException e) {
            BeforeAfterThrowingTestCase.assertSame((Object)e, (Object)SimpleAspect.exception);
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.around);
        BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.after);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.throwing);
    }

    public void testSimpleWithFinally() throws Exception {
        System.out.println("=== TESING SIMPLE WITH FINALLY");
        POJO pojo = new POJO();
        System.out.println("* Calling method2 with error=false");
        SimpleAspect.clear();
        BeforeAfterThrowingTestCase.assertEquals((int)1, (int)pojo.method2(false));
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.around);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.after);
        BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.finallyAdvice);
        System.out.println("* Calling method2 with error=true");
        SimpleAspect.clear();
        try {
            pojo.method2(true);
            BeforeAfterThrowingTestCase.assertFalse((String)"Should not get here", (boolean)true);
        }
        catch (TestException e) {
            BeforeAfterThrowingTestCase.assertSame((Object)e, (Object)SimpleAspect.exception);
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.before);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.around);
        BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.after);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.throwing);
        BeforeAfterThrowingTestCase.assertTrue((boolean)SimpleAspect.finallyAdvice);
    }

    public void testNoMatchingSimple() throws Exception {
        System.out.println("=== TESING NO MATCHING SIMPLE");
        boolean thrown = false;
        try {
            new InvalidPOJO();
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            new InvalidPOJO(5);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            new InvalidPOJO(5L);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        InvalidPOJO invalidPojo = new InvalidPOJO("");
        thrown = false;
        try {
            invalidPojo.methodBefore();
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            invalidPojo.methodBefore(true);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            invalidPojo.methodAfter();
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            invalidPojo.methodAfter(true);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            new InvalidAdviceNamePOJO();
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            System.out.println(invalidPojo.i);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            System.out.println(invalidPojo.superValue);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            invalidPojo.superValue = new SuperValue(5);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            invalidPojo.subValue = new SubValue(5);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
        thrown = false;
        try {
            invalidPojo.methodAfter(new SubValue(1), 1);
        }
        catch (NoMatchingAdviceException e) {
            thrown = true;
        }
        BeforeAfterThrowingTestCase.assertTrue((boolean)thrown);
    }

    public void testArgs() throws Exception {
        System.out.println("=== TESTING WITH ARGUMENTS");
        System.out.println("* Testing ctor(boolean, int, long, String) with exception");
        ArgsAspect.clear();
        SimpleAspect.clear();
        try {
            POJO pojo = new POJO(true, 1, 1L, "x");
            throw new RuntimeException("TestException not thrown");
        }
        catch (TestException e) {
            BeforeAfterThrowingTestCase.assertEquals((String)"before1", (String)ArgsAspect.before);
            BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.after);
            BeforeAfterThrowingTestCase.assertEquals((String)"throwing1", (String)ArgsAspect.throwing);
            BeforeAfterThrowingTestCase.assertSame((Object)e, (Object)ArgsAspect.exception);
            System.out.println("* Testing ctor(boolean, int, long, String)");
            ArgsAspect.clear();
            POJO pojo = new POJO(false, 2, 3L, "y");
            BeforeAfterThrowingTestCase.assertEquals((String)"before1", (String)ArgsAspect.before);
            BeforeAfterThrowingTestCase.assertEquals((String)"after2", (String)ArgsAspect.after);
            BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
            SimpleAspect.clear();
            System.out.println("* Testing method(boolean, int, long, String) with exception");
            ArgsAspect.clear();
            try {
                pojo.method(true, 10, 100L, "abc");
                throw new RuntimeException("TestException not thrown");
            }
            catch (TestException e2) {
                BeforeAfterThrowingTestCase.assertSame((Object)e2, (Object)ArgsAspect.exception);
                System.out.println("* Testing method(boolean, int, long, String)");
                ArgsAspect.clear();
                pojo.method(false, 10, 100L, "abc");
                System.out.println("* Testing method(boolean, int, long, String, int) with exception");
                ArgsAspect.clear();
                try {
                    POJO ret = pojo.method(true, 10, 100L, "abc", 25);
                    throw new RuntimeException("TestException not thrown");
                }
                catch (TestException e3) {
                    BeforeAfterThrowingTestCase.assertSame((Object)e3, (Object)ArgsAspect.exception);
                    BeforeAfterThrowingTestCase.assertEquals((String)"before2", (String)ArgsAspect.before);
                    BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.after);
                    BeforeAfterThrowingTestCase.assertEquals((String)"throwing3", (String)ArgsAspect.throwing);
                    System.out.println("* Testing method(boolean, int, long, String, int)");
                    ArgsAspect.clear();
                    POJO ret = pojo.method(false, 10, 100L, "abc", 25);
                    BeforeAfterThrowingTestCase.assertNotNull((Object)ret);
                    BeforeAfterThrowingTestCase.assertEquals((String)"before2", (String)ArgsAspect.before);
                    BeforeAfterThrowingTestCase.assertEquals((String)"after1", (String)ArgsAspect.after);
                    BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
                    BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.before);
                    BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.around);
                    BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.after);
                    BeforeAfterThrowingTestCase.assertFalse((boolean)SimpleAspect.throwing);
                    return;
                }
            }
        }
    }

    public void testSimpleFields() throws Exception {
        System.out.println("=== TESTING Fields");
        POJO pojo = new POJO();
        ArgsAspect.clear();
        System.out.println("* Writing i");
        pojo.i = 5;
        BeforeAfterThrowingTestCase.assertEquals((String)"before3", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.after);
        ArgsAspect.clear();
        System.out.println("* Reading i");
        int i = pojo.i;
        BeforeAfterThrowingTestCase.assertEquals((String)"before4", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals(null, (String)ArgsAspect.after);
    }

    public void testFieldsWithInheritance() throws Exception {
        System.out.println("=== TESTING Fields with inheritance");
        POJO pojo = new POJO();
        ArgsAspect.clear();
        System.out.println("* Writing superValue");
        pojo.superValue = new SuperValue(5);
        BeforeAfterThrowingTestCase.assertEquals((String)"before4", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertNull(null, (Object)ArgsAspect.after);
        ArgsAspect.clear();
        System.out.println("* Reading superValue");
        SuperValue superVal = pojo.superValue;
        BeforeAfterThrowingTestCase.assertEquals((String)"before4", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after5", (String)ArgsAspect.after);
        BeforeAfterThrowingTestCase.assertEquals((int)10, (int)superVal.getValue());
        ArgsAspect.clear();
        System.out.println("* Writing subValue");
        pojo.subValue = new SubValue(5);
        BeforeAfterThrowingTestCase.assertEquals((String)"before5", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals(null, (String)ArgsAspect.after);
        ArgsAspect.clear();
        System.out.println("* Writing subValue");
        SubValue subVal = pojo.subValue;
        BeforeAfterThrowingTestCase.assertEquals((String)"before4", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after4", (String)ArgsAspect.after);
        BeforeAfterThrowingTestCase.assertEquals((int)10, (int)subVal.getValue());
    }

    public void testMethodsWithInheritance() {
        System.out.println("=== TESTING METHODS WITH INHERITANCE OF RETURN AND PARAMETERS");
        GeneralAspect.clear();
        System.out.println(" * Testing constructor(SuperValue, int)");
        SuperValue superValue = new SuperValue(5);
        POJO pojo = new POJO(superValue, 5);
        BeforeAfterThrowingTestCase.assertEquals((String)"before", (String)GeneralAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after", (String)GeneralAspect.after);
        GeneralAspect.clear();
        System.out.println(" * Testing constructor(SubValue, int)");
        SubValue subValue = new SubValue(6);
        POJO pojo2 = new POJO(subValue, 6);
        BeforeAfterThrowingTestCase.assertEquals((String)"before", (String)GeneralAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after", (String)GeneralAspect.after);
        GeneralAspect.clear();
        System.out.println(" * Testing method(SubValue, int)");
        subValue = pojo.method(subValue, 5);
        BeforeAfterThrowingTestCase.assertEquals((String)"before", (String)GeneralAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after", (String)GeneralAspect.after);
        GeneralAspect.clear();
        System.out.println(" * Testing method(SuperValue, int)");
        superValue = pojo.method(superValue, 10);
        BeforeAfterThrowingTestCase.assertEquals((String)"before", (String)GeneralAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after", (String)GeneralAspect.after);
        ArgsAspect.clear();
        System.out.println(" * Testing method(SubValue, SubValue)");
        SuperValue ret = pojo.method(new SubValue(5), new SubValue(6));
        BeforeAfterThrowingTestCase.assertEquals((String)"before6", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after6", (String)ArgsAspect.after);
        ArgsAspect.clear();
        System.out.println(" * Testing method(SuperValue, SubValue)");
        pojo.method(new SuperValue(7), new SubValue(8));
        BeforeAfterThrowingTestCase.assertEquals((String)"before7", (String)ArgsAspect.before);
        BeforeAfterThrowingTestCase.assertNull((Object)ArgsAspect.throwing);
        BeforeAfterThrowingTestCase.assertEquals((String)"after7", (String)ArgsAspect.after);
    }
}

