/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.aop.unit.assignability;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.jboss.aop.advice.annotation.assignability.AssignabilityAlgorithm;
import org.jboss.aop.advice.annotation.assignability.VariableHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromVariableAlgorithmTest
extends TestCase {
    AssignabilityAlgorithm algorithm;
    VariableHierarchy hierarchy;
    private static Class[] NO_ARGS = new Class[0];

    public void setUp() {
        this.algorithm = AssignabilityAlgorithm.FROM_VARIABLE;
        this.hierarchy = new VariableHierarchy();
    }

    private boolean runAlgorithm(int callerNumber, int calledNumber) throws Exception {
        Method caller = ((Object)((Object)this)).getClass().getDeclaredMethod("caller" + callerNumber, NO_ARGS);
        Method called = ((Object)((Object)this)).getClass().getDeclaredMethod("called" + calledNumber, NO_ARGS);
        return this.algorithm.isAssignable(caller.getGenericReturnType(), called.getGenericReturnType(), this.hierarchy);
    }

    Collection<String> caller1() {
        return this.called1();
    }

    <A> Collection<A> called1() {
        return null;
    }

    public void test1() throws Exception {
        FromVariableAlgorithmTest.assertTrue((boolean)this.runAlgorithm(1, 1));
    }

    Collection<String> caller2() {
        return this.called2();
    }

    <A extends String> Collection<A> called2() {
        return null;
    }

    public void test2() throws Exception {
        FromVariableAlgorithmTest.assertTrue((boolean)this.runAlgorithm(2, 2));
    }

    Collection<Runnable> caller3() {
        return null;
    }

    public void test3() throws Exception {
        FromVariableAlgorithmTest.assertFalse((boolean)this.runAlgorithm(3, 2));
    }

    Collection<?> caller4() {
        return null;
    }

    <A extends String> Collection<A> called4() {
        return null;
    }

    public void test4() throws Exception {
        FromVariableAlgorithmTest.assertTrue((boolean)this.runAlgorithm(4, 4));
    }

    Collection<? extends Runnable> caller5() {
        return null;
    }

    public void test5() throws Exception {
        FromVariableAlgorithmTest.assertFalse((boolean)this.runAlgorithm(5, 4));
    }

    Collection<?> caller6() {
        return this.called6();
    }

    <A> Collection<A> called6() {
        return null;
    }

    public void test6() throws Exception {
        FromVariableAlgorithmTest.assertTrue((boolean)this.runAlgorithm(6, 6));
    }

    Collection<? extends Runnable> caller7() {
        return this.called6();
    }

    public void test7() throws Exception {
        FromVariableAlgorithmTest.assertTrue((boolean)this.runAlgorithm(7, 6));
    }

    Collection<?> caller8(Collection<Runnable> arg) {
        return this.called8(arg);
    }

    <A> Collection<A> called8(Collection<A> arg) {
        return null;
    }

    public void test8() throws Exception {
        Method caller = ((Object)((Object)this)).getClass().getDeclaredMethod("caller8", Collection.class);
        Method called = ((Object)((Object)this)).getClass().getDeclaredMethod("called8", Collection.class);
        FromVariableAlgorithmTest.assertTrue((boolean)AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(called.getGenericParameterTypes()[0], caller.getGenericParameterTypes()[0], this.hierarchy));
        FromVariableAlgorithmTest.assertTrue((boolean)this.algorithm.isAssignable(caller.getGenericReturnType(), called.getGenericReturnType(), this.hierarchy));
    }

    Collection<? extends Runnable> caller9(Collection<Runnable> arg) {
        return this.called8(arg);
    }

    public void test9() throws Exception {
        Method caller = ((Object)((Object)this)).getClass().getDeclaredMethod("caller9", Collection.class);
        Method called = ((Object)((Object)this)).getClass().getDeclaredMethod("called8", Collection.class);
        FromVariableAlgorithmTest.assertTrue((boolean)AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(called.getGenericParameterTypes()[0], caller.getGenericParameterTypes()[0], this.hierarchy));
        FromVariableAlgorithmTest.assertTrue((boolean)this.algorithm.isAssignable(caller.getGenericReturnType(), called.getGenericReturnType(), this.hierarchy));
    }

    Collection<Runnable> caller10(Collection<Runnable> arg) {
        return this.called8(arg);
    }

    public void test10() throws Exception {
        Method caller = ((Object)((Object)this)).getClass().getDeclaredMethod("caller10", Collection.class);
        Method called = ((Object)((Object)this)).getClass().getDeclaredMethod("called8", Collection.class);
        FromVariableAlgorithmTest.assertTrue((boolean)AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(called.getGenericParameterTypes()[0], caller.getGenericParameterTypes()[0], this.hierarchy));
        FromVariableAlgorithmTest.assertTrue((boolean)this.algorithm.isAssignable(caller.getGenericReturnType(), called.getGenericReturnType(), this.hierarchy));
    }

    Collection<? extends List> caller11(Collection<Runnable> arg) {
        return null;
    }

    public void test11() throws Exception {
        Method caller = ((Object)((Object)this)).getClass().getDeclaredMethod("caller11", Collection.class);
        Method called = ((Object)((Object)this)).getClass().getDeclaredMethod("called8", Collection.class);
        FromVariableAlgorithmTest.assertTrue((boolean)AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(called.getGenericParameterTypes()[0], caller.getGenericParameterTypes()[0], this.hierarchy));
        FromVariableAlgorithmTest.assertFalse((boolean)this.algorithm.isAssignable(caller.getGenericReturnType(), called.getGenericReturnType(), this.hierarchy));
    }
}

