/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.beans.info.plugins.DefaultPropertyInfo;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.beans.info.spi.EventInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.WeakValueHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanInfoFactory
implements BeanInfoFactory {
    protected Map<ClassLoader, Map<ClassInfo, Map<BeanAccessMode, BeanInfo>>> cache = new WeakHashMap<ClassLoader, Map<ClassInfo, Map<BeanAccessMode, BeanInfo>>>();

    protected static boolean isGetter(MethodInfo minfo) {
        String name = minfo.getName();
        TypeInfo returnType = minfo.getReturnType();
        TypeInfo[] parameters = minfo.getParameterTypes();
        if (name.length() > 3 && name.startsWith("get") || name.length() > 2 && name.startsWith("is")) {
            if (name.startsWith("is") && !PrimitiveInfo.BOOLEAN.equals(returnType)) {
                return false;
            }
            if (parameters.length == 0 && !PrimitiveInfo.VOID.equals(returnType)) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isSetter(MethodInfo minfo) {
        String name = minfo.getName();
        TypeInfo returnType = minfo.getReturnType();
        TypeInfo[] parameters = minfo.getParameterTypes();
        return name.length() > 3 && name.startsWith("set") && parameters.length == 1 && PrimitiveInfo.VOID.equals(returnType);
    }

    protected static String getUpperPropertyName(String name) {
        int start = 3;
        if (name.startsWith("is")) {
            start = 2;
        }
        return name.substring(start);
    }

    protected static String getLowerPropertyName(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        JBossStringBuilder buffer = new JBossStringBuilder(name.length());
        buffer.append(Character.toLowerCase(name.charAt(0)));
        if (name.length() > 1) {
            buffer.append(name.substring(1));
        }
        return buffer.toString();
    }

    @Override
    public BeanInfo getBeanInfo(ClassAdapter classAdapter) {
        return this.getBeanInfo(classAdapter, BeanAccessMode.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanInfo getBeanInfo(ClassAdapter classAdapter, BeanAccessMode accessMode) {
        if (classAdapter == null) {
            throw new IllegalArgumentException("Null class adapter.");
        }
        if (accessMode == null) {
            accessMode = BeanAccessMode.STANDARD;
        }
        Map<ClassLoader, Map<ClassInfo, Map<BeanAccessMode, BeanInfo>>> map = this.cache;
        synchronized (map) {
            BeanInfo info;
            ClassLoader cl = classAdapter.getClassLoader();
            ClassInfo classInfo = classAdapter.getClassInfo();
            Map<ClassInfo, Map<BeanAccessMode, BeanInfo>> classInfoMap = this.cache.get(cl);
            Map<BeanAccessMode, BeanInfo> modeMap = null;
            if (classInfoMap != null && (modeMap = classInfoMap.get(classInfo)) != null && (info = modeMap.get((Object)accessMode)) != null) {
                return info;
            }
            Set<ConstructorInfo> constructors = this.getConstructors(classInfo);
            Set<MethodInfo> methods = this.getMethods(classInfo);
            Set<PropertyInfo> properties = classInfo.isAnnotation() ? this.getAnnotationProperties(methods) : this.getBeanProperties(methods);
            Set<EventInfo> events = this.getEvents(classInfo);
            BeanInfo result = this.createBeanInfo(classAdapter, accessMode, properties, constructors, methods, events);
            if (classInfoMap == null) {
                classInfoMap = new WeakHashMap<ClassInfo, Map<BeanAccessMode, BeanInfo>>();
                this.cache.put(cl, classInfoMap);
            }
            if (modeMap == null) {
                modeMap = new WeakValueHashMap<BeanAccessMode, BeanInfo>();
                classInfoMap.put(classInfo, modeMap);
            }
            modeMap.put(accessMode, result);
            return result;
        }
    }

    protected BeanInfo createBeanInfo(ClassAdapter classAdapter, BeanAccessMode accessMode, Set<PropertyInfo> properties, Set<ConstructorInfo> constructors, Set<MethodInfo> methods, Set<EventInfo> events) {
        return accessMode.create(this, classAdapter, properties, constructors, methods, events);
    }

    protected Set<ConstructorInfo> getConstructors(ClassInfo classInfo) {
        ConstructorInfo[] cinfos = classInfo.getDeclaredConstructors();
        if (cinfos == null || cinfos.length == 0) {
            return null;
        }
        HashSet<ConstructorInfo> result = new HashSet<ConstructorInfo>();
        for (int i = 0; i < cinfos.length; ++i) {
            if (!cinfos[i].isPublic() || cinfos[i].isStatic()) continue;
            result.add(cinfos[i]);
        }
        return result;
    }

    protected Set<MethodInfo> getMethods(ClassInfo classInfo) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] minfos = classInfo.getDeclaredMethods();
            if (minfos != null && minfos.length > 0) {
                for (int i = 0; i < minfos.length; ++i) {
                    if (result.contains(minfos[i]) || !minfos[i].isPublic() || minfos[i].isStatic() || minfos[i].isVolatile()) continue;
                    result.add(minfos[i]);
                }
            }
            classInfo = classInfo.getSuperclass();
        }
        return result;
    }

    protected Set<PropertyInfo> getBeanProperties(Set<MethodInfo> methods) {
        String name;
        HashMap<String, MethodInfo> getters = new HashMap<String, MethodInfo>();
        HashMap<String, ArrayList<MethodInfo>> setters = new HashMap<String, ArrayList<MethodInfo>>();
        if (!methods.isEmpty()) {
            for (MethodInfo methodInfo : methods) {
                String upperName;
                String name2 = methodInfo.getName();
                if (AbstractBeanInfoFactory.isGetter(methodInfo)) {
                    upperName = AbstractBeanInfoFactory.getUpperPropertyName(name2);
                    getters.put(upperName, methodInfo);
                    continue;
                }
                if (!AbstractBeanInfoFactory.isSetter(methodInfo)) continue;
                upperName = AbstractBeanInfoFactory.getUpperPropertyName(name2);
                ArrayList<MethodInfo> list = (ArrayList<MethodInfo>)setters.get(upperName);
                if (list == null) {
                    list = new ArrayList<MethodInfo>();
                    setters.put(upperName, list);
                }
                list.add(methodInfo);
            }
        }
        HashSet<PropertyInfo> properties = new HashSet<PropertyInfo>();
        if (!getters.isEmpty()) {
            for (Map.Entry entry : getters.entrySet()) {
                name = (String)entry.getKey();
                MethodInfo getter = (MethodInfo)entry.getValue();
                AnnotatedInfo setter = null;
                List setterList = (List)setters.remove(name);
                if (setterList != null && setterList.size() != 0) {
                    for (int j = 0; j < setterList.size(); ++j) {
                        MethodInfo thisSetter = (MethodInfo)setterList.get(j);
                        TypeInfo pinfo = thisSetter.getParameterTypes()[0];
                        if (!getter.getReturnType().equals(pinfo)) continue;
                        setter = thisSetter;
                        break;
                    }
                }
                String lowerName = AbstractBeanInfoFactory.getLowerPropertyName(name);
                AnnotationValue[] annotations = getter.getAnnotations();
                AnnotationValue[] setterAnnotations = null;
                if (setter != null) {
                    setterAnnotations = setter.getAnnotations();
                }
                annotations = AbstractBeanInfoFactory.mergeAnnotations(annotations, setterAnnotations);
                TypeInfo type = this.getPropertyType(getter, (MethodInfo)setter);
                properties.add(new DefaultPropertyInfo(lowerName, name, type, getter, (MethodInfo)setter, annotations));
            }
        }
        if (!setters.isEmpty()) {
            for (Map.Entry entry : setters.entrySet()) {
                name = (String)entry.getKey();
                List setterList = (List)entry.getValue();
                for (MethodInfo setter : setterList) {
                    TypeInfo pinfo = setter.getParameterTypes()[0];
                    String lowerName = AbstractBeanInfoFactory.getLowerPropertyName(name);
                    AnnotationValue[] annotations = setter.getAnnotations();
                    properties.add(new DefaultPropertyInfo(lowerName, name, pinfo, null, setter, annotations));
                }
            }
        }
        return properties;
    }

    static AnnotationValue[] mergeAnnotations(AnnotationValue[] first, AnnotationValue[] second) {
        if (first == null || first.length == 0) {
            first = second;
        } else if (second != null && second.length > 0) {
            HashSet<AnnotationValue> merged = new HashSet<AnnotationValue>();
            for (AnnotationValue annotation : first) {
                merged.add(annotation);
            }
            for (AnnotationValue annotation : second) {
                merged.add(annotation);
            }
            first = merged.toArray(new AnnotationValue[merged.size()]);
        }
        return first;
    }

    protected TypeInfo getPropertyType(MethodInfo getter, MethodInfo setter) {
        if (getter == null) {
            throw new IllegalArgumentException("Getter should not be null!");
        }
        if (setter == null) {
            return getter.getReturnType();
        }
        return getter.getReturnType();
    }

    protected Set<PropertyInfo> getAnnotationProperties(Set<MethodInfo> methods) {
        HashSet<PropertyInfo> properties = new HashSet<PropertyInfo>();
        if (methods != null && !methods.isEmpty()) {
            for (MethodInfo method : methods) {
                TypeInfo returnType = method.getReturnType();
                TypeInfo[] parameters = method.getParameterTypes();
                if (parameters.length != 0 || PrimitiveInfo.VOID.equals(returnType)) continue;
                String name = method.getName();
                properties.add(new DefaultPropertyInfo(name, name, returnType, method, null, method.getAnnotations()));
            }
        }
        return properties;
    }

    protected Set<EventInfo> getEvents(ClassInfo classInfo) {
        return null;
    }
}

